/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.audit.records;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.qubership.kafka.security.audit.history.CEFHistoryRecord;

public abstract class AbstractAuditRecord
implements CEFHistoryRecord {
    private static final String USERNAME_EXTENSION_TAG = "suser";
    private static final String CLIENT_IP_EXTENSION_TAG = "src";
    private static final String TYPE_EXTENSION_TAG = "type";
    private static final String AUDIT_TYPE_EXTENSION_VALUE = "audit_log_type";
    private static final String RESULT_EXTENSION_TAG = "result";
    protected final String principalName;
    protected final String clientIp;
    protected final boolean result;
    private final Date recordDate;

    public AbstractAuditRecord(String principalName, String clientIp, boolean result) {
        this.principalName = principalName;
        this.clientIp = clientIp;
        this.result = result;
        this.recordDate = new Date();
    }

    @Override
    public Date getTimestamp() {
        return this.recordDate;
    }

    @Override
    public String getCategory() {
        return "kafka.audit";
    }

    @Override
    public Map<String, String> getExtension() {
        HashMap<String, String> extensionMap = new HashMap<String, String>();
        if (this.principalName != null) {
            extensionMap.put(USERNAME_EXTENSION_TAG, this.principalName);
        }
        if (this.clientIp != null) {
            extensionMap.put(CLIENT_IP_EXTENSION_TAG, this.clientIp);
        }
        extensionMap.put(RESULT_EXTENSION_TAG, this.result ? "successful" : "failed");
        this.enrichExtension(extensionMap);
        extensionMap.put(TYPE_EXTENSION_TAG, AUDIT_TYPE_EXTENSION_VALUE);
        return extensionMap;
    }

    protected abstract void enrichExtension(Map<String, String> var1);
}

