/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.oauthbearer;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.text.ParseException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.qubership.kafka.security.audit.AuditRecordWriter;
import org.qubership.kafka.security.audit.records.AuthenticationAuditRecord;
import org.qubership.kafka.security.oauthbearer.AbstractOAuthBearerCallbackHandler;
import org.qubership.kafka.security.oauthbearer.IdentityProviderUrlResolver;
import org.qubership.kafka.security.oauthbearer.IssuerNotTrustedException;
import org.qubership.kafka.security.oauthbearer.JWSVerificationKeySelectorExtended;
import org.qubership.kafka.security.oauthbearer.OAuthBearerJwt;
import org.qubership.kafka.security.oauthbearer.OAuthLoginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerValidatorCallbackHandler
extends AbstractOAuthBearerCallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthBearerValidatorCallbackHandler.class);
    private static final String CLOCK_SKEW = "clockSkew";
    private static final String JWKS_CONNECTION_TIMEOUT = "jwksConnectionTimeout";
    private static final String JWKS_READ_TIMEOUT = "jwksReadTimeout";
    private static final String JWKS_SIZE_LIMIT = "jwksSizeLimit";
    private static final String IDP_WHITELIST = "idpWhitelist";
    private static final String TOKEN_ROLES_PATH = "tokenRolesPath";
    private static final String JWK_SOURCE_TYPE = "jwkSourceType";
    private static final String KEYSTORE_PATH = "keystorePath";
    private static final String KEYSTORE_PASSWORD = "keystorePassword";
    private static final String KEYSTORE_TYPE = "keystoreType";
    private static final String JWKS_SOURCE_TYPE = "jwks";
    private static final String KEYSTORE_SOURCE_TYPE = "keystore";
    private static final String TOKEN_ROLES_PATH_DEFAULT_VALUE = "resource_access.account.roles";
    private static final String JWK_SOURCE_TYPE_DEFAULT_VALUE = "jwks";
    private static final String KEYSTORE_PATH_DEFAULT_VALUE = "/opt/kafka/config/public_certs.jks";
    private static final String KEYSTORE_TYPE_DEFAULT_VALUE = "JKS";
    private static final boolean REPLACE_HOST_AND_PORT = OAuthBearerValidatorCallbackHandler.getBooleanEnv("REPLACE_INTERNAL_HOST_ENABLED");
    @Nonnull
    private final ConcurrentMap<String, JWKSource<SecurityContext>> jwks = new ConcurrentHashMap<String, JWKSource<SecurityContext>>();
    private JWTClaimsSetVerifier<SecurityContext> claimsVerifier;
    private int jwksConnectionTimeout;
    private int jwksReadTimeout;
    private int jwksSizeLimit;
    private IdentityProviderUrlResolver identityProviderUrlResolver;
    private String tokenRolesPath;
    private String jwkSourceType;
    private String keystorePath;
    private String keystorePassword;
    private String keystoreType;
    private Client client;

    private static boolean getBooleanEnv(String key) {
        String env = System.getenv(key);
        return env == null ? false : "true".equals(env);
    }

    @Nonnull
    private static JWTClaimsSetVerifier<SecurityContext> createClaimsVerifier(int maxClockSkew) {
        DefaultJWTClaimsVerifier claimsVerifier = new DefaultJWTClaimsVerifier();
        claimsVerifier.setMaxClockSkew(maxClockSkew);
        return claimsVerifier;
    }

    private static int extractInt(@Nonnull Map<String, String> options, @Nonnull String key, int defaultValue) {
        String value = options.get(key);
        return value == null || value.isEmpty() ? defaultValue : Integer.parseInt(value);
    }

    static String replaceHostAndPort(String internal, String external) throws URISyntaxException {
        URI externalUri = new URI(external);
        String externalHost = externalUri.getHost();
        int externalPort = externalUri.getPort();
        URI internalUri = new URI(internal);
        return UriBuilder.fromUri((URI)internalUri).host(externalHost).port(externalPort).build(new Object[0]).toString();
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        this.throwExceptionIfNotConfigured();
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerValidatorCallback) {
                OAuthBearerValidatorCallback validatorCallback = (OAuthBearerValidatorCallback)callback;
                String tokenValue = validatorCallback.tokenValue();
                if (tokenValue == null) {
                    throw new IllegalArgumentException("Callback missing required token value");
                }
                OAuthBearerJwt jwt = null;
                try {
                    jwt = new OAuthBearerJwt(tokenValue, this.tokenRolesPath);
                    validatorCallback.token(this.validateToken(jwt));
                }
                catch (MalformedURLException | URISyntaxException e) {
                    this.error(validatorCallback, "There is no response from Identity Provider with particular URL", e, jwt);
                }
                catch (ParseException e) {
                    this.error(validatorCallback, "Key selector cannot parse resource which contains public key", e, jwt);
                }
                catch (BadJOSEException e) {
                    this.error(validatorCallback, "Cannot verify token using wrong algorithm", (Exception)((Object)e), jwt);
                }
                catch (JOSEException e) {
                    this.error(validatorCallback, "Cannot verify token with wrong signature", (Exception)((Object)e), jwt);
                }
                catch (IssuerNotTrustedException e) {
                    this.error(validatorCallback, "Token issuer URL is not compliance with whitelist", e, jwt);
                }
                catch (IOException | GeneralSecurityException e) {
                    this.error(validatorCallback, "Cannot obtain public certificate from keystore", e, jwt);
                }
                catch (RuntimeException e) {
                    this.error(validatorCallback, "Cannot verify token with non-JWT structure", e, jwt);
                }
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private void error(@Nonnull OAuthBearerValidatorCallback callback, @Nonnull String description, @Nonnull Exception e, OAuthBearerJwt jwt) {
        LOGGER.error(description, (Throwable)e);
        AuditRecordWriter.getInstance().trackAuditEvent(AuthenticationAuditRecord.failed(jwt != null ? jwt.principalName() : null, "OAUTHBEARER", description, null));
        callback.error(description, null, null);
    }

    @Nonnull
    protected OAuthBearerToken validateToken(@Nonnull OAuthBearerJwt jwt) throws IOException, URISyntaxException, BadJOSEException, ParseException, JOSEException, IssuerNotTrustedException, GeneralSecurityException {
        String identityProviderUrl = this.identityProviderUrlResolver.resolveUrl(jwt.issuer());
        JWKSource<SecurityContext> keySource = (JWKSource<SecurityContext>)this.jwks.get(identityProviderUrl);
        if (keySource == null) {
            if (KEYSTORE_SOURCE_TYPE.equalsIgnoreCase(this.jwkSourceType)) {
                KeyStore keyStore = KeyStore.getInstance(this.keystoreType);
                char[] password = this.keystorePassword != null ? this.keystorePassword.toCharArray() : null;
                keyStore.load(new FileInputStream(this.keystorePath), password);
                JWKSet jwkSet = JWKSet.load((KeyStore)keyStore, null);
                keySource = new ImmutableJWKSet(jwkSet);
            } else {
                String jwkUri = this.getJwkFromOpenIdConfig(identityProviderUrl);
                DefaultResourceRetriever resourceRetriever = new DefaultResourceRetriever(this.jwksConnectionTimeout, this.jwksReadTimeout, this.jwksSizeLimit);
                keySource = new RemoteJWKSet(new URL(jwkUri), (ResourceRetriever)resourceRetriever);
            }
            JWKSource<SecurityContext> previousKeySource = this.jwks.putIfAbsent(identityProviderUrl, keySource);
            if (previousKeySource != null) {
                keySource = previousKeySource;
            }
        }
        this.verifySignature(keySource, jwt.algorithm(), jwt.value());
        LOGGER.info("Successfully validated token with principal: {}", (Object)jwt.principalName());
        return jwt;
    }

    @Nonnull
    private String getJwkFromOpenIdConfig(@Nonnull String identityProviderUrl) throws URISyntaxException {
        String jwkUri = this.getJwkEndpointUrl(identityProviderUrl);
        if (jwkUri == null || jwkUri.isEmpty()) {
            throw new IllegalArgumentException("jwks_uri does not present in openid configuration");
        }
        if (jwkUri.startsWith("/")) {
            jwkUri = OAuthLoginUtils.normalizeUrl((String)(identityProviderUrl + jwkUri));
        }
        if (REPLACE_HOST_AND_PORT) {
            jwkUri = OAuthBearerValidatorCallbackHandler.replaceHostAndPort(jwkUri, identityProviderUrl);
        }
        LOGGER.trace("jwk uri from openid configuration: {}", (Object)jwkUri);
        return jwkUri;
    }

    @Nullable
    private String getJwkEndpointUrl(@Nonnull String identityProviderUrl) throws URISyntaxException {
        String configurationUrl = OAuthLoginUtils.normalizeUrl((String)(identityProviderUrl + "/.well-known/openid-configuration"));
        WebTarget webTarget = this.client.target(configurationUrl);
        Map response = (Map)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Map.class);
        Objects.requireNonNull(response, () -> String.format("JWK endpoint cannot be obtained: invalid response from: %s", configurationUrl));
        return (String)response.get("jwks_uri");
    }

    private void verifySignature(@Nonnull JWKSource<SecurityContext> keySource, @Nonnull JWSAlgorithm expectedAlgorithm, @Nonnull String token) throws ParseException, BadJOSEException, JOSEException {
        JWSVerificationKeySelectorExtended<SecurityContext> keySelector = new JWSVerificationKeySelectorExtended<SecurityContext>(expectedAlgorithm, keySource);
        DefaultJWTProcessor processor = new DefaultJWTProcessor();
        processor.setJWSKeySelector(keySelector);
        processor.setJWTClaimsSetVerifier(this.claimsVerifier);
        processor.process(token, null);
    }

    void configureOptions(@Nonnull Map<String, String> options) {
        int clockSkew = OAuthBearerValidatorCallbackHandler.extractInt(options, CLOCK_SKEW, 10);
        this.claimsVerifier = OAuthBearerValidatorCallbackHandler.createClaimsVerifier(clockSkew);
        this.jwksConnectionTimeout = OAuthBearerValidatorCallbackHandler.extractInt(options, JWKS_CONNECTION_TIMEOUT, 1000);
        this.jwksReadTimeout = OAuthBearerValidatorCallbackHandler.extractInt(options, JWKS_READ_TIMEOUT, 1000);
        this.jwksSizeLimit = OAuthBearerValidatorCallbackHandler.extractInt(options, JWKS_SIZE_LIMIT, 51200);
        String idpWhitelist = options.get(IDP_WHITELIST);
        this.identityProviderUrlResolver = IdentityProviderUrlResolver.create(idpWhitelist);
        this.tokenRolesPath = options.getOrDefault(TOKEN_ROLES_PATH, TOKEN_ROLES_PATH_DEFAULT_VALUE);
        this.jwkSourceType = options.getOrDefault(JWK_SOURCE_TYPE, "jwks");
        if (!KEYSTORE_SOURCE_TYPE.equalsIgnoreCase(this.jwkSourceType)) {
            this.client = OAuthLoginUtils.createClient((Logger)LOGGER);
        }
        this.keystorePath = options.getOrDefault(KEYSTORE_PATH, KEYSTORE_PATH_DEFAULT_VALUE);
        this.keystorePassword = options.get(KEYSTORE_PASSWORD);
        this.keystoreType = options.getOrDefault(KEYSTORE_TYPE, KEYSTORE_TYPE_DEFAULT_VALUE);
        AuditRecordWriter.getInstance().configure(options);
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

