/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.audit.history;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qubership.kafka.security.audit.history.CEFHistoryRecord;
import org.qubership.kafka.security.audit.history.CEFSettings;
import org.qubership.kafka.security.audit.history.ConcurrencyMode;
import org.qubership.kafka.security.audit.history.HistoryWriter;
import org.qubership.kafka.security.audit.history.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Writer(concurrencyMode=ConcurrencyMode.ASYNC_ORDERED, trackChildRecords=true)
public class CEFLog4jHistoryWriter
implements HistoryWriter<CEFHistoryRecord> {
    private static final int DEFAULT_SEVERITY = 5;
    private static final ConcurrentHashMap<String, Logger> loggers = new ConcurrentHashMap();
    private final CEFSettings cefSettings;
    private final String cefMessageTemplate;

    public CEFLog4jHistoryWriter(CEFSettings cefSettings) {
        this.cefSettings = cefSettings;
        this.cefMessageTemplate = "CEF:" + cefSettings.getCEFVersion() + '|' + this.escapeSymbols(cefSettings.getDeviceVendor(), true) + '|' + this.escapeSymbols(cefSettings.getDeviceProduct(), true) + '|' + this.escapeSymbols(cefSettings.getDeviceVersion(), true) + "|%s|%s|%d|%s";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void write(CEFHistoryRecord historyRecord) {
        String category = historyRecord.getCategory();
        Logger logger = loggers.get(category);
        if (logger == null) {
            logger = LoggerFactory.getLogger((String)category);
            loggers.put(category, logger);
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format(this.cefMessageTemplate, this.escapeSymbols(historyRecord.getOperationType(), true), this.escapeSymbols(historyRecord.getName(), true), MoreObjects.firstNonNull((Object)this.cefSettings.getSeverityMap().get(historyRecord.getOperationType()), (Object)5), this.generateExtensionField(historyRecord.getExtension())));
        }
    }

    private String generateExtensionField(Map<String, String> extension) {
        StringBuilder extensionFieldBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> extensionEntriesIterator = extension.entrySet().iterator();
        while (extensionEntriesIterator.hasNext()) {
            Map.Entry<String, String> extensionEntry = extensionEntriesIterator.next();
            String extensionKey = extensionEntry.getKey();
            String extensionValue = Strings.nullToEmpty((String)extensionEntry.getValue());
            if (extensionKey.contains(" ")) {
                throw new IllegalArgumentException("Space symbol found in key=\"" + extensionKey + "\". Space symbols aren't allowed in extension keys.");
            }
            extensionFieldBuilder.append(this.escapeSymbols(extensionKey, false)).append('=').append(this.escapeSymbols(extensionValue, false));
            if (!extensionEntriesIterator.hasNext()) continue;
            extensionFieldBuilder.append(' ');
        }
        return extensionFieldBuilder.toString();
    }

    private String escapeSymbols(String value, boolean isPrefixPart) {
        StringBuilder buffer = new StringBuilder();
        block7: for (int i = 0; i < value.length(); ++i) {
            char currentSymbol = value.charAt(i);
            switch (currentSymbol) {
                case '|': {
                    if (isPrefixPart) {
                        buffer.append("\\|");
                        continue block7;
                    }
                    buffer.append(currentSymbol);
                    continue block7;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block7;
                }
                case '=': {
                    if (isPrefixPart) {
                        buffer.append(currentSymbol);
                        continue block7;
                    }
                    buffer.append("\\=");
                    continue block7;
                }
                case '\n': {
                    if (isPrefixPart) continue block7;
                    buffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    if (isPrefixPart) continue block7;
                    buffer.append("\\r");
                    continue block7;
                }
                default: {
                    buffer.append(currentSymbol);
                }
            }
        }
        return buffer.toString();
    }
}

