/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.audit.records;

import java.util.Map;
import javax.annotation.Nonnull;
import org.qubership.kafka.security.audit.records.AbstractAuditRecord;

public class AuthenticationAuditRecord
extends AbstractAuditRecord {
    private static final String AUTHENTICATION_EVENT_TYPE = "AUTHENTICATION_EVENT";
    private static final String AUTHENTICATION_FAILED_TYPE = "AUTHENTICATION_FAILED";
    @Nonnull
    private final String authenticationType;
    private final String reason;

    private AuthenticationAuditRecord(String principalName, String clientIp, @Nonnull String authenticationType, boolean result, String reason) {
        super(principalName, clientIp, result);
        this.authenticationType = authenticationType;
        this.reason = reason;
    }

    public static AuthenticationAuditRecord successful(@Nonnull String principalName, @Nonnull String authenticationType, String clientIp) {
        return new AuthenticationAuditRecord(principalName, clientIp, authenticationType, true, null);
    }

    public static AuthenticationAuditRecord failed(String principalName, @Nonnull String authenticationType, @Nonnull String reason, String clientIp) {
        return new AuthenticationAuditRecord(principalName, clientIp, authenticationType, false, reason);
    }

    @Override
    public String getName() {
        return this.result ? String.format("Successful authentication for principal '%s' with client IP '%s'", this.principalName, this.clientIp) : String.format("Failed authentication for principal '%s' with client IP '%s': %s", this.principalName, this.clientIp, this.reason);
    }

    @Override
    public String getOperationType() {
        return this.result ? AUTHENTICATION_EVENT_TYPE : AUTHENTICATION_FAILED_TYPE;
    }

    @Override
    protected void enrichExtension(Map<String, String> extension) {
        extension.put("authenticationType", this.authenticationType);
    }
}

