/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.authorization;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import kafka.security.authorizer.AclAuthorizer;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.security.authorizer.AclEntry;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.qubership.kafka.security.authorization.AclMatcher;
import org.qubership.kafka.security.authorization.ExtendedAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedAclAuthorizer
extends AclAuthorizer
implements ExtendedAuthorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedAclAuthorizer.class);
    private boolean shouldAllowEveryoneIfNoAclIsFound = false;
    private volatile Set<String> superUsers = new HashSet<String>();

    public void configure(Map<String, ?> javaConfigs) {
        LOGGER.debug("Configuration is {}", javaConfigs);
        this.shouldAllowEveryoneIfNoAclIsFound = Boolean.parseBoolean(String.valueOf(javaConfigs.get("allow.everyone.if.no.acl.found")));
        super.configure(javaConfigs);
        this.superUsers = this.getSuperUsers(javaConfigs);
    }

    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        return actions.stream().map(action -> this.customAuthorizeAction(requestContext, (Action)action)).collect(Collectors.toList());
    }

    @Override
    public boolean aclsAllowAccess(AclOperation operation, ResourcePattern resource, String host, String requestPrincipalType, Set<String> requestPrincipalNames) {
        Set<AclEntry> aclSet = this.getAclSetByResource(resource);
        LOGGER.debug("ACL set for resource {} is {}", (Object)resource, aclSet);
        return this.isAclEmptyAndEveryoneIsAllowed(aclSet, resource) || !this.denyAclExists(aclSet, operation, host, requestPrincipalType, requestPrincipalNames) && this.allowAclExists(aclSet, operation, host, requestPrincipalType, requestPrincipalNames);
    }

    @Override
    public boolean isSuperUser(KafkaPrincipal principal) {
        return this.superUsers.contains(principal.toString());
    }

    private Set<AclEntry> getAclSetByResource(ResourcePattern resource) {
        AclBindingFilter filter = new AclBindingFilter(new ResourcePatternFilter(resource.resourceType(), resource.name(), PatternType.MATCH), AccessControlEntryFilter.ANY);
        HashSet<AclEntry> aclSet = new HashSet<AclEntry>();
        this.acls(filter).forEach(aclBinding -> aclSet.add(new AclEntry(aclBinding.entry())));
        return aclSet;
    }

    private boolean isAclEmptyAndEveryoneIsAllowed(Set<AclEntry> aclSet, ResourcePattern resource) {
        if (aclSet.isEmpty()) {
            this.logAuthResultForEmptyAcl(resource);
            return this.shouldAllowEveryoneIfNoAclIsFound;
        }
        return false;
    }

    private void logAuthResultForEmptyAcl(ResourcePattern resource) {
        if (this.shouldAllowEveryoneIfNoAclIsFound) {
            LOGGER.trace("No ACL found for resource [{}], authorized = {}", (Object)resource, (Object)this.shouldAllowEveryoneIfNoAclIsFound);
        } else {
            LOGGER.warn("No ACL found for resource [{}], authorized = {}", (Object)resource, (Object)this.shouldAllowEveryoneIfNoAclIsFound);
        }
    }

    private boolean denyAclExists(Set<AclEntry> aclSet, AclOperation operation, String host, String requestPrincipalType, Set<String> requestPrincipalNames) {
        return this.aclMatch(aclSet, "Deny", operation.name(), host, requestPrincipalType, requestPrincipalNames);
    }

    private boolean allowAclExists(Set<AclEntry> aclSet, AclOperation operation, String host, String requestPrincipalType, Set<String> requestPrincipalNames) {
        Set operations = this.getOperationsByAclOperation(operation.name());
        for (String op : operations) {
            if (!this.aclMatch(aclSet, "Allow", op, host, requestPrincipalType, requestPrincipalNames)) continue;
            return true;
        }
        return false;
    }

    private boolean aclMatch(Set<AclEntry> aclSet, @Nonnull String permissionType, String operation, String host, String requestPrincipalType, Set<String> requestPrincipalNames) {
        for (AclEntry acl : aclSet) {
            boolean match = AclMatcher.match(acl, permissionType, operation, host, requestPrincipalType, requestPrincipalNames);
            if (!match) continue;
            LOGGER.debug("Operation = {} on resource from host = {} is {} based on ACL = {}", new Object[]{operation, host, permissionType, acl});
            return true;
        }
        return false;
    }
}

