/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.authorization;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.qubership.kafka.security.audit.AuditRecordWriter;
import org.qubership.kafka.security.audit.records.AuthorizationAuditRecord;
import org.qubership.kafka.security.oauthbearer.OAuthKafkaPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface ExtendedAuthorizer {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExtendedAuthorizer.class);
    public static final String EMPTY_ACL_LOG = "No ACL found for resource [{}], authorized = {}";
    public static final String AUTH_RESULT_LOG = "Principal = [{}] is {} Operation = [{}] from host = [{}] on resource = [{}]";
    public static final String ALLOWED = "Allowed";
    public static final String DENIED = "Denied";

    public boolean aclsAllowAccess(AclOperation var1, ResourcePattern var2, String var3, String var4, Set<String> var5);

    public boolean isSuperUser(KafkaPrincipal var1);

    default public AuthorizationResult customAuthorizeAction(AuthorizableRequestContext requestContext, Action action) {
        KafkaPrincipal principal = requestContext.principal();
        String principalName = principal.getName();
        String host = requestContext.clientAddress().getHostAddress();
        AclOperation operation = action.operation();
        ResourcePattern resource = action.resourcePattern();
        LOGGER.trace("Context is {}, principal name is {}, principal type is {}, host is {}, operation is {}, resource is {}", new Object[]{requestContext, principalName, principal.getPrincipalType(), host, operation, resource});
        if ("ANONYMOUS".equalsIgnoreCase(principalName)) {
            LOGGER.info("No ACL found for cluster authorization, user: {}", (Object)principalName);
            return AuthorizationResult.DENIED;
        }
        String requestPrincipalType = "User";
        Set requestPrincipalNames = Collections.singleton(principalName);
        if (principal instanceof OAuthKafkaPrincipal) {
            requestPrincipalType = "Role";
            requestPrincipalNames = ((OAuthKafkaPrincipal)principal).getToken().roles();
        }
        boolean isSuperUser = this.isSuperUser(new KafkaPrincipal(principal.getPrincipalType(), principalName));
        LOGGER.trace("User {} is super user: {}", (Object)principal, (Object)isSuperUser);
        boolean authorized = isSuperUser || this.aclsAllowAccess(operation, resource, host, requestPrincipalType, requestPrincipalNames);
        this.logAuthResult(authorized, principal, operation, host, resource);
        return authorized ? AuthorizationResult.ALLOWED : AuthorizationResult.DENIED;
    }

    default public void logAuthResult(boolean authorized, KafkaPrincipal principal, AclOperation operation, String host, ResourcePattern resource) {
        if (authorized) {
            LOGGER.trace(AUTH_RESULT_LOG, new Object[]{principal, ALLOWED, operation, host, resource});
        } else {
            LOGGER.warn(AUTH_RESULT_LOG, new Object[]{principal, DENIED, operation, host, resource});
        }
        AuditRecordWriter.getInstance().trackAuditEvent(new AuthorizationAuditRecord(principal, host, operation, resource, authorized));
    }

    default public Set<String> getOperationsByAclOperation(String operationName) {
        HashSet<String> operations = new HashSet<String>();
        operations.add(operationName);
        if ("Describe".equalsIgnoreCase(operationName)) {
            operations.add("Read");
            operations.add("Write");
            operations.add("Delete");
            operations.add("Alter");
        } else if ("DescribeConfigs".equalsIgnoreCase(operationName)) {
            operations.add("AlterConfigs");
        }
        return operations;
    }

    default public Set<String> getSuperUsers(Map<String, ?> configs) {
        Object configValue = configs.get("super.users");
        if (configValue == null) {
            return Collections.emptySet();
        }
        String[] configValues = configValue.toString().split(";");
        HashSet<String> superUsers = new HashSet<String>();
        for (String value : configValues) {
            String user = value.trim();
            if (user.isEmpty()) continue;
            SecurityUtils.parseKafkaPrincipal((String)user);
            superUsers.add(user);
        }
        return superUsers;
    }
}

