/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.authorization;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.message.DefaultPrincipalData;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.qubership.kafka.security.audit.AuditRecordWriter;
import org.qubership.kafka.security.audit.records.AuthenticationAuditRecord;
import org.qubership.kafka.security.oauthbearer.OAuthBearerJwt;
import org.qubership.kafka.security.oauthbearer.OAuthKafkaPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedKafkaPrincipalBuilder
implements KafkaPrincipalBuilder,
KafkaPrincipalSerde {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedKafkaPrincipalBuilder.class);
    private static final String OAUTH_BEARER_TOKEN_PROPERTY = "OAUTHBEARER.token";

    public KafkaPrincipal build(AuthenticationContext context) {
        LOGGER.debug("Used authentication context is {}", (Object)context);
        if (context instanceof PlaintextAuthenticationContext) {
            AuditRecordWriter.getInstance().trackAuditEvent(AuthenticationAuditRecord.successful(KafkaPrincipal.ANONYMOUS.getName(), "ANONYMOUS", context.clientAddress().getHostAddress()));
            return KafkaPrincipal.ANONYMOUS;
        }
        if (context instanceof SslAuthenticationContext) {
            SSLSession sslSession = ((SslAuthenticationContext)context).session();
            LOGGER.debug("Session for SslAuthenticationContext is {}", (Object)sslSession);
            try {
                KafkaPrincipal principal = new KafkaPrincipal("User", sslSession.getPeerPrincipal().getName());
                AuditRecordWriter.getInstance().trackAuditEvent(AuthenticationAuditRecord.successful(principal.getName(), "SSL", context.clientAddress().getHostAddress()));
                return principal;
            }
            catch (SSLPeerUnverifiedException se) {
                LOGGER.debug("Peer is not authenticated: ", (Throwable)se);
                AuditRecordWriter.getInstance().trackAuditEvent(AuthenticationAuditRecord.successful(KafkaPrincipal.ANONYMOUS.getName(), "ANONYMOUS", context.clientAddress().getHostAddress()));
                return KafkaPrincipal.ANONYMOUS;
            }
        }
        if (context instanceof SaslAuthenticationContext) {
            SaslServer saslServer = ((SaslAuthenticationContext)context).server();
            LOGGER.debug("Server for SaslAuthenticationContext is {}", (Object)saslServer);
            OAuthBearerToken token = (OAuthBearerToken)saslServer.getNegotiatedProperty(OAUTH_BEARER_TOKEN_PROPERTY);
            if (token == null) {
                KafkaPrincipal principal = new KafkaPrincipal("User", saslServer.getAuthorizationID());
                AuditRecordWriter.getInstance().trackAuditEvent(AuthenticationAuditRecord.successful(principal.getName(), saslServer.getMechanismName(), context.clientAddress().getHostAddress()));
                return principal;
            }
            OAuthBearerJwt jwt = token instanceof OAuthBearerJwt ? (OAuthBearerJwt)token : new OAuthBearerJwt(token.value());
            LOGGER.debug("OAuth Bearer JWT is {}", (Object)jwt);
            OAuthKafkaPrincipal principal = new OAuthKafkaPrincipal("User", saslServer.getAuthorizationID(), jwt);
            AuditRecordWriter.getInstance().trackAuditEvent(AuthenticationAuditRecord.successful(principal.getName(), saslServer.getMechanismName(), context.clientAddress().getHostAddress()));
            return principal;
        }
        throw new IllegalArgumentException("Unhandled authentication context type: " + context.getClass().getName());
    }

    public byte[] serialize(KafkaPrincipal principal) {
        DefaultPrincipalData data = new DefaultPrincipalData().setType(principal.getPrincipalType()).setName(principal.getName()).setTokenAuthenticated(principal.tokenAuthenticated());
        return MessageUtil.toVersionPrefixedBytes((short)0, (Message)data);
    }

    public KafkaPrincipal deserialize(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        short version = buffer.getShort();
        if (version < 0 || version > 0) {
            throw new SerializationException("Invalid principal data version " + version);
        }
        DefaultPrincipalData data = new DefaultPrincipalData((Readable)new ByteBufferAccessor(buffer), version);
        return new KafkaPrincipal(data.type(), data.name(), data.tokenAuthenticated());
    }
}

