/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.oauthbearer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.qubership.kafka.security.oauthbearer.IssuerNotTrustedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
final class IdentityProviderUrlResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityProviderUrlResolver.class);
    private static final String INTERNAL_FIELD = "internal";
    private static final String EXTERNAL_FILED = "external";
    @Nonnull
    private final List<Address> whitelist;

    private IdentityProviderUrlResolver(@Nonnull List<Address> whitelist) {
        this.whitelist = whitelist;
    }

    @Nonnull
    static IdentityProviderUrlResolver create(@Nullable String whitelist) {
        return new IdentityProviderUrlResolver(IdentityProviderUrlResolver.transformWhitelist(whitelist));
    }

    private static List<Address> transformWhitelist(@Nullable String whitelist) {
        JSONArray jsonWhitelist;
        if (whitelist == null || whitelist.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Address> result = new ArrayList<Address>();
        JSONParser parser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        try {
            jsonWhitelist = (JSONArray)parser.parse(whitelist);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Whitelist is in non-JSON format", e);
        }
        for (Object item : jsonWhitelist) {
            JSONObject jsonAddress = (JSONObject)item;
            String internal = jsonAddress.getAsString(INTERNAL_FIELD);
            String external = jsonAddress.getAsString(EXTERNAL_FILED);
            result.add(new Address(internal, external));
        }
        return result;
    }

    String resolveUrl(@Nonnull String url) throws IssuerNotTrustedException {
        Address trusted = this.whitelist.stream().filter(address -> url.equals(((Address)address).external()) || url.equals(((Address)address).internal())).findFirst().orElseThrow(() -> new IssuerNotTrustedException(url));
        return trusted.internal() != null ? trusted.internal() : trusted.external();
    }

    @ThreadSafe
    private static final class Address {
        @Nullable
        private final String internal;
        @Nonnull
        private final String external;

        private Address(@Nullable String internal, @Nonnull String external) {
            this.internal = internal;
            this.external = external;
        }

        @Nullable
        private String internal() {
            return this.internal;
        }

        @Nonnull
        private String external() {
            return this.external;
        }

        public String toString() {
            return "Address{internal='" + this.internal + '\'' + ", external='" + this.external + '\'' + '}';
        }
    }
}

