/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.mockingbird.interceptor;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.interceptor.ContentInterceptor;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.interceptor.TransportInterceptor;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.annotation.ApplyToTransport;
import org.qubership.automation.itf.core.util.constants.InterceptorConstants;
import org.qubership.automation.itf.core.util.descriptor.InterceptorPropertyDescriptor;
import org.qubership.mockingbird.interceptor.InterceptorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplyToTransport(transports={"org.qubership.automation.itf.transport.file.outbound.FileOutbound"})
@Named(value="Compressing")
public class CompressInterceptor
extends ContentInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressInterceptor.class);
    private final String COMPRESSING_TYPE = "Compressing Type";
    private final String COMPRESSING_TYPE_DESCRIPTION = "Type of compressing the file";
    private final String[] COMPRESSING_TYPE_OPTIONS = new String[]{"zip", "gzip", "tar", "rar"};
    private final String GZIP_COMPRESSING_TYPE = "gzip";
    private final String TAR_COMPRESSING_TYPE = "tar";
    private final String ZIP_COMPRESSING_TYPE = "zip";
    private final String RAR_COMPRESSING_TYPE = "rar";
    private final String INTERCEPTOR_COMMAND_FILEPATH = "./interceptors/compress-interceptor/";
    private final String INTERCEPTOR_COMMAND_FILE_POSTFIX = "interceptor.command";
    private final String DESTINATION_FILENAME_PROPERTY = "destinationFileName";

    public CompressInterceptor() {
    }

    public CompressInterceptor(Interceptor interceptor) {
        super(interceptor);
    }

    public Message apply(Message message) throws Exception {
        LOGGER.info("Compressing started...");
        File fileForCompressing = message.getFile();
        if (fileForCompressing == null) {
            String fileNameString;
            Object destinationFileName = message.getConnectionProperties().get("destinationFileName");
            String string = fileNameString = destinationFileName != null ? FilenameUtils.getName((String)destinationFileName.toString()) : "";
            if (!"".equals(fileNameString)) {
                if (fileNameString.contains("../") || fileNameString.contains("\\..")) {
                    throw new IllegalArgumentException("Destination File Name contains path elements which can cause Path Traversal vulnerability ('../' and/or '\\..').");
                }
                fileForCompressing = this.createSourceFileWithContent(fileNameString, message.getText());
            } else {
                LOGGER.error("Compression won't be performed, because the destination filename is empty.");
            }
        }
        if (fileForCompressing != null) {
            String compressingType = this.interceptor.getParameters() == null ? null : this.interceptor.getParameters().get((Object)"Compressing Type");
            String command = this.getCompressCommand(fileForCompressing.getName(), compressingType);
            if (!StringUtils.isEmpty((CharSequence)command)) {
                ProcessBuilder processBuilder = new ProcessBuilder(command.split(" "));
                processBuilder.directory(fileForCompressing.getParentFile());
                Process pr = processBuilder.start();
                int i = pr.waitFor();
                if (i == 0) {
                    String fullFilename = fileForCompressing.getPath().replace("\\", "/") + "." + this.getFileExtension(compressingType);
                    message.setFile(new File(fullFilename));
                    LOGGER.info("Compressing completed successfully.");
                } else {
                    LOGGER.error("Compressing failed. No changes have been applied. Status of process: " + i);
                }
            } else {
                LOGGER.info("Command for start the compressing is empty. No changes have been applied.");
            }
        }
        return message;
    }

    public String validate() {
        return InterceptorHelper.validate((Interceptor)this.interceptor, (TransportInterceptor)this);
    }

    public List<InterceptorPropertyDescriptor> getParameters() {
        ArrayList<InterceptorPropertyDescriptor> parameters = new ArrayList<InterceptorPropertyDescriptor>();
        InterceptorPropertyDescriptor compressingType = new InterceptorPropertyDescriptor("Compressing Type", "Compressing Type", "Type of compressing the file", InterceptorConstants.LIST, this.COMPRESSING_TYPE_OPTIONS, this.interceptor.getParameters() == null ? null : this.interceptor.getParameters().get((Object)"Compressing Type"), false);
        parameters.add(compressingType);
        return parameters;
    }

    private File createSourceFileWithContent(String filename, String content) throws IOException {
        File fileWithCorrectName = new File(Files.createTempDir().getPath() + "/" + filename);
        FileUtils.write((File)fileWithCorrectName, (CharSequence)content);
        return fileWithCorrectName;
    }

    private String getCompressCommand(String filename, String compressingType) {
        String command = this.readCommandFromFile(compressingType);
        if (!StringUtils.isEmpty((CharSequence)command)) {
            List<String> args = this.getArgsForCommand(filename, compressingType);
            for (int i = 0; i < args.size(); ++i) {
                command = command.replace("args" + i, args.get(i));
            }
            LOGGER.info("Command for start compressing: {}", (Object)command);
            return command;
        }
        return "";
    }

    private String readCommandFromFile(String compressingType) {
        try {
            String path = "./interceptors/compress-interceptor/" + compressingType + '.' + "interceptor.command";
            return FileUtils.readFileToString((File)new File(path));
        }
        catch (IOException e) {
            LOGGER.error("File with path \"{}\" wasn't found. Command for interceptor will be empty.", (Object)"./interceptors/compress-interceptor/");
            return "";
        }
    }

    private List<String> getArgsForCommand(String filename, String compressingType) {
        LinkedList<String> args = new LinkedList<String>();
        switch (compressingType) {
            case "gzip": {
                args.add(filename);
                break;
            }
            case "tar": 
            case "zip": 
            case "rar": {
                args.add(filename + "." + compressingType);
                args.add(filename);
                break;
            }
        }
        return args;
    }

    private String getFileExtension(String compressingType) {
        return "gzip".equals(compressingType) ? "gz" : compressingType;
    }
}

