/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.mockingbird.interceptor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.interceptor.ContentInterceptor;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.interceptor.TransportInterceptor;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.annotation.ApplyToTransport;
import org.qubership.automation.itf.core.util.constants.InterceptorConstants;
import org.qubership.automation.itf.core.util.descriptor.InterceptorPropertyDescriptor;
import org.qubership.mockingbird.interceptor.InterceptorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplyToTransport(transports={"org.qubership.automation.itf.transport.file.inbound.FileInbound"})
@Named(value="Decompressing")
public class DecompressInterceptor
extends ContentInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecompressInterceptor.class);
    private final String DECOMPRESSING_TYPE = "Decompressing Type";
    private final String DECOMPRESSING_TYPE_DESCRIPTION = "Type of decompressing the file";
    private final String[] DECOMPRESSING_TYPE_OPTIONS = new String[]{"unzip", "gzip", "tar", "unrar"};
    private final String GZIP_DECOMPRESSING_TYPE = "gzip";
    private final String TAR_DECOMPRESSING_TYPE = "tar";
    private final String UNZIP_DECOMPRESSING_TYPE = "unzip";
    private final String UNRAR_DECOMPRESSING_TYPE = "unrar";
    private final String INTERCEPTOR_COMMAND_FILEPATH = "./interceptors/decompress-interceptor/";
    private final String INTERCEPTOR_COMMAND_FILE_POSTFIX = "interceptor.command";
    private final String DECOMPRESSING_RESULT_INTERNAL_DIR_NAME = "result";

    public DecompressInterceptor() {
    }

    public DecompressInterceptor(Interceptor interceptor) {
        super(interceptor);
    }

    public Message apply(Message message) throws Exception {
        LOGGER.info("Decompressing started...");
        File sourcefileForDecompressing = message.getFile();
        File dirForDecompressing = new File(sourcefileForDecompressing.getParent());
        String decompressingType = this.interceptor.getParameters() == null ? null : this.interceptor.getParameters().get((Object)"Decompressing Type");
        File dirWithDecompressingResult = this.getDirWithDecompressingResult(dirForDecompressing, decompressingType);
        String command = this.getCommand(this.getDecompressCommand(decompressingType), sourcefileForDecompressing, dirWithDecompressingResult, decompressingType);
        if (!StringUtils.isEmpty((CharSequence)command)) {
            ProcessBuilder processBuilder = new ProcessBuilder(command.split(" "));
            processBuilder.directory(dirForDecompressing);
            Process pr = processBuilder.start();
            int i = pr.waitFor();
            if (i == 0) {
                message.setFile(this.getResultFile(dirWithDecompressingResult));
                LOGGER.info("Decompressing completed successfully.");
            } else {
                LOGGER.error("Decompressing failed. No changes has been applied. Status of process: " + i);
            }
        } else {
            LOGGER.info("Command for start the decompressing is empty. No changes have been applied.");
        }
        return message;
    }

    public String validate() {
        return InterceptorHelper.validate((Interceptor)this.interceptor, (TransportInterceptor)this);
    }

    public List<InterceptorPropertyDescriptor> getParameters() {
        ArrayList<InterceptorPropertyDescriptor> parameters = new ArrayList<InterceptorPropertyDescriptor>();
        InterceptorPropertyDescriptor compressingType = new InterceptorPropertyDescriptor("Decompressing Type", "Decompressing Type", "Type of decompressing the file", InterceptorConstants.LIST, this.DECOMPRESSING_TYPE_OPTIONS, this.interceptor.getParameters() == null ? null : this.interceptor.getParameters().get((Object)"Decompressing Type"), false);
        parameters.add(compressingType);
        return parameters;
    }

    private File getDirWithDecompressingResult(File dirForDecompressing, String decompressingType) {
        File dirWithDecompressingResult;
        if ("gzip".equals(decompressingType)) {
            dirWithDecompressingResult = dirForDecompressing;
        } else {
            dirWithDecompressingResult = new File(dirForDecompressing.getPath() + "\\" + "result");
            dirWithDecompressingResult.mkdirs();
        }
        return dirWithDecompressingResult;
    }

    private String getDecompressCommand(String decompressingType) {
        return this.readCommandFromFile(decompressingType);
    }

    private String getCommand(String command, File fileForDecompressing, File dirForDecompressing, String decompressingType) {
        if (!StringUtils.isEmpty((CharSequence)command)) {
            List<String> args = this.getArgsForCommand(fileForDecompressing, dirForDecompressing, decompressingType);
            for (int i = 0; i < args.size(); ++i) {
                command = command.replace("args" + i, args.get(i));
            }
            LOGGER.info("Command for start decompressing: {}", (Object)command);
        }
        return command;
    }

    private List<String> getArgsForCommand(File fileForDecompressing, File dirForDecompressing, String decompressingType) {
        LinkedList<String> args = new LinkedList<String>();
        switch (decompressingType) {
            case "gzip": {
                args.add(fileForDecompressing.getName());
            }
            case "unrar": 
            case "tar": 
            case "unzip": {
                args.add(fileForDecompressing.getName());
                args.add(dirForDecompressing.getName());
                break;
            }
        }
        return args;
    }

    private File getResultFile(File file) throws IOException {
        File[] files = file.listFiles();
        if (files != null) {
            return files[0];
        }
        return file;
    }

    private String readCommandFromFile(String decompressingType) {
        try {
            String path = "./interceptors/decompress-interceptor/" + decompressingType + '.' + "interceptor.command";
            return FileUtils.readFileToString((File)new File(path));
        }
        catch (IOException e) {
            LOGGER.error("File with path \"{}\" wasn't found. Command for interceptor will be empty.", (Object)"./interceptors/decompress-interceptor/");
            return "";
        }
    }
}

