/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.mockingbird.interceptor;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.inject.Named;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.interceptor.ContentInterceptor;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.interceptor.TransportInterceptor;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.annotation.ApplyToTransport;
import org.qubership.automation.itf.core.util.constants.InterceptorConstants;
import org.qubership.automation.itf.core.util.descriptor.InterceptorPropertyDescriptor;
import org.qubership.mockingbird.interceptor.CipherHelper;
import org.qubership.mockingbird.interceptor.InterceptorHelper;
import org.qubership.mockingbird.interceptor.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@ApplyToTransport(transports={"org.qubership.automation.itf.transport.jms.inbound.JMSInboundTransport"})
@Named(value="Decrypting XML message")
public class DecryptXMLInterceptor
extends ContentInterceptor {
    private static final String XPATH = "xPath";
    private static final String XPATH_DESCRIPTION = "xPath for searching the data which will be decrypted";
    private static final Logger LOGGER = LoggerFactory.getLogger(DecryptXMLInterceptor.class);

    public DecryptXMLInterceptor() {
    }

    public DecryptXMLInterceptor(Interceptor interceptor) {
        super(interceptor);
    }

    public Message apply(Message data) {
        LOGGER.info("Decrypting XML message started...");
        String message = data.getText();
        if (StringUtils.isEmpty((CharSequence)message)) {
            LOGGER.info("Message is empty. No changes have been applied.");
            return data;
        }
        try {
            List encryptedDataAsStringList = XMLHelper.getDataAsString((Object)XMLHelper.getDataByXPath((Document)XMLHelper.stringToXml((String)message), this.interceptor.getParameters() == null ? null : this.interceptor.getParameters().get((Object)XPATH)));
            for (String encryptedData : encryptedDataAsStringList) {
                String decryptedData = this.decrypt(encryptedData);
                message = CipherHelper.replaceText((String)message, (String)encryptedData, (String)decryptedData);
            }
            data.setText(message);
            LOGGER.info("Decrypting XML message completed successfully.");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.error("Cannot convert message to XML-format. No changes have been applied.", (Throwable)e);
        }
        catch (XPathExpressionException e) {
            LOGGER.error("Cannot get the message to XML-format. No changes have been applied.", (Throwable)e);
        }
        catch (TransformerException e) {
            LOGGER.error("Cannot transform the founded node to string. No changes have been applied.", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOGGER.error("Cannot encrypt the data from message. No changes have been applied.", (Throwable)e);
        }
        return data;
    }

    public String validate() {
        return InterceptorHelper.validate((Interceptor)this.interceptor, (TransportInterceptor)this);
    }

    public List<InterceptorPropertyDescriptor> getParameters() {
        List parameters = CipherHelper.getCipherParametersDefaultList((Interceptor)this.interceptor);
        InterceptorPropertyDescriptor xpath = new InterceptorPropertyDescriptor(XPATH, XPATH, XPATH_DESCRIPTION, InterceptorConstants.TEXTFIELD, this.interceptor.getParameters() == null ? null : this.interceptor.getParameters().get((Object)XPATH), false);
        parameters.add(xpath);
        return parameters;
    }

    private String decrypt(String strToDecrypt) throws InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeySpecException {
        Cipher cipher = CipherHelper.getCipher((int)2, (Interceptor)this.interceptor);
        byte[] encryptedData = CipherHelper.applyDecoding((String)strToDecrypt, this.interceptor.getParameters() == null ? null : this.interceptor.getParameters().get((Object)"Encoding"));
        return new String(cipher.doFinal(encryptedData));
    }
}

