/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.mockingbird.interceptor;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.interceptor.ContentInterceptor;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.interceptor.TransportInterceptor;
import org.qubership.automation.itf.core.model.jpa.interceptor.InterceptorParams;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.annotation.ApplyToTransport;
import org.qubership.automation.itf.core.util.constants.InterceptorConstants;
import org.qubership.automation.itf.core.util.descriptor.InterceptorPropertyDescriptor;
import org.qubership.mockingbird.interceptor.InterceptorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplyToTransport(transports={"org.qubership.automation.itf.transport.file.outbound.FileOutbound"})
@Named(value="Encrypting")
public class EncryptInterceptor
extends ContentInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptInterceptor.class);
    private final String RECIPIENT_ID = "Recipient Id";
    private final String RECIPIENT_ID_DESCRIPTION = "Encrypt the message for this user";
    private final String ENCRYPTED_FILE_EXTENSION = "Encrypted file extension";
    private final String ENCRYPTED_FILE_EXTENSION_DESCRIPTION = "Extension for the encrypted file";
    private final String[] ENCRYPTED_FILE_EXTENSION_OPTIONS = new String[]{"", "gpg"};
    private final String INTERCEPTOR_COMMAND_FILE = "./interceptors/encrypt-interceptor/interceptor.command";
    private final String DESTINATION_FILENAME_PROPERTY = "destinationFileName";

    public EncryptInterceptor() {
    }

    public EncryptInterceptor(Interceptor interceptor) {
        super(interceptor);
    }

    public Message apply(Message message) throws Exception {
        LOGGER.info("Encrypting started...");
        File fileForEncrypting = message.getFile();
        if (fileForEncrypting == null) {
            String fileNameString;
            Object destinationFileName = message.getConnectionProperties().get("destinationFileName");
            String string = fileNameString = destinationFileName != null ? FilenameUtils.getName((String)destinationFileName.toString()) : "";
            if (!"".equals(fileNameString)) {
                if (fileNameString.contains("../") || fileNameString.contains("\\..")) {
                    throw new IllegalArgumentException("Destination File Name contains path elements which can cause Path Traversal vulnerability ('../' and/or '\\..').");
                }
                fileForEncrypting = this.createSourceFileWithContent(fileNameString, message.getText());
            } else {
                LOGGER.error("Encrypting won't be performed, because the destination filename is empty.");
            }
        }
        if (fileForEncrypting != null) {
            String fileForEncryptingPath = fileForEncrypting.getPath().replace("\\", "/");
            File encryptedFile = new File(fileForEncryptingPath + ".result");
            InterceptorParams interceptorParams = this.interceptor.getParameters();
            String command = this.getEncryptCommand(interceptorParams == null ? null : interceptorParams.get((Object)"Recipient Id"), encryptedFile.getPath().replace("\\", "/"), fileForEncryptingPath);
            if (!StringUtils.isEmpty((CharSequence)command)) {
                Runtime rt = Runtime.getRuntime();
                Process pr = rt.exec(command);
                int i = pr.waitFor();
                if (i == 0) {
                    fileForEncrypting.delete();
                    String ext = interceptorParams == null ? null : interceptorParams.get((Object)"Encrypted file extension");
                    File resultFile = new File(fileForEncryptingPath + (StringUtils.isEmpty((CharSequence)ext) ? "" : "." + ext));
                    encryptedFile.renameTo(resultFile);
                    message.setFile(resultFile);
                    LOGGER.info("Encrypting completed successfully.");
                } else {
                    LOGGER.error("Encrypting failed. No changes have been applied. Status of process: " + i);
                }
            } else {
                LOGGER.warn("Command to perform encryption is empty. No changes have been applied.");
            }
        }
        return message;
    }

    public String validate() {
        return InterceptorHelper.validate((Interceptor)this.interceptor, (TransportInterceptor)this);
    }

    public List<InterceptorPropertyDescriptor> getParameters() {
        ArrayList<InterceptorPropertyDescriptor> parameters = new ArrayList<InterceptorPropertyDescriptor>();
        InterceptorParams interceptorParams = this.interceptor.getParameters();
        InterceptorPropertyDescriptor recipientId = new InterceptorPropertyDescriptor("Recipient Id", "Recipient Id", "Encrypt the message for this user", InterceptorConstants.TEXTFIELD, interceptorParams == null ? null : interceptorParams.get((Object)"Recipient Id"), false);
        parameters.add(recipientId);
        InterceptorPropertyDescriptor fileExtension = new InterceptorPropertyDescriptor("Encrypted file extension", "Encrypted file extension", "Extension for the encrypted file", InterceptorConstants.LIST, this.ENCRYPTED_FILE_EXTENSION_OPTIONS, interceptorParams == null ? null : interceptorParams.get((Object)"Encrypted file extension"), true);
        parameters.add(fileExtension);
        return parameters;
    }

    private String getEncryptCommand(String ... args) {
        String command = this.readCommandFromFile();
        if (!StringUtils.isEmpty((CharSequence)command)) {
            for (int i = 0; i < args.length; ++i) {
                command = command.replace("args" + i, args[i]);
            }
            LOGGER.info("Command for start the encrypting: " + command);
            return command;
        }
        return "";
    }

    private File createSourceFileWithContent(String filename, String content) throws IOException {
        File fileWithCorrectName = new File(Files.createTempDir().getPath() + "/" + filename);
        FileUtils.write((File)fileWithCorrectName, (CharSequence)content);
        return fileWithCorrectName;
    }

    private String readCommandFromFile() {
        try {
            return FileUtils.readFileToString((File)new File("./interceptors/encrypt-interceptor/interceptor.command"));
        }
        catch (IOException e) {
            LOGGER.error("File with path \"{}\" wasn't found. Command for interceptor will be empty.", (Object)"./interceptors/encrypt-interceptor/interceptor.command");
            return "";
        }
    }
}

