/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.mockingbird.interceptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.interceptor.ContentInterceptor;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.interceptor.TransportInterceptor;
import org.qubership.automation.itf.core.model.jpa.interceptor.ApplicabilityParams;
import org.qubership.automation.itf.core.model.jpa.interceptor.InterceptorParams;
import org.qubership.automation.itf.core.util.descriptor.InterceptorPropertyDescriptor;
import org.qubership.automation.itf.core.util.provider.InterceptorProvider;

public class InterceptorHelper {
    public static String validate(Interceptor interceptor, TransportInterceptor transportInterceptor) {
        String error = InterceptorHelper.validateApplicabilityParametersForActivation(interceptor, transportInterceptor);
        if (StringUtils.isNotEmpty((CharSequence)error)) {
            return error;
        }
        List interceptorParams = interceptor.getInterceptorParams();
        if (interceptorParams.isEmpty()) {
            return "Interceptor can't be activated, because parameters are empty.";
        }
        for (InterceptorParams params : interceptorParams) {
            if (params.isEmpty()) {
                return "Interceptor can't be activated, because parameters are empty.";
            }
            for (Map.Entry param : params.entrySet()) {
                if (!StringUtils.isEmpty((CharSequence)((CharSequence)param.getValue())) || InterceptorHelper.isOptional(transportInterceptor, (String)param.getKey())) continue;
                return String.format("Interceptor can't be activated, because '%s' parameter is empty.", param.getKey());
            }
        }
        return "";
    }

    public static String validateApplicabilityParametersForActivation(Interceptor interceptor, TransportInterceptor transportInterceptor) {
        List applicabilityParams = interceptor.getApplicabilityParams();
        if (applicabilityParams.isEmpty()) {
            return "";
        }
        for (ApplicabilityParams params : applicabilityParams) {
            if (!StringUtils.isEmpty((CharSequence)params.get((Object)"Environment"))) continue;
            return "Interceptor can not be activated, because there is an empty environment in applicability parameters.";
        }
        InterceptorProvider interceptorProvider = (InterceptorProvider)interceptor.getParent();
        List<Interceptor> activeParamsInterceptors = InterceptorHelper.getActiveParamInterceptors(interceptorProvider.getInterceptors(), interceptor);
        if (activeParamsInterceptors.isEmpty()) {
            return "";
        }
        for (Interceptor activeParamsInterceptor : activeParamsInterceptors) {
            for (ApplicabilityParams comparableParams : activeParamsInterceptor.getApplicabilityParams()) {
                for (ApplicabilityParams currentParams : applicabilityParams) {
                    if (!currentParams.get((Object)"Environment").equals(comparableParams.get((Object)"Environment")) || !currentParams.get((Object)"System").equals(comparableParams.get((Object)"System"))) continue;
                    return String.format("Interceptor can't be activated, because the %s interceptor with the same applicability parameters is active.", activeParamsInterceptor.getName());
                }
            }
        }
        return "";
    }

    public static List<Interceptor> getActiveParamInterceptors(Collection<Interceptor> interceptors, Interceptor currentInterceptor) {
        ArrayList<Interceptor> result = new ArrayList<Interceptor>();
        for (Interceptor interceptor : interceptors) {
            if (!interceptor.isActive() || interceptor.getID().toString().equals(currentInterceptor.getID().toString()) || !interceptor.getTypeName().equals(currentInterceptor.getTypeName())) continue;
            result.add(interceptor);
        }
        return result;
    }

    private static boolean isOptional(TransportInterceptor transportInterceptor, String parameterName) {
        if (transportInterceptor instanceof ContentInterceptor) {
            for (InterceptorPropertyDescriptor descriptor : ((ContentInterceptor)transportInterceptor).getParameters()) {
                if (!descriptor.getName().equals(parameterName)) continue;
                return descriptor.isOptional();
            }
        }
        return true;
    }
}

