/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.mockingbird.interceptor;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLHelper {
    public static Document stringToXml(String text) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new StringReader(text)));
    }

    public static Object getDataByXPath(Document document, String xPathStr) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        return xPath.evaluate(xPathStr, document.getDocumentElement(), XPathConstants.NODESET);
    }

    public static List<String> getDataAsString(Object dataByXpath) throws TransformerException {
        ArrayList<String> result = new ArrayList<String>();
        if (dataByXpath instanceof String) {
            result.add((String)dataByXpath);
        } else if (dataByXpath instanceof Node) {
            result.add(XMLHelper.xmlToString((Node)dataByXpath, false));
        } else {
            NodeList nodes = (NodeList)dataByXpath;
            for (int i = 0; i < nodes.getLength(); ++i) {
                result.add(XMLHelper.xmlToString(nodes.item(i), false));
            }
        }
        return result;
    }

    private static String xmlToString(Node document, boolean isRoot) throws TransformerException {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        if (!isRoot) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setOutputProperty("indent", "no");
        transformer.transform(domSource, result);
        return writer.toString();
    }
}

