/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.qubership.automation.itf.core.util.transport.service.LockProvider;
import org.qubership.automation.itf.core.util.transport.service.SessionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CacheCleanerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheCleanerService.class);
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private final long initialDelay = 120L;
    private final long delay = 120L;

    @Autowired
    public CacheCleanerService() {
    }

    public void startWorker() {
        LOGGER.info("Cache Cleaner Service is started.");
        this.service.scheduleWithFixedDelay(() -> {
            try {
                SessionHandler.INSTANCE.cleanupCache();
                LockProvider.INSTANCE.cleanupCache();
            }
            catch (Throwable t) {
                LOGGER.error("Error while Caches cleaning up", t);
            }
        }, 120L, 120L, TimeUnit.SECONDS);
    }

    public void stop() {
        LOGGER.info("Cache Cleaner Service is stopped.");
        this.service.shutdown();
    }
}

