/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.activation;

import java.util.Arrays;

public enum ActivationServiceConstants {
    TRIGGER("trigger"),
    ENVIRONMENT("environment"),
    ON_STARTUP("onStartup"),
    SYNC("sync"),
    ACTIVATE("activate"),
    DEACTIVATE("deactivate"),
    RE_ACTIVATE("reActivate"),
    SWITCH("switch"),
    GET_TRIGGER_BY_ID("/trigger/%s"),
    GET_TRIGGER_BY_ENVIRONMENT_ID("/trigger/environmentId/%s"),
    GET_ALL_TRIGGERS_FOR_ACTIVATION("/trigger/all/active"),
    UPDATE_TRIGGER_STATUS("/trigger"),
    ACTION_NOT_VALID("Action '%s' is not valid"),
    TRIGGER_NOT_FOUND("Trigger is not found by id='%s'"),
    TRIGGER_STATUS_CHANGE_FAILED("Trigger status change is failed. Please contact administrator.");

    private String value;

    private ActivationServiceConstants(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getValueWithArgs(Object ... args) {
        return String.format(this.value, args);
    }

    public static ActivationServiceConstants getByValue(String value) {
        return Arrays.stream(ActivationServiceConstants.values()).filter(constant -> value.equals(constant.value)).findFirst().orElse(null);
    }
}

