/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.activation.impl;

import org.qubership.automation.itf.activation.TriggersCache;
import org.qubership.automation.itf.core.util.exception.TriggerException;
import org.qubership.automation.itf.trigger.camel.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OnDestroyTriggersActivationService {
    private static final Logger log = LoggerFactory.getLogger(OnDestroyTriggersActivationService.class);
    private final TriggersCache triggersCache;

    public void perform() {
        log.info("Deactivating all triggers...");
        this.triggersCache.applyConsumerToEach(this::deactivateTrigger);
        this.triggersCache.clear();
        log.info("All triggers were successfully deactivated.");
    }

    private void deactivateTrigger(Trigger trigger) {
        String triggerName = trigger.getTriggerConfigurationDescriptor().getName() + " [" + trigger.getTriggerConfigurationDescriptor().getId() + "]";
        try {
            log.info("Deactivating trigger '{}'...", (Object)triggerName);
            trigger.deactivate();
            log.info("Trigger '{}' was successfully deactivated...", (Object)triggerName);
        }
        catch (TriggerException e) {
            log.error("Could not deactivate trigger '{}'.", (Object)triggerName, (Object)e);
        }
    }

    public OnDestroyTriggersActivationService(TriggersCache triggersCache) {
        this.triggersCache = triggersCache;
    }
}

