/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.activation.impl;

import feign.FeignException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.qubership.automation.itf.activation.impl.AbstractService;
import org.qubership.automation.itf.activation.impl.TransportTypeToTriggerClassMapping;
import org.qubership.automation.itf.core.model.communication.TransportType;
import org.qubership.automation.itf.core.model.communication.TriggerSample;
import org.qubership.automation.itf.core.util.eds.ExternalDataManagementService;
import org.qubership.automation.itf.integration.executor.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OnStartupTriggersActivationService
extends AbstractService {
    private static final Logger log = LoggerFactory.getLogger(OnStartupTriggersActivationService.class);
    private final ExternalDataManagementService externalDataManagementService;
    private final ExecutorService executorService;
    private static final List<TransportType> VIP1_TYPES = Arrays.asList(TransportType.SMPP_INBOUND, TransportType.HTTP2_INBOUND, TransportType.CLI_INBOUND);
    private static final List<TransportType> VIP2_TYPES = Arrays.asList(TransportType.REST_INBOUND, TransportType.SOAP_OVER_HTTP_INBOUND);
    private static final List<TransportType> VIP3_TYPES = Arrays.asList(TransportType.KAFKA_INBOUND, TransportType.JMS_INBOUND, TransportType.FILE_INBOUND, TransportType.SNMP_INBOUND);
    private boolean listForActivationReceived = false;
    private boolean initialTriggersActivationCompleted = false;

    public void perform(Set<String> triggerTypes) {
        long startTimeAllTriggers = System.nanoTime();
        List<TriggerSample> allTriggerSamples = this.getTriggersForActivation();
        if (!allTriggerSamples.isEmpty()) {
            Map<TransportType, List<TriggerSample>> triggersByType = allTriggerSamples.stream().filter(item -> Objects.nonNull(item) && Objects.nonNull(item.getTransportType())).collect(Collectors.groupingBy(TriggerSample::getTransportType));
            this.processTriggersFiltered(triggerTypes, triggersByType, VIP1_TYPES);
            this.processTriggersFiltered(triggerTypes, triggersByType, VIP2_TYPES);
            this.processTriggersFiltered(triggerTypes, triggersByType, VIP3_TYPES);
            long elapsedTimeAllTriggers = System.nanoTime() - startTimeAllTriggers;
            log.info("Triggers activation completed in {} (s)", (Object)String.format("%.3f", (double)elapsedTimeAllTriggers / 1.0E9));
        }
        if (!this.isListForActivationReceived()) {
            log.warn("Triggers for activation were not received.");
        } else {
            this.initialTriggersActivationCompleted = true;
        }
    }

    private void processTriggersFiltered(Set<String> triggerTypes, Map<TransportType, List<TriggerSample>> triggersByType, List<TransportType> processOnlyTypes) {
        triggersByType.entrySet().parallelStream().forEach(transportTypeListEntry -> {
            TransportType transportType = (TransportType)transportTypeListEntry.getKey();
            if (processOnlyTypes.contains(transportType)) {
                List triggerSamples = (List)transportTypeListEntry.getValue();
                String triggerClassName = TransportTypeToTriggerClassMapping.getTriggerClassName(transportType);
                if (!triggerTypes.contains(triggerClassName)) {
                    log.error("Library for processing triggers of type '{}' not found", (Object)transportType);
                    return;
                }
                ConcurrentHashMap<String, Boolean> availableServers = new ConcurrentHashMap<String, Boolean>();
                log.info("Triggers activation for '{}' is started", (Object)triggerClassName);
                this.activateListOfTriggers(triggerSamples, availableServers, "activation-at-service-startup");
                log.info("Triggers activation for '{}' is finished, total count {}", (Object)triggerClassName, (Object)triggerSamples.size());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<TriggerSample> getTriggersForActivation() {
        List<TriggerSample> list;
        long startTime = System.nanoTime();
        try {
            List<TriggerSample> triggerSamples = this.executorService.getAllActiveTriggers();
            this.listForActivationReceived = true;
            if (triggerSamples.isEmpty()) {
                log.info("List of triggers for activation received but it is empty");
            }
            list = triggerSamples;
        }
        catch (FeignException fe) {
            try {
                log.error("Error while trying to get triggers for activation. Message: {}", (Object)fe.getMessage());
            }
            catch (Throwable throwable) {
                long elapsedTime = System.nanoTime() - startTime;
                log.info("Request for triggers list for activation processed in {} (s)", (Object)String.format("%.3f", (double)elapsedTime / 1.0E9));
                throw throwable;
            }
            long elapsedTime = System.nanoTime() - startTime;
            log.info("Request for triggers list for activation processed in {} (s)", (Object)String.format("%.3f", (double)elapsedTime / 1.0E9));
            return new LinkedList<TriggerSample>();
        }
        long elapsedTime = System.nanoTime() - startTime;
        log.info("Request for triggers list for activation processed in {} (s)", (Object)String.format("%.3f", (double)elapsedTime / 1.0E9));
        return list;
    }

    public boolean isInitialActivationCompleted() {
        return this.initialTriggersActivationCompleted;
    }

    public OnStartupTriggersActivationService(ExternalDataManagementService externalDataManagementService, ExecutorService executorService) {
        this.externalDataManagementService = externalDataManagementService;
        this.executorService = executorService;
    }

    public boolean isListForActivationReceived() {
        return this.listForActivationReceived;
    }
}

