/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.executor;

import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.qubership.automation.itf.converter.DtoConvertService;
import org.qubership.automation.itf.core.model.communication.EnvironmentSample;
import org.qubership.automation.itf.core.model.communication.Result;
import org.qubership.automation.itf.core.model.communication.TriggerSample;
import org.qubership.automation.itf.core.model.communication.UpdateTriggerStatusRequest;
import org.qubership.automation.itf.integration.executor.ExecutorFeignClient;
import org.qubership.automation.itf.openapi.executor.dto.UIUpdateTriggerStatusDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExecutorService {
    private static final Logger log = LoggerFactory.getLogger(ExecutorService.class);
    private final ExecutorFeignClient executorFeignClient;
    @Autowired
    private ModelMapper modelMapper;

    public List<TriggerSample> getAllActiveTriggers() {
        DtoConvertService dtoConvertService = new DtoConvertService(this.modelMapper);
        List<TriggerSample> triggerSamples = dtoConvertService.convertList((List)this.executorFeignClient.getAllActiveTriggers().getBody(), TriggerSample.class);
        return triggerSamples;
    }

    public List<TriggerSample> getAllTriggersByProject(UUID projectUuid) {
        DtoConvertService dtoConvertService = new DtoConvertService(this.modelMapper);
        List<TriggerSample> triggerSamples = dtoConvertService.convertList((List)this.executorFeignClient.getAllTriggersByProject(projectUuid).getBody(), TriggerSample.class);
        return triggerSamples;
    }

    public List<TriggerSample> getAllTriggersByProjectToReActivate(UUID projectUuid) {
        DtoConvertService dtoConvertService = new DtoConvertService(this.modelMapper);
        List<TriggerSample> triggerSamples = dtoConvertService.convertList((List)this.executorFeignClient.getAllActiveAndErrorTriggersByProject(projectUuid).getBody(), TriggerSample.class);
        return triggerSamples;
    }

    public List<EnvironmentSample> getTriggersByEnvFolder(BigInteger envFolderId) {
        DtoConvertService dtoConvertService = new DtoConvertService(this.modelMapper);
        List<EnvironmentSample> environmentSamples = dtoConvertService.convertList((List)this.executorFeignClient.getTriggersByEnvFolder(envFolderId).getBody(), EnvironmentSample.class);
        return environmentSamples;
    }

    public TriggerSample getTriggerById(BigInteger id) {
        DtoConvertService dtoConvertService = new DtoConvertService(this.modelMapper);
        TriggerSample triggerSample = dtoConvertService.convert(this.executorFeignClient.getTriggerById(id).getBody(), TriggerSample.class);
        return triggerSample;
    }

    public EnvironmentSample getTriggersByEnvironment(BigInteger environmentId) {
        DtoConvertService dtoConvertService = new DtoConvertService(this.modelMapper);
        EnvironmentSample environmentSample = dtoConvertService.convert(this.executorFeignClient.getTriggersByEnvironment(environmentId).getBody(), EnvironmentSample.class);
        return environmentSample;
    }

    public Result updateTriggerStatus(UpdateTriggerStatusRequest request) {
        DtoConvertService dtoConvertService = new DtoConvertService(this.modelMapper);
        UIUpdateTriggerStatusDto requestDto = dtoConvertService.convert(request, UIUpdateTriggerStatusDto.class);
        Result result = dtoConvertService.convert(this.executorFeignClient.updateTriggerStatus(requestDto).getBody(), Result.class);
        return result;
    }

    public ExecutorService(ExecutorFeignClient executorFeignClient) {
        this.executorFeignClient = executorFeignClient;
    }
}

