/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.stubs.cache.hazelcast.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"hazelcast.cache.enabled"}, havingValue="false")
public class LocalHazelcastConfig {
    private static final Logger log = LoggerFactory.getLogger(LocalHazelcastConfig.class);

    @Bean(name={"hazelcastClient"})
    public HazelcastInstance hazelcastInstance() {
        Config config = new Config();
        config.setClusterName("local-itf-stubs-hazelcast-cluster");
        config.setInstanceName("local-itf-stubs-hc-cache-instance");
        HazelcastInstance hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
        this.addLocalMapConfigs(hazelcastInstance);
        return hazelcastInstance;
    }

    private void addLocalMapConfigs(HazelcastInstance hazelcastInstance) {
        Config config = hazelcastInstance.getConfig();
        try {
            log.info("Try to add config for '{}' local hazelcast map", (Object)"ATP_ITF_PROJECT_SETTINGS");
            config.addMapConfig(new MapConfig().setName("ATP_ITF_PROJECT_SETTINGS"));
            log.info("Config for '{}' local hazelcast map was added", (Object)"ATP_ITF_PROJECT_SETTINGS");
        }
        catch (Exception exception) {
            log.warn("Map '{}' already created on local Hazelcast cluster side. It's not possible to change existing map config.", (Object)"ATP_ITF_PROJECT_SETTINGS", (Object)exception);
        }
    }
}

