/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.config;

import io.undertow.Undertow;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"embedded.https.enabled"}, havingValue="true")
public class ItfServerCustomizer
implements WebServerFactoryCustomizer<UndertowServletWebServerFactory> {
    private static final Logger log = LoggerFactory.getLogger(ItfServerCustomizer.class);
    @Value(value="${embedded.tls.1.2.server.port}")
    private int tls12ServerPort;
    @Value(value="${embedded.tls.1.3.server.port}")
    private int tls13ServerPort;
    @Value(value="${embedded.ssl.server.port}")
    private int sslServerPort;
    @Value(value="${extra.project.ports.tls.1.2}")
    private String[] extraProjectPortsTls12;
    @Value(value="${extra.project.ports.tls.1.3}")
    private String[] extraProjectPortsTls13;
    @Value(value="${extra.project.ports.ssl}")
    private String[] extraProjectPortsSsl;
    private static final String CURRENT_HOST = "0.0.0.0";
    private final TrustManagerFactory trustManagerFactory;
    private final KeyManagerFactory keyManagerFactory;

    @Autowired
    public ItfServerCustomizer(TrustManagerFactory trustManagerFactory, KeyManagerFactory keyManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
        this.keyManagerFactory = keyManagerFactory;
    }

    public void customize(UndertowServletWebServerFactory factory) {
        factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> {
            log.info("Undertow WebServer customizing is started...");
            this.processPortsList("TLSv1.2", builder, CURRENT_HOST, this.tls12ServerPort, this.extraProjectPortsTls12);
            this.processPortsList("TLSv1.3", builder, CURRENT_HOST, this.tls13ServerPort, this.extraProjectPortsTls13);
            this.processPortsList("SSL", builder, CURRENT_HOST, this.sslServerPort, this.extraProjectPortsSsl);
            log.info("Undertow WebServer customizing is completed.");
        }});
    }

    private void processPortsList(String protocol, Undertow.Builder builder, String host, int port, String[] extraPorts) {
        this.createSslContext(protocol).ifPresent(tlsContext -> {
            builder.addHttpsListener(port, host, tlsContext);
            for (String item : extraPorts) {
                if (StringUtils.isEmpty((CharSequence)item) || StringUtils.isBlank((CharSequence)item)) {
                    log.warn("Null or empty port number for {} protocol, skipped", (Object)protocol);
                    continue;
                }
                try {
                    int portItem = Integer.parseInt(item.trim());
                    if (portItem > 0) {
                        builder.addHttpsListener(portItem, host, tlsContext);
                        continue;
                    }
                    log.error("Wrong port number for {} protocol: '{}'", (Object)protocol, (Object)item);
                }
                catch (NumberFormatException numberFormatException) {
                    log.error("Exception while parsing of port number for {} protocol: '{}'", new Object[]{protocol, item, numberFormatException});
                }
            }
        });
    }

    private Optional<SSLContext> createSslContext(String protocol) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance(protocol);
            sslContext.init(this.keyManagerFactory.getKeyManagers(), this.trustManagerFactory.getTrustManagers(), null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("Could not create SSLContext for {} protocol.", (Object)protocol, (Object)e);
        }
        return Optional.ofNullable(sslContext);
    }
}

