/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.config;

import com.mongodb.MongoException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import org.qubership.automation.itf.CacheCleanerService;
import org.qubership.automation.itf.core.stub.fast.FastResponseConfigsHolder;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.qubership.automation.itf.core.util.eds.ExternalDataManagementService;
import org.qubership.automation.itf.core.util.eds.service.EdsContentType;
import org.qubership.automation.itf.core.util.eds.service.EdsMetaInfo;
import org.qubership.automation.itf.ui.config.TriggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.listener.AbstractJmsListeningContainer;
import org.springframework.stereotype.Component;

@Component
public class UiContextListener {
    private static final Logger log = LoggerFactory.getLogger(UiContextListener.class);
    protected ApplicationContext myContext;
    private final TriggerContext triggerContext;
    private final ExternalDataManagementService externalDataManagementService;
    private final CacheCleanerService cacheCleanerService;
    private AtomicBoolean isFirstContextRefreshEvent = new AtomicBoolean(true);
    @Value(value="${local.storage.directory}")
    private String localStorageDirectory;

    @Autowired
    private UiContextListener(ApplicationContext myContext, TriggerContext triggerContext, ExternalDataManagementService externalDataManagementService, CacheCleanerService cacheCleanerService) {
        this.myContext = myContext;
        this.triggerContext = triggerContext;
        this.externalDataManagementService = externalDataManagementService;
        this.cacheCleanerService = cacheCleanerService;
    }

    @EventListener
    public void init(ContextRefreshedEvent event) throws InterruptedException {
        if (event.getSource().equals(this.myContext) && this.isFirstContextRefreshEvent.get()) {
            this.contextInitialized();
        }
    }

    @PreDestroy
    public void destroy() {
        this.triggerContext.destroy();
    }

    private void contextInitialized() {
        this.isFirstContextRefreshEvent.set(false);
        try {
            this.loadDataFromExternalStorage(System.nanoTime());
        }
        catch (MongoException | IOException ex) {
            log.error("Error while loading files from External Data Storage. Please note: further SOAP triggers activation and/or fast-stubs processing may be incorrect", ex);
        }
        try {
            this.initFastResponseConfigsHolder();
        }
        catch (SecurityException ex) {
            log.error("Error while initializing of Fast Response Configs Holder", (Throwable)ex);
        }
        try {
            this.bulkActivateTriggers();
        }
        catch (InterruptedException ex) {
            log.error("Error while triggers activation", (Throwable)ex);
        }
        this.startingJmsListenerContainer();
        this.cacheCleanerService.startWorker();
        log.info("Stub service initialization completed");
    }

    private void bulkActivateTriggers() throws InterruptedException {
        boolean startTransportTriggersAtStartup = Boolean.parseBoolean(ApplicationConfig.env.getProperty("start.transport.triggers.at.startup"));
        if (startTransportTriggersAtStartup) {
            boolean isSyncActivation = Boolean.parseBoolean(ApplicationConfig.env.getProperty("triggers.activation.sync"));
            if (isSyncActivation) {
                this.triggerContext.activateTriggers().join();
            }
            int delay = this.getProperty("triggers.activation.delay", 60000, 0, 180000);
            int timeout = this.getProperty("triggers.activation.timeout", 15000, 10000, 60000);
            int attempts = this.getProperty("triggers.activation.attempts", 15, 0, 120);
            this.retryTriggersActivation(delay, timeout, attempts);
        }
    }

    private void startingJmsListenerContainer() {
        log.info("Getting JmsListenerContainerFactories...");
        DefaultJmsListenerContainerFactory factory = (DefaultJmsListenerContainerFactory)this.myContext.getBean("stubsTopicJmsListenerContainerFactory");
        factory.setAutoStartup(true);
        factory = (DefaultJmsListenerContainerFactory)this.myContext.getBean("stubsQueueJmsListenerContainerFactory");
        factory.setAutoStartup(true);
        log.info("JmsListenerContainerFactories: setAutoStartup is set to true.");
        log.info("Getting JmsListenerEndpointRegistry...");
        JmsListenerEndpointRegistry registry = (JmsListenerEndpointRegistry)this.myContext.getBean(JmsListenerEndpointRegistry.class);
        log.info("Setting 'autoStartup' to true for all JMS Listeners...");
        registry.getListenerContainers().forEach(listenerContainer -> ((AbstractJmsListeningContainer)listenerContainer).setAutoStartup(true));
        log.info("All JMS Listeners are ready. Starting jmsListenerEndpointRegistry...");
        registry.start();
        log.info("JmsListenerEndpointRegistry is started.");
    }

    private void retryTriggersActivation(int delay, int timeout, int attempts) {
        Thread thread = new Thread(() -> {
            block8: {
                if (this.triggerContext.isListForActivationReceived()) break block8;
                log.info("Triggers were not activated yet, starting activation process...");
                if (delay > 0) {
                    try {
                        log.info("Triggers activation: wait {} sec. before start...", (Object)(delay / 1000));
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                int attemptsElapsed = 0;
                while (true) {
                    try {
                        log.info("Triggers activation: attempt #{} of {}...", (Object)(++attemptsElapsed), (Object)attempts);
                        this.triggerContext.activateTriggers().join();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    if (this.triggerContext.isListForActivationReceived()) break block8;
                    if (attemptsElapsed >= attempts) break;
                    log.info("Triggers activation: wait {} sec. before retry...", (Object)(timeout / 1000));
                    try {
                        Thread.sleep(timeout);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                log.warn("Triggers activation attempts ({}) are over!", (Object)attempts);
            }
        }, "RetryTriggersActivationThread");
        thread.start();
    }

    private void loadDataFromExternalStorage(long startTime) throws IOException, MongoException {
        log.info("Loading files from external storage...");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(EdsMetaInfo.CONTENT_TYPE.getStringValue(), EdsContentType.WSDL_XSD.getStringValue());
        Set wsdlXsdFiles = this.externalDataManagementService.getExternalStorageService().getFilesInfoByMetadataMapParams(params);
        this.externalDataManagementService.getFileManagementService().save((Collection)wsdlXsdFiles);
        Set keystoreFiles = this.externalDataManagementService.getExternalStorageService().getKeyStoreFileInfo();
        this.externalDataManagementService.getFileManagementService().save((Collection)keystoreFiles);
        params.put(EdsMetaInfo.CONTENT_TYPE.getStringValue(), EdsContentType.FAST_STUB.getStringValue());
        Set fastStubFiles = this.externalDataManagementService.getExternalStorageService().getFilesInfoByMetadataMapParams(params);
        this.externalDataManagementService.getFileManagementService().save((Collection)fastStubFiles);
        String message = String.format("Files count: %d with type '%s', %d with type '%s', %d with type '%s'", wsdlXsdFiles.size(), EdsContentType.WSDL_XSD.getStringValue(), keystoreFiles.size(), EdsContentType.KEYSTORE.getStringValue(), fastStubFiles.size(), EdsContentType.FAST_STUB.getStringValue());
        long elapsedTime = System.nanoTime() - startTime;
        log.info("Loading files [{}] from external storage completed in {} (s).", (Object)message, (Object)String.format("%.3f", (double)elapsedTime / 1.0E9));
    }

    private int getProperty(String name, int defaultValue, int minValue, int maxValue) {
        int value;
        try {
            value = Integer.parseInt(Objects.requireNonNull(ApplicationConfig.env.getProperty(name)));
        }
        catch (NullPointerException | NumberFormatException nfe) {
            log.error("Empty or incorrect value of '{}' config property; default value {} is used", (Object)name, (Object)defaultValue);
            value = defaultValue;
        }
        return value >= minValue && value <= maxValue ? value : defaultValue;
    }

    public void initFastResponseConfigsHolder() throws SecurityException {
        String stubConfigsDirPath = this.localStorageDirectory + "/" + EdsContentType.FAST_STUB.getStringValue();
        File stubConfigsDir = new File(stubConfigsDirPath);
        if (!stubConfigsDir.exists() || !stubConfigsDir.isDirectory()) {
            log.warn("Folder {} not found. Fast stubs configurations will not be loaded.", (Object)stubConfigsDirPath);
            return;
        }
        File[] listConfigFiles = stubConfigsDir.listFiles();
        if (listConfigFiles == null) {
            log.warn("Folder {}: list of files is null", (Object)stubConfigsDirPath);
            return;
        }
        for (File projectDir : listConfigFiles) {
            if (!projectDir.exists() || !projectDir.isDirectory()) continue;
            File[] listProjectFiles = projectDir.listFiles();
            if (listProjectFiles != null) {
                for (File file : listProjectFiles) {
                    if (!file.exists() || file.isDirectory()) continue;
                    FastResponseConfigsHolder.INSTANCE.loadFromFile(projectDir.getName(), file);
                }
                continue;
            }
            log.warn("Folder {}: list of project files is null", (Object)projectDir.getPath());
        }
    }
}

