/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.swagger.plugins;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.Tags;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.readers.operation.DefaultTagsProvider;

@Component
@ConditionalOnProperty(name={"swagger.enabled"}, havingValue="true")
@Order(value=-2147482638)
public class DisableAutoGeneratedTagsPlugin
implements OperationBuilderPlugin {
    private final DefaultTagsProvider tagsProvider;

    @Autowired
    public DisableAutoGeneratedTagsPlugin(DefaultTagsProvider tagsProvider) {
        this.tagsProvider = tagsProvider;
    }

    public void apply(OperationContext context) {
        ImmutableSet defaultTags = this.tagsProvider.tags(context);
        Set<String> tagsOnController = this.controllerTags(context);
        Set<String> tagsOnOperation = this.operationTags(context);
        Sets.SetView intersectionTags = Sets.intersection(tagsOnController, tagsOnOperation);
        Sets.SetView allTags = Sets.union(tagsOnController, tagsOnOperation);
        if (allTags.isEmpty()) {
            context.operationBuilder().tags((Set)defaultTags);
        } else if (intersectionTags.isEmpty()) {
            context.operationBuilder().tags((Set)allTags);
        } else {
            context.operationBuilder().tags(tagsOnOperation);
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private Set<String> controllerTags(OperationContext context) {
        Optional controllerAnnotation = context.findControllerAnnotation(Api.class);
        return (Set)controllerAnnotation.transform(this.tagsFromController()).or((Object)Sets.newHashSet());
    }

    private Set<String> operationTags(OperationContext context) {
        Optional annotation = context.findAnnotation(ApiOperation.class);
        return (Set)annotation.transform(this.tagsFromOperation()).or((Object)Sets.newHashSet());
    }

    private Function<ApiOperation, Set<String>> tagsFromOperation() {
        return input -> {
            TreeSet tags = Sets.newTreeSet();
            if (input != null) {
                tags.addAll(FluentIterable.from((Iterable)Lists.newArrayList((Object[])input.tags())).filter(Tags.emptyTags()).toSet());
            }
            return tags;
        };
    }

    private Function<Api, Set<String>> tagsFromController() {
        return input -> {
            TreeSet tags = Sets.newTreeSet();
            if (input != null) {
                tags.addAll(FluentIterable.from((Iterable)Lists.newArrayList((Object[])input.tags())).filter(Tags.emptyTags()).toSet());
            }
            return tags;
        };
    }
}

