/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.utils.loader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.qubership.automation.itf.core.util.loader.base.AbstractLoader;
import org.qubership.automation.itf.trigger.camel.Trigger;
import org.springframework.stereotype.Component;

@Component
public class TriggerClassLoader
extends AbstractLoader<Trigger> {
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Checked; it's suspicious, but let's skip now")
    public TriggerClassLoader() {
        LIB = "/lib";
        PATH_PATTERN = "(mockingbird-trigger+[\\w-]*)";
    }

    protected Class<Trigger> getGenericType() {
        return Trigger.class;
    }

    protected void validateClasses(Set<Class<? extends Trigger>> classes) {
        if (!classes.iterator().hasNext()) {
            throw new IllegalArgumentException("No class is found");
        }
    }

    public Trigger getInstanceClass(String className, Object ... paramForConstructor) throws ClassNotFoundException {
        try {
            return this.getClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClassNotFoundException("Classloader isn't found for class", e);
        }
    }

    public Constructor<? extends Trigger> getConstructorByClass(String className, Class<?> ... paramForConstructor) throws ClassNotFoundException {
        try {
            return this.getClass(className).getConstructor(paramForConstructor);
        }
        catch (NoSuchMethodException e) {
            throw new ClassNotFoundException("Constructor isn't found for class", e);
        }
    }

    public Class<? extends Trigger> getClass(String typeName) {
        try {
            return this.getClassLoaderHolder().computeIfAbsent(typeName, className -> {
                throw new IllegalArgumentException("Classloader not found for class " + typeName);
            }).loadClass(typeName).asSubclass(Trigger.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class with name " + typeName + " isn't found in classloader", e);
        }
    }
}

