/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.openapi.executor.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.automation.itf.openapi.executor.dto.EnvironmentSampleDto;
import org.qubership.automation.itf.openapi.executor.dto.ResultDto;
import org.qubership.automation.itf.openapi.executor.dto.TriggerSampleDto;
import org.qubership.automation.itf.openapi.executor.dto.UIUpdateTriggerStatusDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="ItfStubsRequestController", description="Itf Stubs Request Controller")
public interface ItfStubsRequestControllerApi {
    @Operation(operationId="getAllActiveAndErrorTriggersByProject", summary="getAllActiveAndErrorTriggersByProject", tags={"itf-stubs-request-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TriggerSampleDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/trigger/all/reactivate"}, produces={"application/json"})
    public ResponseEntity<List<TriggerSampleDto>> getAllActiveAndErrorTriggersByProject(@NotNull @Parameter(name="projectUuid", description="projectUuid", required=true) @Valid @RequestParam(value="projectUuid", required=true) UUID var1);

    @Operation(operationId="getAllActiveTriggers", summary="getAllActiveTriggers", tags={"itf-stubs-request-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TriggerSampleDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/trigger/all/active"}, produces={"application/json"})
    public ResponseEntity<List<TriggerSampleDto>> getAllActiveTriggers();

    @Operation(operationId="getAllTriggersByProject", summary="getAllTriggersByProject", tags={"itf-stubs-request-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TriggerSampleDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/trigger/all"}, produces={"application/json"})
    public ResponseEntity<List<TriggerSampleDto>> getAllTriggersByProject(@NotNull @Parameter(name="projectUuid", description="projectUuid", required=true) @Valid @RequestParam(value="projectUuid", required=true) UUID var1);

    @Operation(operationId="getTriggerById", summary="getTriggerById", tags={"itf-stubs-request-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TriggerSampleDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/trigger/{id}"}, produces={"application/json"})
    public ResponseEntity<TriggerSampleDto> getTriggerById(@Parameter(name="id", description="id", required=true) @PathVariable(value="id") BigInteger var1);

    @Operation(operationId="getTriggersByEnvFolder", summary="getTriggersByEnvFolder", tags={"itf-stubs-request-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentSampleDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/trigger/environment/folder/{id}"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentSampleDto>> getTriggersByEnvFolder(@Parameter(name="id", description="envFolderId", required=true) @PathVariable(value="id") BigInteger var1);

    @Operation(operationId="getTriggersByEnvironment", summary="getTriggersByEnvironment", tags={"itf-stubs-request-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentSampleDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/trigger/environmentId/{id}"}, produces={"application/json"})
    public ResponseEntity<EnvironmentSampleDto> getTriggersByEnvironment(@Parameter(name="id", description="environmentId", required=true) @PathVariable(value="id") BigInteger var1);

    @Operation(operationId="updateTriggerStatus", summary="updateTriggerStatus", tags={"itf-stubs-request-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResultDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/trigger"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ResultDto> updateTriggerStatus(@Parameter(name="UIUpdateTriggerStatusDto", description="", required=true) @Valid @RequestBody UIUpdateTriggerStatusDto var1);
}

