/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.activation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.activation.ActivationServiceConstants;
import org.qubership.automation.itf.activation.ThreadPoolProvider;
import org.qubership.automation.itf.activation.TriggerServiceFactory;
import org.qubership.automation.itf.activation.impl.ActivationService;
import org.qubership.automation.itf.activation.impl.CommonTriggerActivationService;
import org.qubership.automation.itf.activation.impl.EnvironmentActivationService;
import org.qubership.automation.itf.activation.impl.SystemServerTriggerActivationService;
import org.qubership.automation.itf.activation.impl.TriggerActivationService;
import org.qubership.automation.itf.core.model.communication.StubUser;
import org.qubership.automation.itf.core.model.communication.message.ItfConfigurationMessage;
import org.qubership.automation.itf.core.model.communication.message.ServerTriggerSyncRequest;
import org.qubership.automation.itf.core.model.communication.message.TriggerBulkPerformRequest;
import org.qubership.automation.itf.core.model.communication.message.TriggerExecutionMessage;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.stub.fast.FastResponseConfigsHolder;
import org.qubership.automation.itf.core.util.eds.ExternalDataManagementService;
import org.qubership.automation.itf.core.util.eds.model.FileInfo;
import org.qubership.automation.itf.core.util.eds.service.EdsContentType;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.core.util.transport.service.LockProvider;
import org.qubership.automation.itf.core.util.transport.service.SessionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

@Component
public class StubJmsListeners {
    private static final Logger log = LoggerFactory.getLogger(StubJmsListeners.class);
    private final TriggerServiceFactory triggerServiceFactory;
    private final ObjectMapper jmsMessageConverterObjectMapper;
    private final ExternalDataManagementService externalDataManagementService;
    private final ThreadPoolProvider threadPoolProvider;
    private final String executorStubsResponseSelectorKey = "hostname";
    private final String executorStubsResponseSelectorValue = "'${hostname}'";
    private final String executorStubsResponseSelectorData = "hostname='${hostname}'";

    @Autowired
    public StubJmsListeners(TriggerServiceFactory triggerServiceFactory, @Qualifier(value="jmsMessageConverterObjectMapper") ObjectMapper jmsMessageConverterObjectMapper, ExternalDataManagementService externalDataManagementService, ThreadPoolProvider threadPoolProvider) {
        this.triggerServiceFactory = triggerServiceFactory;
        this.jmsMessageConverterObjectMapper = jmsMessageConverterObjectMapper;
        this.externalDataManagementService = externalDataManagementService;
        this.threadPoolProvider = threadPoolProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmsListener(destination="${message-broker.configurator-stubs.topic}", containerFactory="stubsTopicJmsListenerContainerFactory")
    public void onConfiguratorStubsMessage(ActiveMQTextMessage message) {
        try {
            log.info("Message received from topic '{}': {}", (Object)message.getDestination(), (Object)message.getText());
            String projectUuid = message.getStringProperty("X-Project-Id");
            MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (String)projectUuid);
            String type = this.jmsMessageConverterObjectMapper.readTree(message.getText()).get("type").asText();
            String action = this.jmsMessageConverterObjectMapper.readTree(message.getText()).hasNonNull("action") ? this.jmsMessageConverterObjectMapper.readTree(message.getText()).get("action").asText() : "";
            ActivationService service = this.triggerServiceFactory.getService(type);
            if (service != null) {
                CompletableFuture.runAsync(() -> this.processTriggersActivationMessage(message, type, action, projectUuid, service), this.threadPoolProvider.getAsyncTasksPool());
            } else {
                log.error("There is no service for '{}' type", (Object)type);
            }
        }
        catch (JsonProcessingException | JMSException e) {
            log.error("Error while message processing: {}", (Object)e.getMessage());
            this.sendFailMessageToConfigurator(message, e.getMessage());
        }
        finally {
            MDC.clear();
        }
    }

    private void sendFailMessageToConfigurator(ActiveMQTextMessage message, String error) {
        try {
            String sessionId = this.jmsMessageConverterObjectMapper.readTree(message.getText()).get("sessionId").asText();
            String user = this.jmsMessageConverterObjectMapper.readTree(message.getText()).get("user").toString();
            StubUser stubUser = (StubUser)new ObjectMapper().readValue(user, StubUser.class);
            ActivationService service = this.triggerServiceFactory.getService(ActivationServiceConstants.TRIGGER.getValue());
            TriggerConfigurationResponse response = new TriggerConfigurationResponse(String.format("Message processing error. Please contact support. Cause: %s", error), stubUser, sessionId);
            ((TriggerActivationService)service).getSender().send((Object)response, (Object)message.getStringProperty("X-Project-Id"));
        }
        catch (JsonProcessingException | JMSException e) {
            log.error("Error while configurator_stubs topic message processing : {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmsListener(destination="${message-broker.executor-stubs-outgoing-response.queue}", containerFactory="stubsQueueJmsListenerContainerFactory", selector="hostname='${hostname}'")
    @AtpJaegerLog
    public void onExecutorStubsOutgoingResponseMessage(ActiveMQTextMessage activeMqTextMessage) {
        try {
            activeMqTextMessage.acknowledge();
            TriggerExecutionMessage triggerExecutionMessage = (TriggerExecutionMessage)this.jmsMessageConverterObjectMapper.readValue(activeMqTextMessage.getText(), TriggerExecutionMessage.class);
            String sessionId = triggerExecutionMessage.getSessionId();
            MdcUtils.put((String)MdcField.SESSION_ID.toString(), (String)sessionId);
            String traceId = activeMqTextMessage.getStringProperty("traceId");
            MdcUtils.put((String)MdcField.TRACE_ID.toString(), (String)traceId);
            log.info("Response is received for sessionId: {}", (Object)sessionId);
            Message message = triggerExecutionMessage.getMessage();
            if (message != null) {
                SessionHandler.INSTANCE.addMessage(sessionId, message);
            } else {
                log.warn("Response message is NULL for sessionId: {}", (Object)sessionId);
            }
            LockProvider.INSTANCE.notify(sessionId);
        }
        catch (JsonProcessingException | JMSException e) {
            log.error("Error while message processing: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            log.error("Error while executor_stubs_outgoing_response queue message processing : {}", (Object)e.getMessage());
        }
        finally {
            MDC.clear();
        }
    }

    @JmsListener(destination="${message-broker.eds-update.topic}", containerFactory="stubsTopicJmsListenerContainerFactory")
    public void onExternalDataStorageUpdateMessage(ActiveMQTextMessage activeMqTextMessage) {
        try {
            FileInfo fileInfo = (FileInfo)this.jmsMessageConverterObjectMapper.readValue(activeMqTextMessage.getText(), FileInfo.class);
            CompletableFuture.runAsync(() -> this.processUpdateFileMessage(fileInfo), this.threadPoolProvider.getAsyncTasksPool());
        }
        catch (JsonProcessingException | JMSException e) {
            log.error("Error while message processing: {}", (Object)e.getMessage());
        }
        finally {
            MDC.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTriggersActivationMessage(ActiveMQTextMessage message, String type, String action, String projectUuid, ActivationService service) {
        try {
            if ("sync".equals(type)) {
                ServerTriggerSyncRequest request = (ServerTriggerSyncRequest)this.jmsMessageConverterObjectMapper.readValue(message.getText(), ServerTriggerSyncRequest.class);
                this.putMdcFields(projectUuid, request.getSessionId());
                ((SystemServerTriggerActivationService)service).perform(request, projectUuid);
            } else if ((ActivationServiceConstants.ACTIVATE.getValue().equals(action) || ActivationServiceConstants.DEACTIVATE.getValue().equals(action) || ActivationServiceConstants.RE_ACTIVATE.getValue().equals(action)) && ActivationServiceConstants.ENVIRONMENT.getValue().equals(type)) {
                TriggerBulkPerformRequest request = (TriggerBulkPerformRequest)this.jmsMessageConverterObjectMapper.readValue(message.getText(), TriggerBulkPerformRequest.class);
                this.putMdcFields(projectUuid, request.getSessionId());
                ((EnvironmentActivationService)service).perform(request);
            } else {
                ItfConfigurationMessage request = (ItfConfigurationMessage)this.jmsMessageConverterObjectMapper.readValue(message.getText(), ItfConfigurationMessage.class);
                this.putMdcFields(projectUuid, request.getSessionId());
                ((CommonTriggerActivationService)service).perform(request.getId(), request.getAction(), request.getUser(), request.getSessionId(), projectUuid);
            }
            log.info("Message of type '{}' processing is completed", (Object)type);
        }
        catch (JsonProcessingException | JMSException e) {
            log.error("Error while message processing: {}", (Object)e.getMessage());
            this.sendFailMessageToConfigurator(message, e.getMessage());
        }
        finally {
            MDC.clear();
        }
    }

    private void processUpdateFileMessage(FileInfo fileInfo) {
        block7: {
            try {
                MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)fileInfo.getProjectUuid());
                if (!EdsContentType.WSDL_XSD.getStringValue().equals(fileInfo.getContentType()) && !EdsContentType.KEYSTORE.getStringValue().equals(fileInfo.getContentType()) && !EdsContentType.FAST_STUB.getStringValue().equals(fileInfo.getContentType())) break block7;
                switch (fileInfo.getEventType()) {
                    case UPLOAD: {
                        File savedFile = Objects.nonNull(fileInfo.getObjectId()) ? this.externalDataManagementService.getFileManagementService().save(this.externalDataManagementService.getExternalStorageService().getFileInfo(fileInfo.getObjectId())) : this.externalDataManagementService.getFileManagementService().save(fileInfo);
                        log.info("File {} is loaded into local storage successfully.", (Object)fileInfo.getFileName());
                        this.postProcess(fileInfo, savedFile);
                        break;
                    }
                    case DELETE: {
                        this.externalDataManagementService.getFileManagementService().delete(fileInfo);
                        if (EdsContentType.FAST_STUB.getStringValue().equals(fileInfo.getContentType())) {
                            String fastStubsKey = URLDecoder.decode(fileInfo.getFileName(), "UTF-8").replaceAll("__", "/").replaceAll(".json", "");
                            FastResponseConfigsHolder.INSTANCE.resetConfigByKey(fastStubsKey);
                        }
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown file event type: " + fileInfo.getEventType());
                    }
                }
            }
            catch (IOException e) {
                log.error("Error while message processing: {}", (Object)e.getMessage());
            }
        }
    }

    private void putMdcFields(String projectUuid, String sessionId) {
        this.putIfNotBlank(MdcField.PROJECT_ID.toString(), projectUuid);
        this.putIfNotBlank(MdcField.SESSION_ID.toString(), sessionId);
    }

    private void putIfNotBlank(String mdcFieldName, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            log.warn("Can't put blank value into MdcField '{}'", (Object)mdcFieldName);
            return;
        }
        MdcUtils.put((String)mdcFieldName, (String)value);
    }

    private void postProcess(FileInfo fileInfo, File savedFile) {
        if (savedFile.exists() && EdsContentType.FAST_STUB.getStringValue().equals(fileInfo.getContentType())) {
            FastResponseConfigsHolder.INSTANCE.loadFromFile(fileInfo.getProjectUuid().toString(), savedFile);
        }
    }

    static class TriggerConfigurationResponse {
        private String errorMessage;
        private StubUser user;
        private String sessionId;

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public StubUser getUser() {
            return this.user;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public void setUser(StubUser user) {
            this.user = user;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public TriggerConfigurationResponse() {
        }

        public TriggerConfigurationResponse(String errorMessage, StubUser user, String sessionId) {
            this.errorMessage = errorMessage;
            this.user = user;
            this.sessionId = sessionId;
        }
    }
}

