/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.activation;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ThreadPoolProvider {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolProvider.class);
    private static final Thread.UncaughtExceptionHandler HANDLER = (t, e) -> log.error("Uncaught exception in thread {}", (Object)t.getName(), (Object)e);
    private final ExecutorService asyncTasksPool;
    private final ForkJoinPool forkJoinPool;
    private final int asyncProcessingPoolCoreSize;
    private final int asyncProcessingPoolMaxSize;
    private final int bulkProcessingPoolSize;

    @Autowired
    public ThreadPoolProvider(@Value(value="${async.processing.pool.core.size}") int asyncProcessingPoolCoreSize, @Value(value="${async.processing.pool.max.size}") int asyncProcessingPoolMaxSize, @Value(value="${bulk.processing.forkJoinPool.size}") int bulkProcessingPoolSize) {
        this.asyncProcessingPoolCoreSize = asyncProcessingPoolCoreSize;
        this.asyncProcessingPoolMaxSize = asyncProcessingPoolMaxSize;
        this.bulkProcessingPoolSize = bulkProcessingPoolSize;
        this.asyncTasksPool = this.initAsyncPool();
        this.forkJoinPool = this.initForkJoinPool();
    }

    private ExecutorService initAsyncPool() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("asyncTasksPool-%d").setDaemon(false).setPriority(5).setUncaughtExceptionHandler(HANDLER).build();
        return new ThreadPoolExecutor(this.asyncProcessingPoolCoreSize, this.asyncProcessingPoolMaxSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    private ForkJoinPool initForkJoinPool() {
        return new ForkJoinPool(this.bulkProcessingPoolSize, ForkJoinPool.defaultForkJoinWorkerThreadFactory, HANDLER, false);
    }

    public ExecutorService getAsyncTasksPool() {
        return this.asyncTasksPool;
    }

    public ForkJoinPool getForkJoinPool() {
        return this.forkJoinPool;
    }
}

