/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.activation.impl;

import feign.FeignException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.qubership.automation.itf.activation.ActivationServiceConstants;
import org.qubership.automation.itf.activation.impl.CommonTriggerActivationService;
import org.qubership.automation.itf.core.model.communication.EnvironmentSample;
import org.qubership.automation.itf.core.model.communication.StubUser;
import org.qubership.automation.itf.core.model.communication.TriggerSample;
import org.qubership.automation.itf.core.model.communication.message.ServerTriggerStateResponse;
import org.qubership.automation.itf.core.model.communication.message.TriggerBulkPerformRequest;
import org.qubership.automation.itf.core.model.communication.message.TriggerStatusMessage;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.exception.TriggerException;
import org.qubership.automation.itf.integration.executor.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentActivationService
extends CommonTriggerActivationService {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentActivationService.class);
    private final ExecutorService executorService;
    public static final String ENVIRONMENT_ACTIVATION_ERROR_MESSAGE = "Some errors occurred during environment activation, see Stubs logs for details";
    private static final String ENVFOLDER_CLASS = "org.qubership.automation.itf.core.model.jpa.folder.EnvFolder";
    private static final String ENVIRONMENT_CLASS = "org.qubership.automation.itf.core.model.jpa.environment.Environment";

    public TriggerStatusMessage.ObjectType getServiceType() {
        return TriggerStatusMessage.ObjectType.ENVIRONMENT;
    }

    @Override
    public void perform(BigInteger id, String action, StubUser user, String sessionId, String tenantId) {
        try {
            log.info("SessionId {}, user {}, action '{}' for Env [{}] is started", new Object[]{sessionId, user, action, id});
            AtomicBoolean isSuccess = new AtomicBoolean(true);
            EnvironmentSample environmentSample = this.getTriggersUnderEnvironment(id);
            ActivationServiceConstants actionValue = environmentSample.isTurnedOn() ? ActivationServiceConstants.DEACTIVATE : ActivationServiceConstants.ACTIVATE;
            ConcurrentHashMap<String, Boolean> availableServers = new ConcurrentHashMap<String, Boolean>();
            this.processTriggers(environmentSample.getTriggerSamples(), actionValue, user, isSuccess, availableServers, action, sessionId, tenantId);
            if (isSuccess.get()) {
                String triggerStateAsString = ActivationServiceConstants.ACTIVATE.equals((Object)actionValue) ? TriggerState.ACTIVE.toString() : TriggerState.INACTIVE.toString();
                this.sendSuccessMessageToConfigurator(this.getServiceType(), id, triggerStateAsString, user, sessionId, tenantId);
                log.info("SessionId {}, user {}, action '{}' for Env [{}] is completed", new Object[]{sessionId, user, action, id});
            } else {
                this.sendFailMessageToConfigurator(this.getServiceType(), id, TriggerState.ERROR.toString(), ENVIRONMENT_ACTIVATION_ERROR_MESSAGE, user, sessionId, tenantId);
                log.warn("SessionId {}, user {}, action '{}' for Env [{}] is failed", new Object[]{sessionId, user, action, id});
            }
        }
        catch (TriggerException e) {
            log.error("Error while getting trigger by id {}. Message: {}", (Object)id, (Object)(e.getMessage() + (e.getMessage().contains("Caused by:") || Objects.isNull(e.getCause()) ? "" : "Caused by: " + e.getCause().getMessage())));
            this.sendFailMessageToConfigurator(this.getServiceType(), id, TriggerState.ERROR.toString(), e.getMessage(), user, sessionId, tenantId);
        }
    }

    public void perform(TriggerBulkPerformRequest triggerBulkPerformRequest) {
        UUID projectUuid = triggerBulkPerformRequest.getProjectUuid();
        String action = triggerBulkPerformRequest.getAction();
        StubUser user = triggerBulkPerformRequest.getUser();
        String sessionId = triggerBulkPerformRequest.getSessionId();
        log.info("Project UUID {}, SessionId {}, user {}, bulk action '{}' is started...", new Object[]{projectUuid, sessionId, user, action});
        try {
            List<TriggerSample> triggerSamples = this.getTriggersForAction(triggerBulkPerformRequest);
            ActivationServiceConstants actionConstant = ActivationServiceConstants.getByValue(triggerBulkPerformRequest.getAction());
            AtomicBoolean isSuccess = new AtomicBoolean(true);
            ConcurrentHashMap<String, Boolean> availableServers = new ConcurrentHashMap<String, Boolean>();
            this.processTriggers(triggerSamples, actionConstant, user, isSuccess, availableServers, action, sessionId, projectUuid.toString());
            Map<BigInteger, TriggerState> triggerStates = triggerSamples.stream().collect(Collectors.toMap(TriggerSample::getTriggerId, TriggerSample::getTriggerState));
            ServerTriggerStateResponse response = new ServerTriggerStateResponse(triggerStates, "", user, sessionId);
            if (isSuccess.get()) {
                this.getSender().send((Object)response, (Object)projectUuid.toString());
                log.info("Project UUID {}, SessionId {}, user {}, bulk action '{}' is completed.", new Object[]{projectUuid, sessionId, user, action});
            } else {
                response.setErrorMessage(ENVIRONMENT_ACTIVATION_ERROR_MESSAGE);
                this.getSender().send((Object)response, (Object)projectUuid.toString());
                log.warn("Project UUID {}, SessionId {}, user {}, bulk action '{}' is failed.", new Object[]{projectUuid, sessionId, user, action});
            }
        }
        catch (TriggerException e) {
            String errorMessage = ENVIRONMENT_ACTIVATION_ERROR_MESSAGE;
            ServerTriggerStateResponse response = new ServerTriggerStateResponse(new HashMap(), errorMessage, user, sessionId);
            this.getSender().send((Object)response, (Object)projectUuid.toString());
            log.error(errorMessage + ": " + e.getMessage() + (e.getMessage().contains("Caused by:") || Objects.isNull(e.getCause()) ? "" : "Caused by: " + e.getCause().getMessage()));
        }
    }

    private List<TriggerSample> getTriggersForAction(TriggerBulkPerformRequest triggerBulkPerformRequest) throws TriggerException {
        if (triggerBulkPerformRequest.isSelectedAll()) {
            return ActivationServiceConstants.RE_ACTIVATE.getValue().equals(triggerBulkPerformRequest.getAction()) ? this.getAllTriggersByProjectToReActivate(triggerBulkPerformRequest.getProjectUuid()) : this.getAllTriggersByProject(triggerBulkPerformRequest.getProjectUuid());
        }
        List<BigInteger> envFolderIds = this.getObjectIdsWithClass(ENVFOLDER_CLASS, triggerBulkPerformRequest);
        List<BigInteger> environmentIds = this.getObjectIdsWithClass(ENVIRONMENT_CLASS, triggerBulkPerformRequest);
        ArrayList<TriggerSample> triggerSamples = new ArrayList<TriggerSample>();
        try {
            ArrayList<EnvironmentSample> environmentSamples = new ArrayList<EnvironmentSample>();
            envFolderIds.forEach(id -> environmentSamples.addAll(this.getTriggersByEnvFolder((BigInteger)id)));
            for (BigInteger id2 : environmentIds) {
                environmentSamples.add(this.getTriggersUnderEnvironment(id2));
            }
            environmentSamples.forEach(environmentSample -> triggerSamples.addAll(environmentSample.getTriggerSamples()));
            if (ActivationServiceConstants.RE_ACTIVATE.getValue().equals(triggerBulkPerformRequest.getAction())) {
                return triggerSamples.stream().filter(trigger -> TriggerState.ACTIVE.equals((Object)trigger.getTriggerState()) || TriggerState.ERROR.equals((Object)trigger.getTriggerState())).collect(Collectors.toList());
            }
        }
        catch (TriggerException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return triggerSamples;
    }

    private EnvironmentSample getTriggersUnderEnvironment(BigInteger environmentId) throws TriggerException {
        EnvironmentSample environmentSample = this.executorService.getTriggersByEnvironment(environmentId);
        if (environmentSample == null) {
            throw new TriggerException("Triggers aren't found under Environment with id [" + environmentId + "]. Null is returned.");
        }
        return environmentSample;
    }

    private void logError(FeignException fe) {
        log.error("Error while getting triggers for activation. Message: {}", (Object)fe.getMessage());
    }

    private void logDuration(long startTime) {
        log.info("Request for triggers list for activation is processed in {} (s)", (Object)String.format("%.3f", (double)(System.nanoTime() - startTime) / 1.0E9));
    }

    private void logNothingToDo(boolean isEmpty) {
        if (isEmpty) {
            log.warn("List of triggers for activation received but it's empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EnvironmentSample> getTriggersByEnvFolder(BigInteger envFolderId) {
        long startTime = System.nanoTime();
        try {
            List<EnvironmentSample> environmentSamples = this.executorService.getTriggersByEnvFolder(envFolderId);
            this.logNothingToDo(environmentSamples.isEmpty());
            List<EnvironmentSample> list = environmentSamples;
            return list;
        }
        catch (FeignException fe) {
            this.logError(fe);
        }
        finally {
            this.logDuration(startTime);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TriggerSample> getAllTriggersByProject(UUID projectUuid) {
        long startTime = System.nanoTime();
        try {
            List<TriggerSample> triggerSamples = this.executorService.getAllTriggersByProject(projectUuid);
            this.logNothingToDo(triggerSamples.isEmpty());
            List<TriggerSample> list = triggerSamples;
            return list;
        }
        catch (FeignException fe) {
            this.logError(fe);
        }
        finally {
            this.logDuration(startTime);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TriggerSample> getAllTriggersByProjectToReActivate(UUID projectUuid) {
        long startTime = System.nanoTime();
        try {
            List<TriggerSample> triggerSamples = this.executorService.getAllTriggersByProjectToReActivate(projectUuid);
            this.logNothingToDo(triggerSamples.isEmpty());
            List<TriggerSample> list = triggerSamples;
            return list;
        }
        catch (FeignException fe) {
            this.logError(fe);
        }
        finally {
            this.logDuration(startTime);
        }
        return Collections.emptyList();
    }

    private List<BigInteger> getObjectIdsWithClass(String className, TriggerBulkPerformRequest request) {
        ArrayList<BigInteger> ids = new ArrayList<BigInteger>();
        if (Objects.nonNull(request.getObjects())) {
            request.getObjects().forEach(object -> {
                if (className.equals(object.getClassName())) {
                    ids.add(object.getId());
                }
            });
        }
        return ids;
    }

    public EnvironmentActivationService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

