/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.activation.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.qubership.automation.itf.activation.ActivationServiceConstants;
import org.qubership.automation.itf.activation.impl.AbstractService;
import org.qubership.automation.itf.core.model.communication.message.ServerTriggerStateResponse;
import org.qubership.automation.itf.core.model.communication.message.ServerTriggerSyncRequest;
import org.qubership.automation.itf.core.model.communication.message.TriggerStateResponse;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.springframework.stereotype.Service;

@Service
public class SystemServerTriggerActivationService
extends AbstractService {
    public void perform(ServerTriggerSyncRequest syncRequest, String tenantId) {
        ServerTriggerStateResponse deactivationResult = this.performBulkAction(syncRequest.getTriggerIdToDeactivate(), new ConcurrentHashMap<String, Boolean>(), ActivationServiceConstants.DEACTIVATE, syncRequest.getUser(), syncRequest.getSessionId());
        ServerTriggerStateResponse reactivationResult = this.performBulkAction(syncRequest.getTriggerIdToReactivate().stream().filter(triggerSample -> TriggerState.ACTIVE.equals((Object)triggerSample.getTriggerState())).collect(Collectors.toList()), new ConcurrentHashMap<String, Boolean>(), ActivationServiceConstants.SYNC, syncRequest.getUser(), syncRequest.getSessionId());
        deactivationResult.merge((TriggerStateResponse)reactivationResult);
        this.getSender().send((Object)deactivationResult, (Object)tenantId);
    }
}

