/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.activation.impl;

import java.util.HashMap;
import java.util.Map;
import org.qubership.automation.itf.core.model.communication.TransportType;

public class TransportTypeToTriggerClassMapping {
    private static final Map<TransportType, String> transportToTrigger = TransportTypeToTriggerClassMapping.initializeMap();

    private static Map<TransportType, String> initializeMap() {
        HashMap<TransportType, String> map = new HashMap<TransportType, String>();
        map.put(TransportType.CLI_INBOUND, "org.qubership.automation.itf.trigger.cli.inbound.CliTrigger");
        map.put(TransportType.FILE_INBOUND, "org.qubership.automation.itf.trigger.file.inbound.FileInboundTrigger");
        map.put(TransportType.HTTP_INBOUND, "org.qubership.automation.itf.trigger.http.inbound.HttpInboundTrigger");
        map.put(TransportType.HTTP2_INBOUND, "org.qubership.automation.itf.trigger.http2.inbound.Http2InboundTrigger");
        map.put(TransportType.JMS_INBOUND, "org.qubership.automation.itf.trigger.jms.JmsTrigger");
        map.put(TransportType.KAFKA_INBOUND, "org.qubership.automation.itf.trigger.kafka.KafkaTrigger");
        map.put(TransportType.REST_INBOUND, "org.qubership.automation.itf.trigger.rest.inbound.RestInboundTrigger");
        map.put(TransportType.SNMP_INBOUND, "org.qubership.automation.itf.trigger.snmp.inbound.SnmpTrigger");
        map.put(TransportType.SMPP_INBOUND, "org.qubership.automation.itf.trigger.smpp.inbound.SmppTrigger");
        map.put(TransportType.SOAP_OVER_HTTP_INBOUND, "org.qubership.automation.itf.trigger.soap.http.inbound.SoapOverHttpTrigger");
        return map;
    }

    public static String getTriggerClassName(TransportType transportType) {
        return transportToTrigger.get(transportType);
    }

    public static TransportType getTransportType(String triggerClassFullQualifiedName) {
        for (Map.Entry<TransportType, String> entry : transportToTrigger.entrySet()) {
            if (!entry.getValue().equals(triggerClassFullQualifiedName)) continue;
            return entry.getKey();
        }
        return null;
    }
}

