/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.activation.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentMap;
import org.qubership.automation.itf.activation.TriggersCache;
import org.qubership.automation.itf.activation.impl.TransportTypeToTriggerClassMapping;
import org.qubership.automation.itf.core.model.communication.TriggerSample;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.core.util.exception.TriggerException;
import org.qubership.automation.itf.trigger.camel.Trigger;
import org.qubership.automation.itf.utils.loader.TriggerClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TriggerMaintainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerMaintainer.class);
    @Value(value="${test.server.availability}")
    private boolean testServerAvailability;
    private TriggerClassLoader triggerClassLoader;
    private TriggersCache triggersCache;

    @Autowired
    public TriggerMaintainer(TriggersCache triggersCache, TriggerClassLoader triggerClassLoader) {
        this.triggersCache = triggersCache;
        this.triggerClassLoader = triggerClassLoader;
    }

    public void activate(TriggerSample triggerSample, ConcurrentMap<String, Boolean> availableServers) throws TriggerException {
        LOGGER.info("Activating trigger [{}]...", (Object)triggerSample.getTriggerId());
        if (this.triggersCache.get(triggerSample.getTriggerId()) != null) {
            LOGGER.warn("Trigger [{}] already activated, trying to reactivate 1st...", (Object)triggerSample.getTriggerId());
            this.deactivate(triggerSample);
        }
        Trigger trigger = this.createNewTrigger(triggerSample);
        if (this.testServerAvailability && !trigger.checkIfServerAvailable(availableServers)) {
            LOGGER.warn("Trigger [{}] activation skipped (server is unavailable)", (Object)triggerSample.getTriggerId());
            return;
        }
        trigger.activate();
        this.triggersCache.put(triggerSample.getTriggerId(), trigger);
        LOGGER.info("Trigger [{}] is activated.", (Object)triggerSample.getTriggerId());
    }

    public void deactivate(TriggerSample triggerSample) throws TriggerException {
        LOGGER.info("Deactivating trigger [{}]...", (Object)triggerSample.getTriggerId());
        Trigger trigger = this.triggersCache.get(triggerSample.getTriggerId());
        if (trigger != null) {
            trigger.deactivate();
            this.triggersCache.remove(triggerSample.getTriggerId());
            LOGGER.info("Trigger [{}] is deactivated.", (Object)triggerSample.getTriggerId());
        } else {
            LOGGER.warn("Cannot deactivate trigger [{}], trigger not found.", (Object)triggerSample.getTriggerId());
        }
    }

    public Trigger createNewTrigger(TriggerSample triggerSample) throws TriggerException {
        try {
            String triggerClass = TransportTypeToTriggerClassMapping.getTriggerClassName(triggerSample.getTransportType());
            StorableDescriptor triggerStorableDescriptor = this.createStorableDescriptorFromTriggerSample(triggerSample);
            return this.triggerClassLoader.getConstructorByClass(triggerClass, StorableDescriptor.class, ConnectionProperties.class).newInstance(triggerStorableDescriptor, triggerSample.getTriggerProperties());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new TriggerException("Error while trying to create trigger of type " + TransportTypeToTriggerClassMapping.getTriggerClassName(triggerSample.getTransportType()) + " for transport " + triggerSample.getTriggerTypeName(), (Throwable)e);
        }
    }

    private StorableDescriptor createStorableDescriptorFromTriggerSample(TriggerSample triggerSample) {
        return new StorableDescriptor((Object)triggerSample.getTriggerId(), triggerSample.getTriggerName(), triggerSample.getProjectUuid(), triggerSample.getProjectId());
    }
}

