/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.stubs.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.representations.AccessToken;
import org.qubership.automation.itf.communication.FastStubsInformation;
import org.qubership.automation.itf.communication.StubsIntegrationMessageSender;
import org.qubership.automation.itf.core.stub.fast.FastResponseConfig;
import org.qubership.automation.itf.core.stub.fast.FastResponseConfigsHolder;
import org.qubership.automation.itf.core.stub.fast.FastStubsTreeView;
import org.qubership.automation.itf.core.stub.fast.StubEndpointConfig;
import org.qubership.automation.itf.core.stub.fast.TransportConfig;
import org.qubership.automation.itf.core.util.eds.ExternalDataManagementService;
import org.qubership.automation.itf.core.util.eds.model.FileEventType;
import org.qubership.automation.itf.core.util.eds.model.FileInfo;
import org.qubership.automation.itf.core.util.eds.service.EdsContentType;
import org.qubership.automation.itf.ui.controls.FastStubsProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class FastStubsService {
    private static final Logger log = LoggerFactory.getLogger(FastStubsService.class);
    private final ExternalDataManagementService externalDataManagementService;
    private final StubsIntegrationMessageSender stubsIntegrationMessageSender;
    private final ObjectMapper objectMapper;

    @Autowired
    public FastStubsService(ExternalDataManagementService externalDataManagementService, StubsIntegrationMessageSender stubsIntegrationMessageSender, ObjectMapper objectMapper) {
        this.externalDataManagementService = externalDataManagementService;
        this.stubsIntegrationMessageSender = stubsIntegrationMessageSender;
        this.objectMapper = objectMapper;
    }

    public List<FastStubsInformation> findFastStubsConfigs(List<FastStubsInformation> fastStubsInformations, UUID projectUuid) {
        try {
            return fastStubsInformations.stream().map(fastStubsInformation -> {
                StubEndpointConfig cfg = FastResponseConfigsHolder.INSTANCE.getConfig(projectUuid.toString(), fastStubsInformation.getTransportType(), fastStubsInformation.getEndpoint());
                if (Objects.isNull(cfg)) {
                    return fastStubsInformation;
                }
                List responseDescriptions = cfg.getConditionalResponses().stream().filter(responseDescription -> responseDescription.getName().equals(fastStubsInformation.getSituationName())).collect(Collectors.toList());
                fastStubsInformation.setExist(!responseDescriptions.isEmpty() || Objects.nonNull(cfg.getDefaultResponse()) && cfg.getDefaultResponse().getName().equals(fastStubsInformation.getSituationName()));
                return fastStubsInformation;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            String error = String.format("An error occurred while find fast stubs configurations. %s", Objects.nonNull(e.getCause()) ? e.getCause().getMessage() : e.getMessage());
            log.error(error, (Throwable)e);
            throw new FastStubsProcessingException(error);
        }
    }

    public List<FastStubsTreeView> endpoints(UUID projectUuid) {
        try {
            return FastResponseConfigsHolder.INSTANCE.getEndpoints(projectUuid);
        }
        catch (Exception e) {
            String error = String.format("An error occurred while retrieving the list of fast stubs configuration. %s", Objects.nonNull(e.getCause()) ? e.getCause().getMessage() : e.getMessage());
            log.error(error, (Throwable)e);
            throw new FastStubsProcessingException(error);
        }
    }

    public StubEndpointConfig getConfiguration(String configuredEndpoint, StubEndpointConfig.TransportTypes transportTypes, UUID projectUuid) {
        try {
            return FastResponseConfigsHolder.INSTANCE.getConfig(projectUuid.toString(), transportTypes.toString(), configuredEndpoint);
        }
        catch (Exception e) {
            String error = String.format("An error occurred while retrieving fast stubs configuration. %s", Objects.nonNull(e.getCause()) ? e.getCause().getMessage() : e.getMessage());
            log.error(error, (Throwable)e);
            throw new FastStubsProcessingException(error);
        }
    }

    public void updateConfiguration(StubEndpointConfig.TransportTypes transportTypes, StubEndpointConfig stubEndpointConfig, UUID projectUuid) {
        try {
            FastResponseConfig fastConfig = new FastResponseConfig();
            fastConfig.setProjectUuid(projectUuid.toString());
            TransportConfig trConfig = new TransportConfig();
            trConfig.setTransportType(transportTypes);
            trConfig.setEndpoints(Collections.singletonList(stubEndpointConfig));
            fastConfig.setTransportConfigs(Collections.singletonList(trConfig));
            String fileName = String.format("%s__%s__%s.json", projectUuid, transportTypes.name(), URLEncoder.encode(stubEndpointConfig.getConfiguredEndpoint(), "UTF-8"));
            Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            String userName = "Undefined";
            UUID userId = null;
            if (principal instanceof KeycloakPrincipal) {
                AccessToken accessToken = ((KeycloakPrincipal)principal).getKeycloakSecurityContext().getToken();
                userId = UUID.fromString(((KeycloakPrincipal)principal).getName());
                userName = accessToken.getName();
            }
            this.storeFileAndNotifyInstances(fileName, new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)fastConfig)), userName, userId, projectUuid);
        }
        catch (JsonProcessingException | UnsupportedEncodingException e) {
            String error = String.format("Error while update fast stubs configuration. %s", Objects.nonNull(e.getCause()) ? e.getCause().getMessage() : e.getMessage());
            log.error(error, e);
            throw new FastStubsProcessingException(error);
        }
    }

    public void deleteConfiguration(List<FastStubsTreeView> fastStubsTreeViews, UUID projectUuid) {
        try {
            for (FastStubsTreeView fastStubsTreeView : fastStubsTreeViews) {
                String fileName = String.format("%s__%s__%s.json", projectUuid, fastStubsTreeView.getTransportType().name(), URLEncoder.encode(fastStubsTreeView.getEndpoint(), "UTF-8"));
                this.externalDataManagementService.getExternalStorageService().delete(EdsContentType.FAST_STUB.getStringValue(), projectUuid, "", fileName);
                this.sendMessageToExternalDataStorageUpdateTopic(null, fileName, "", EdsContentType.FAST_STUB.getStringValue(), projectUuid, null, FileEventType.DELETE, this.stubsIntegrationMessageSender, projectUuid.toString());
            }
        }
        catch (Exception e) {
            String error = String.format("Error while deleting fast stubs configuration. %s", Objects.nonNull(e.getCause()) ? e.getCause().getMessage() : e.getMessage());
            log.error(error, (Throwable)e);
            throw new FastStubsProcessingException(error);
        }
    }

    private void storeFileAndNotifyInstances(String fileName, InputStream inputStream, String userName, UUID userId, UUID projectUuid) {
        ObjectId storedObjectId = this.externalDataManagementService.getExternalStorageService().store(EdsContentType.FAST_STUB.getStringValue(), projectUuid, userName, userId, "", fileName, inputStream);
        this.checkStoredObjectIdAndSendMessageToExternalDataStorageUpdateTopic(storedObjectId, fileName, EdsContentType.FAST_STUB.getStringValue(), projectUuid, inputStream, this.stubsIntegrationMessageSender, projectUuid.toString());
    }

    private void checkStoredObjectIdAndSendMessageToExternalDataStorageUpdateTopic(ObjectId storedObjectId, String fileName, String contentType, UUID projectUuid, InputStream inputStream, StubsIntegrationMessageSender stubsIntegrationMessageSender, String tenantId) {
        log.info("Stored object id for file '{}' is {}null", (Object)fileName, (Object)(storedObjectId == null ? "" : "not "));
        if (storedObjectId != null) {
            this.sendMessageToExternalDataStorageUpdateTopic(storedObjectId, fileName, "", contentType, projectUuid, null, FileEventType.UPLOAD, stubsIntegrationMessageSender, tenantId);
        } else {
            this.sendMessageToExternalDataStorageUpdateTopic(null, fileName, "", contentType, projectUuid, inputStream, FileEventType.UPLOAD, stubsIntegrationMessageSender, tenantId);
        }
    }

    private void sendMessageToExternalDataStorageUpdateTopic(ObjectId objectId, String fileName, String filePath, String contentType, UUID projectUuid, InputStream inputStream, FileEventType eventType, StubsIntegrationMessageSender stubsIntegrationMessageSender, String tenantId) {
        stubsIntegrationMessageSender.sendToEdsUpdateTopic((Object)new FileInfo(objectId, fileName, filePath, contentType, projectUuid, inputStream, eventType), (Object)tenantId);
    }
}

