/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.config;

import java.util.Set;
import javax.annotation.PostConstruct;
import org.qubership.automation.itf.activation.impl.OnDestroyTriggersActivationService;
import org.qubership.automation.itf.activation.impl.OnStartupTriggersActivationService;
import org.qubership.automation.itf.utils.loader.TriggerClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TriggerContext {
    private static final Logger log = LoggerFactory.getLogger(TriggerContext.class);
    private final OnStartupTriggersActivationService onStartupTriggersActivationService;
    private final OnDestroyTriggersActivationService onDestroyTriggersActivationService;
    private final TriggerClassLoader triggerClassLoader;
    @Value(value="${trigger.folder}")
    private String triggerFolder;
    @Value(value="${trigger.lib}")
    private String triggersCustomLibFolder;

    @Autowired
    public TriggerContext(OnStartupTriggersActivationService onStartupTriggersActivationService, OnDestroyTriggersActivationService onDestroyTriggersActivationService, TriggerClassLoader triggerClassLoader) {
        this.onStartupTriggersActivationService = onStartupTriggersActivationService;
        this.onDestroyTriggersActivationService = onDestroyTriggersActivationService;
        this.triggerClassLoader = triggerClassLoader;
    }

    @PostConstruct
    public void init() {
        log.info("Start triggers loading...");
        try {
            this.triggerClassLoader.load(this.triggerFolder, this.triggersCustomLibFolder);
            log.info("Triggers are loaded successfully.");
        }
        catch (Exception e) {
            log.error("Error initialing triggers modules", (Throwable)e);
        }
    }

    public Thread activateTriggers() {
        Thread thread = new Thread(() -> {
            Set<String> triggerTypes = this.triggerClassLoader.getClassLoaderHolder().keySet();
            this.onStartupTriggersActivationService.perform(triggerTypes);
        });
        thread.start();
        return thread;
    }

    public void destroy() {
        this.triggerClassLoader.cleanClassLoaders();
        this.onDestroyTriggersActivationService.perform();
    }

    public boolean isListForActivationReceived() {
        return this.onStartupTriggersActivationService.isListForActivationReceived();
    }
}

