/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import java.util.List;
import java.util.UUID;
import org.qubership.automation.itf.communication.FastStubsInformation;
import org.qubership.automation.itf.core.stub.fast.FastStubsTreeView;
import org.qubership.automation.itf.core.stub.fast.StubEndpointConfig;
import org.qubership.automation.itf.stubs.service.FastStubsService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FastStubsController {
    private final FastStubsService fastStubsService;

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @PostMapping(value={"/fast-stubs/findConfigs"}, consumes={"application/json"}, produces={"application/json"})
    public List<FastStubsInformation> findFastStubsConfigs(@RequestBody List<FastStubsInformation> fastStubsCandidates, @RequestParam UUID projectUuid) {
        return this.fastStubsService.findFastStubsConfigs(fastStubsCandidates, projectUuid);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/fast-stubs/endpoints"})
    public List<FastStubsTreeView> endpoints(@RequestParam UUID projectUuid) {
        return this.fastStubsService.endpoints(projectUuid);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/fast-stubs/configuration/get"})
    public StubEndpointConfig getConfiguration(@RequestParam String configuredEndpoint, @RequestParam StubEndpointConfig.TransportTypes transportTypes, @RequestParam UUID projectUuid) {
        return this.fastStubsService.getConfiguration(configuredEndpoint, transportTypes, projectUuid);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @PutMapping(value={"/fast-stubs/configuration/update"})
    public void updateConfiguration(@RequestBody StubEndpointConfig stubEndpointConfig, @RequestParam StubEndpointConfig.TransportTypes transportTypes, @RequestParam UUID projectUuid) {
        this.fastStubsService.updateConfiguration(transportTypes, stubEndpointConfig, projectUuid);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"DELETE\")")
    @DeleteMapping(value={"/fast-stubs/configuration/delete"})
    public void deleteConfiguration(@RequestBody List<FastStubsTreeView> fastStubsTreeViews, @RequestParam UUID projectUuid) {
        this.fastStubsService.deleteConfiguration(fastStubsTreeViews, projectUuid);
    }

    public FastStubsController(FastStubsService fastStubsService) {
        this.fastStubsService = fastStubsService;
    }
}

