/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.activation.impl;

import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.qubership.automation.itf.activation.ActivationServiceConstants;
import org.qubership.automation.itf.activation.impl.CommonTriggerActivationService;
import org.qubership.automation.itf.core.model.communication.Result;
import org.qubership.automation.itf.core.model.communication.StubUser;
import org.qubership.automation.itf.core.model.communication.TriggerSample;
import org.qubership.automation.itf.core.model.communication.message.TriggerStatusMessage;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.integration.executor.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TriggerActivationService
extends CommonTriggerActivationService {
    private static final Logger log = LoggerFactory.getLogger(TriggerActivationService.class);
    private final ExecutorService executorService;

    public TriggerStatusMessage.ObjectType getServiceType() {
        return TriggerStatusMessage.ObjectType.TRIGGER;
    }

    @Override
    public void perform(BigInteger id, String action, StubUser user, String sessionId, String tenantId) {
        block7: {
            log.info("SessionId {}, user {}, action '{}' for Trigger [{}] is started", new Object[]{sessionId, user, action, id});
            ActivationServiceConstants actionByValue = ActivationServiceConstants.getByValue(action);
            if (actionByValue != null) {
                try {
                    TriggerSample triggerSample = this.getTriggerConfiguration(id);
                    if (triggerSample != null) {
                        Result result = this.performActionForTrigger(triggerSample, actionByValue, user, new ConcurrentHashMap<String, Boolean>());
                        if (result.isSuccess()) {
                            String triggerStateAsString = ActivationServiceConstants.ACTIVATE.getValue().equals(action) ? TriggerState.ACTIVE.toString() : TriggerState.INACTIVE.toString();
                            this.sendSuccessMessageToConfigurator(this.getServiceType(), id, triggerStateAsString, user, sessionId, tenantId);
                            log.info("SessionId {}, user {}, action '{}' for Trigger [{}] is succeeded", new Object[]{sessionId, user, action, id});
                        } else {
                            this.sendFailMessageToConfigurator(this.getServiceType(), id, TriggerState.ERROR.toString(), result.getMessage(), user, sessionId, tenantId);
                            log.error("SessionId {}, user {}, action '{}' for Trigger [{}] is failed: {}", new Object[]{sessionId, user, action, id, result.getMessage()});
                        }
                        break block7;
                    }
                    this.sendFailMessageToConfigurator(this.getServiceType(), id, null, ActivationServiceConstants.TRIGGER_NOT_FOUND.getValueWithArgs(id), user, sessionId, tenantId);
                    log.error("Trigger isn't found by id {}. Status isn't changed.", (Object)id);
                }
                catch (Exception e) {
                    this.sendFailMessageToConfigurator(this.getServiceType(), id, null, ActivationServiceConstants.TRIGGER_NOT_FOUND.getValueWithArgs(id), user, sessionId, tenantId);
                    log.error("Error while getting trigger by id {}. Message: {}", (Object)id, (Object)(e.getMessage() + (e.getMessage().contains("Caused by:") || Objects.isNull(e.getCause()) ? "" : "Caused by: " + e.getCause().getMessage())));
                }
            } else {
                this.sendFailMessageToConfigurator(this.getServiceType(), id, null, ActivationServiceConstants.ACTION_NOT_VALID.getValueWithArgs(action), user, sessionId, tenantId);
                log.error("Action '{}' isn't valid. Status isn't changed.", (Object)action);
            }
        }
    }

    private TriggerSample getTriggerConfiguration(BigInteger triggerId) {
        TriggerSample triggerSample = this.executorService.getTriggerById(triggerId);
        if (triggerSample == null) {
            log.warn("Trigger isn't found by id {}. Null is returned", (Object)triggerId);
            return null;
        }
        return triggerSample;
    }

    public TriggerActivationService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

