/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.eds.ExternalDataManagementService;
import org.qubership.automation.itf.core.util.eds.service.GridFsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"embedded.https.enabled"}, havingValue="true")
public class ItfSslConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ItfSslConfiguration.class);
    @Value(value="${keystore.password}")
    private String keystorePassword;
    @Autowired
    private ExternalDataManagementService externalDataManagementService;

    @Bean
    public TrustManagerFactory trustManagerFactory(KeyStore keyStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return trustManagerFactory;
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            log.error("Can not create TrustManagerFactory.", (Throwable)e);
            throw new RuntimeException("Can not create TrustManagerFactory.", e);
        }
    }

    @Bean
    public KeyManagerFactory keyManagerFactory(KeyStore keyStore) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.keystorePassword.toCharArray());
            return keyManagerFactory;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            log.error("Can not create KeyManagerFactory.", (Throwable)e);
            throw new RuntimeException("Can not create KeyManagerFactory.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Bean
    public KeyStore keyStore() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this.getKeystoreFileFromExternalStorage();
        String keyStoreFile = Config.getConfig().getString("local.storage.directory").concat("/keystore/keystore.jks");
        KeyStore keyStore = KeyStore.getInstance("jks");
        try (FileInputStream keystoreFileInputStream = new FileInputStream(keyStoreFile);){
            keyStore.load(keystoreFileInputStream, this.keystorePassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (FileNotFoundException e) {
            log.error("File with certificates not found.", (Throwable)e);
            throw new RuntimeException("File with certificates not found.", e);
        }
    }

    private void getKeystoreFileFromExternalStorage() {
        try {
            if (this.externalDataManagementService.getExternalStorageService() instanceof GridFsService) {
                this.externalDataManagementService.getFileManagementService().save((Collection)this.externalDataManagementService.getExternalStorageService().getKeyStoreFileInfo());
            }
        }
        catch (IOException e) {
            log.error("Error loading files of keystore type from GridFs.", (Throwable)e);
        }
    }
}

