package org.qubership.automation.itf.openapi.executor.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TriggerSampleDto
 */

@JsonTypeName("TriggerSample")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-08-08T11:26:03.709Z[Etc/UTC]")
public class TriggerSampleDto {

  @JsonProperty("triggerId")
  private String triggerId;

  @JsonProperty("triggerName")
  private String triggerName;

  @JsonProperty("triggerTypeName")
  private String triggerTypeName;

  @JsonProperty("transportName")
  private String transportName;

  @JsonProperty("serverName")
  private String serverName;

  /**
   * Gets or Sets triggerState
   */
  public enum TriggerStateEnum {
    ACTIVE("Active"),
    
    INACTIVE("Inactive"),
    
    ERROR("Error"),
    
    STARTING("Starting"),
    
    SHUTTING_DOWN("Shutting down"),
    
    ACTIVE_NOT_ALL_("Active (Not all)"),
    
    ACTIVE_ERRORS_("Active (Errors)"),
    
    EMPTY("Empty");

    private String value;

    TriggerStateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TriggerStateEnum fromValue(String value) {
      for (TriggerStateEnum b : TriggerStateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("triggerState")
  private TriggerStateEnum triggerState;

  /**
   * Gets or Sets transportType
   */
  public enum TransportTypeEnum {
    CLI_INBOUND("CLI_INBOUND"),
    
    FILE_INBOUND("FILE_INBOUND"),
    
    HTTP_INBOUND("HTTP_INBOUND"),
    
    HTTP2_INBOUND("HTTP2_INBOUND"),
    
    JMS_INBOUND("JMS_INBOUND"),
    
    KAFKA_INBOUND("KAFKA_INBOUND"),
    
    REST_INBOUND("REST_INBOUND"),
    
    SNMP_INBOUND("SNMP_INBOUND"),
    
    SOAP_OVER_HTTP_INBOUND("SOAP_OVER_HTTP_INBOUND"),
    
    SMPP_INBOUND("SMPP_INBOUND");

    private String value;

    TransportTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TransportTypeEnum fromValue(String value) {
      for (TransportTypeEnum b : TransportTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("transportType")
  private TransportTypeEnum transportType;

  @JsonProperty("triggerProperties")
  @Valid
  private Map<String, Object> triggerProperties = null;

  @JsonProperty("projectUuid")
  private UUID projectUuid;

  @JsonProperty("projectId")
  private BigInteger projectId = null;

  public TriggerSampleDto triggerId(String triggerId) {
    this.triggerId = triggerId;
    return this;
  }

  /**
   * Get triggerId
   * @return triggerId
  */
  
  @Schema(name = "triggerId", required = false)
  public String getTriggerId() {
    return triggerId;
  }

  public void setTriggerId(String triggerId) {
    this.triggerId = triggerId;
  }

  public TriggerSampleDto triggerName(String triggerName) {
    this.triggerName = triggerName;
    return this;
  }

  /**
   * Get triggerName
   * @return triggerName
  */
  
  @Schema(name = "triggerName", required = false)
  public String getTriggerName() {
    return triggerName;
  }

  public void setTriggerName(String triggerName) {
    this.triggerName = triggerName;
  }

  public TriggerSampleDto triggerTypeName(String triggerTypeName) {
    this.triggerTypeName = triggerTypeName;
    return this;
  }

  /**
   * Get triggerTypeName
   * @return triggerTypeName
  */
  
  @Schema(name = "triggerTypeName", required = false)
  public String getTriggerTypeName() {
    return triggerTypeName;
  }

  public void setTriggerTypeName(String triggerTypeName) {
    this.triggerTypeName = triggerTypeName;
  }

  public TriggerSampleDto transportName(String transportName) {
    this.transportName = transportName;
    return this;
  }

  /**
   * Get transportName
   * @return transportName
  */
  
  @Schema(name = "transportName", required = false)
  public String getTransportName() {
    return transportName;
  }

  public void setTransportName(String transportName) {
    this.transportName = transportName;
  }

  public TriggerSampleDto serverName(String serverName) {
    this.serverName = serverName;
    return this;
  }

  /**
   * Get serverName
   * @return serverName
  */
  
  @Schema(name = "serverName", required = false)
  public String getServerName() {
    return serverName;
  }

  public void setServerName(String serverName) {
    this.serverName = serverName;
  }

  public TriggerSampleDto triggerState(TriggerStateEnum triggerState) {
    this.triggerState = triggerState;
    return this;
  }

  /**
   * Get triggerState
   * @return triggerState
  */
  
  @Schema(name = "triggerState", required = false)
  public TriggerStateEnum getTriggerState() {
    return triggerState;
  }

  public void setTriggerState(TriggerStateEnum triggerState) {
    this.triggerState = triggerState;
  }

  public TriggerSampleDto transportType(TransportTypeEnum transportType) {
    this.transportType = transportType;
    return this;
  }

  /**
   * Get transportType
   * @return transportType
  */
  
  @Schema(name = "transportType", required = false)
  public TransportTypeEnum getTransportType() {
    return transportType;
  }

  public void setTransportType(TransportTypeEnum transportType) {
    this.transportType = transportType;
  }

  public TriggerSampleDto triggerProperties(Map<String, Object> triggerProperties) {
    this.triggerProperties = triggerProperties;
    return this;
  }

  public TriggerSampleDto putTriggerPropertiesItem(String key, Object triggerPropertiesItem) {
    if (this.triggerProperties == null) {
      this.triggerProperties = new HashMap<>();
    }
    this.triggerProperties.put(key, triggerPropertiesItem);
    return this;
  }

  /**
   * Get triggerProperties
   * @return triggerProperties
  */
  
  @Schema(name = "triggerProperties", required = false)
  public Map<String, Object> getTriggerProperties() {
    return triggerProperties;
  }

  public void setTriggerProperties(Map<String, Object> triggerProperties) {
    this.triggerProperties = triggerProperties;
  }

  public TriggerSampleDto projectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
    return this;
  }

  /**
   * Get projectUuid
   * @return projectUuid
  */
  @Valid 
  @Schema(name = "projectUuid", required = false)
  public UUID getProjectUuid() {
    return projectUuid;
  }

  public void setProjectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
  }

  public TriggerSampleDto projectId(BigInteger projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Get projectId
   * @return projectId
  */
  @Valid 
  @Schema(name = "projectId", required = false)
  public BigInteger getProjectId() {
    return projectId;
  }

  public void setProjectId(BigInteger projectId) {
    this.projectId = projectId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TriggerSampleDto triggerSample = (TriggerSampleDto) o;
    return Objects.equals(this.triggerId, triggerSample.triggerId) &&
        Objects.equals(this.triggerName, triggerSample.triggerName) &&
        Objects.equals(this.triggerTypeName, triggerSample.triggerTypeName) &&
        Objects.equals(this.transportName, triggerSample.transportName) &&
        Objects.equals(this.serverName, triggerSample.serverName) &&
        Objects.equals(this.triggerState, triggerSample.triggerState) &&
        Objects.equals(this.transportType, triggerSample.transportType) &&
        Objects.equals(this.triggerProperties, triggerSample.triggerProperties) &&
        Objects.equals(this.projectUuid, triggerSample.projectUuid) &&
        Objects.equals(this.projectId, triggerSample.projectId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(triggerId, triggerName, triggerTypeName, transportName, serverName, triggerState, transportType, triggerProperties, projectUuid, projectId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TriggerSampleDto {\n");
    sb.append("    triggerId: ").append(toIndentedString(triggerId)).append("\n");
    sb.append("    triggerName: ").append(toIndentedString(triggerName)).append("\n");
    sb.append("    triggerTypeName: ").append(toIndentedString(triggerTypeName)).append("\n");
    sb.append("    transportName: ").append(toIndentedString(transportName)).append("\n");
    sb.append("    serverName: ").append(toIndentedString(serverName)).append("\n");
    sb.append("    triggerState: ").append(toIndentedString(triggerState)).append("\n");
    sb.append("    transportType: ").append(toIndentedString(transportType)).append("\n");
    sb.append("    triggerProperties: ").append(toIndentedString(triggerProperties)).append("\n");
    sb.append("    projectUuid: ").append(toIndentedString(projectUuid)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

