/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.activation.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.qubership.automation.itf.activation.ActivationServiceConstants;
import org.qubership.automation.itf.activation.ThreadPoolProvider;
import org.qubership.automation.itf.activation.impl.ActivationService;
import org.qubership.automation.itf.activation.impl.TriggerMaintainer;
import org.qubership.automation.itf.communication.StubsIntegrationMessageSender;
import org.qubership.automation.itf.core.model.communication.Result;
import org.qubership.automation.itf.core.model.communication.StubUser;
import org.qubership.automation.itf.core.model.communication.TriggerSample;
import org.qubership.automation.itf.core.model.communication.UpdateTriggerStatusRequest;
import org.qubership.automation.itf.core.model.communication.message.ServerTriggerStateResponse;
import org.qubership.automation.itf.core.model.communication.message.TriggerStatusMessage;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.integration.executor.ExecutorService;
import org.qubership.automation.itf.monitoring.metrics.Metric;
import org.qubership.automation.itf.monitoring.metrics.MetricsAggregateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractService
implements ActivationService {
    private static final Logger log = LoggerFactory.getLogger(AbstractService.class);
    private StubsIntegrationMessageSender sender;
    private ExecutorService executorService;
    private TriggerMaintainer triggerMaintainer;
    private MetricsAggregateService metricsAggregateService;
    private ThreadPoolProvider threadPoolProvider;
    private int bulkProcessingMaxTime;

    @Autowired
    public void setSender(StubsIntegrationMessageSender sender) {
        this.sender = sender;
    }

    @Autowired
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Autowired
    public void setTriggerMaintainer(TriggerMaintainer triggerMaintainer) {
        this.triggerMaintainer = triggerMaintainer;
    }

    @Autowired
    public void setMetricsAggregateService(MetricsAggregateService metricsAggregateService) {
        this.metricsAggregateService = metricsAggregateService;
    }

    @Autowired
    public void setThreadPoolProvider(ThreadPoolProvider threadPoolProvider) {
        this.threadPoolProvider = threadPoolProvider;
    }

    @Autowired
    public void setBulkProcessingMaxTime(@Value(value="${bulk.processing.max.time}") int bulkProcessingMaxTime) {
        this.bulkProcessingMaxTime = bulkProcessingMaxTime;
    }

    protected void sendSuccessMessageToConfigurator(TriggerStatusMessage.ObjectType objectType, BigInteger id, String status, StubUser user, String sessionId, String tenantId) {
        TriggerStatusMessage message = new TriggerStatusMessage(objectType, id, status, "", user, sessionId);
        message.setSuccess(true);
        this.sender.send((Object)message, (Object)tenantId);
    }

    protected void sendFailMessageToConfigurator(TriggerStatusMessage.ObjectType objectType, BigInteger id, String status, String description, StubUser user, String sessionId, String tenantId) {
        TriggerStatusMessage message = new TriggerStatusMessage(objectType, id, status, description, user, sessionId);
        this.sender.send((Object)message, (Object)tenantId);
    }

    protected Result updateTriggerStatus(BigInteger id, String status, String description) {
        UpdateTriggerStatusRequest request = new UpdateTriggerStatusRequest(id, status, description);
        return this.executorService.updateTriggerStatus(request);
    }

    protected void processTriggers(List<TriggerSample> triggers, ActivationServiceConstants actionValue, StubUser user, AtomicBoolean isSuccess, ConcurrentMap<String, Boolean> availableServers, String action, String sessionId, String projectUuid) {
        ConcurrentHashMap<BigInteger, TriggerState> triggerStates = new ConcurrentHashMap<BigInteger, TriggerState>();
        this.threadPoolProvider.getForkJoinPool().submit(() -> ((Stream)triggers.stream().parallel()).forEach(triggerSample -> {
            log.info("Project UUID {}, SessionId {}, user {}, action '{}' for Trigger [{}] is started...", new Object[]{projectUuid, sessionId, user, action, triggerSample.getTriggerId()});
            this.performActionForTrigger((TriggerSample)triggerSample, actionValue, user, isSuccess, availableServers);
            triggerStates.put(triggerSample.getTriggerId(), triggerSample.getTriggerState());
        }));
        this.waitForCompletion(sessionId, triggers.size(), triggerStates);
    }

    protected Result performActionForTrigger(TriggerSample triggerSample, ActivationServiceConstants actionValue, ConcurrentMap<String, Boolean> availableServers) {
        return this.performActionForTrigger(triggerSample, actionValue, new StubUser("Stubs"), availableServers);
    }

    protected void performActionForTrigger(TriggerSample triggerSample, ActivationServiceConstants actionValue, StubUser user, AtomicBoolean isSuccess, ConcurrentMap<String, Boolean> availableServers) {
        Result result = this.performActionForTrigger(triggerSample, actionValue, user, availableServers);
        if (!result.isSuccess()) {
            isSuccess.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result performActionForTrigger(TriggerSample triggerSample, ActivationServiceConstants action, StubUser user, ConcurrentMap<String, Boolean> availableServers) {
        Result result;
        long startTime = System.nanoTime();
        try {
            result = this.doTriggerAction(triggerSample, action, availableServers);
        }
        catch (Exception exc) {
            Result result2;
            try {
                String errorDescription = String.format("Error while %s the trigger with id %s. Cause: %s", new Object[]{action, triggerSample.getTriggerId(), exc.getCause()});
                this.metricsAggregateService.incrementRequestToProject(triggerSample.getProjectUuid(), Metric.ATP_ITF_STUBS_ERROR_TRIGGER_BY_PROJECT);
                log.error(errorDescription, (Throwable)exc);
                try {
                    this.updateTriggerStatus(triggerSample.getTriggerId(), TriggerState.ERROR.toString(), errorDescription);
                }
                catch (Exception e) {
                    log.error("Error while updating trigger status via executor: ", (Throwable)exc);
                }
                result2 = new Result(false, errorDescription);
            }
            catch (Throwable throwable) {
                long elapsedTime = System.nanoTime() - startTime;
                log.info("Trigger '{}' [ID={}] duration for {}: {} (s)", new Object[]{triggerSample.getTriggerName(), triggerSample.getTriggerId(), action, String.format("%.3f", (double)elapsedTime / 1.0E9)});
                throw throwable;
            }
            long elapsedTime = System.nanoTime() - startTime;
            log.info("Trigger '{}' [ID={}] duration for {}: {} (s)", new Object[]{triggerSample.getTriggerName(), triggerSample.getTriggerId(), action, String.format("%.3f", (double)elapsedTime / 1.0E9)});
            return result2;
        }
        long elapsedTime = System.nanoTime() - startTime;
        log.info("Trigger '{}' [ID={}] duration for {}: {} (s)", new Object[]{triggerSample.getTriggerName(), triggerSample.getTriggerId(), action, String.format("%.3f", (double)elapsedTime / 1.0E9)});
        return result;
    }

    protected Result doTriggerAction(TriggerSample triggerSample, ActivationServiceConstants action, ConcurrentMap<String, Boolean> availableServers) throws Exception {
        TriggerState state;
        Result response = new Result();
        switch (action) {
            case SWITCH: {
                if (!triggerSample.getTriggerState().equals((Object)TriggerState.INACTIVE)) {
                    if (triggerSample.getTriggerState().equals((Object)TriggerState.ACTIVE)) {
                        this.triggerMaintainer.deactivate(triggerSample);
                    }
                    state = TriggerState.INACTIVE;
                    break;
                }
                this.triggerMaintainer.activate(triggerSample, availableServers);
                state = TriggerState.ACTIVE;
                this.metricsAggregateService.incrementRequestToProject(triggerSample.getProjectUuid(), Metric.ATP_ITF_STUBS_ACTIVE_TRIGGER_BY_PROJECT);
                break;
            }
            case ACTIVATE: {
                this.triggerMaintainer.activate(triggerSample, availableServers);
                state = TriggerState.ACTIVE;
                this.metricsAggregateService.incrementRequestToProject(triggerSample.getProjectUuid(), Metric.ATP_ITF_STUBS_ACTIVE_TRIGGER_BY_PROJECT);
                break;
            }
            case DEACTIVATE: {
                this.triggerMaintainer.deactivate(triggerSample);
                state = TriggerState.INACTIVE;
                break;
            }
            case SYNC: 
            case RE_ACTIVATE: {
                this.doTriggerAction(triggerSample, ActivationServiceConstants.DEACTIVATE, availableServers);
                this.doTriggerAction(triggerSample, ActivationServiceConstants.ACTIVATE, availableServers);
                state = TriggerState.ACTIVE;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected action: " + (Object)((Object)action) + " for trigger with id: " + triggerSample.getTriggerId());
            }
        }
        try {
            response = this.updateTriggerStatus(triggerSample.getTriggerId(), state.toString(), "");
            triggerSample.setTriggerState(state);
        }
        catch (Exception e) {
            log.error("Error while updating trigger status via executor: ", (Throwable)e);
        }
        return response;
    }

    public void activateListOfTriggers(List<TriggerSample> triggers, ConcurrentMap<String, Boolean> availableServers, String sessionId) {
        StubUser user = new StubUser();
        user.setId("0");
        user.setName("itf");
        this.performBulkAction(triggers, availableServers, ActivationServiceConstants.ACTIVATE, user, sessionId);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Checked; result of pool.submit() is not needed currently")
    public ServerTriggerStateResponse performBulkAction(List<TriggerSample> triggers, ConcurrentMap<String, Boolean> availableServers, ActivationServiceConstants action, StubUser user, String sessionId) {
        ConcurrentHashMap<BigInteger, TriggerState> triggerStates = new ConcurrentHashMap<BigInteger, TriggerState>();
        if (triggers.isEmpty()) {
            log.info("Session {}, action {}: No triggers to process.", (Object)sessionId, (Object)action);
            return new ServerTriggerStateResponse(triggerStates, "", user, sessionId);
        }
        this.threadPoolProvider.getForkJoinPool().submit(() -> ((Stream)triggers.stream().parallel()).forEach(triggerSample -> {
            this.performActionForTrigger((TriggerSample)triggerSample, action, availableServers);
            triggerStates.put(triggerSample.getTriggerId(), triggerSample.getTriggerState());
        }));
        this.waitForCompletion(sessionId, triggers.size(), triggerStates);
        return new ServerTriggerStateResponse(triggerStates, "", user, sessionId);
    }

    private void waitForCompletion(String sessionId, int totalCount, Map<BigInteger, TriggerState> triggerStates) {
        long startingTimestamp = System.currentTimeMillis();
        while (triggerStates.size() < totalCount) {
            try {
                if (System.currentTimeMillis() - startingTimestamp > (long)this.bulkProcessingMaxTime) {
                    log.warn("Session {}: processing is interrupted due to max time limit {} ms", (Object)sessionId, (Object)this.bulkProcessingMaxTime);
                    break;
                }
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                log.warn("Session {}: processing is interrupted after {} ms", (Object)sessionId, (Object)(System.currentTimeMillis() - startingTimestamp));
                break;
            }
        }
        log.info("Session {}: All ({}) triggers are processed, elapsed {} ms {}", new Object[]{sessionId, totalCount, System.currentTimeMillis() - startingTimestamp, totalCount - triggerStates.size() > 0 ? ", pending count: " + (totalCount - triggerStates.size()) : ""});
    }

    public StubsIntegrationMessageSender getSender() {
        return this.sender;
    }
}

