/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.openapi.executor.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;

@JsonTypeName(value="TriggerSample")
public class TriggerSampleDto {
    @JsonProperty(value="triggerId")
    private String triggerId;
    @JsonProperty(value="triggerName")
    private String triggerName;
    @JsonProperty(value="triggerTypeName")
    private String triggerTypeName;
    @JsonProperty(value="transportName")
    private String transportName;
    @JsonProperty(value="serverName")
    private String serverName;
    @JsonProperty(value="triggerState")
    private TriggerStateEnum triggerState;
    @JsonProperty(value="transportType")
    private TransportTypeEnum transportType;
    @JsonProperty(value="triggerProperties")
    @Valid
    private Map<String, Object> triggerProperties = null;
    @JsonProperty(value="projectUuid")
    private UUID projectUuid;
    @JsonProperty(value="projectId")
    private BigInteger projectId = null;

    public TriggerSampleDto triggerId(String triggerId) {
        this.triggerId = triggerId;
        return this;
    }

    @Schema(name="triggerId", required=false)
    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public TriggerSampleDto triggerName(String triggerName) {
        this.triggerName = triggerName;
        return this;
    }

    @Schema(name="triggerName", required=false)
    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public TriggerSampleDto triggerTypeName(String triggerTypeName) {
        this.triggerTypeName = triggerTypeName;
        return this;
    }

    @Schema(name="triggerTypeName", required=false)
    public String getTriggerTypeName() {
        return this.triggerTypeName;
    }

    public void setTriggerTypeName(String triggerTypeName) {
        this.triggerTypeName = triggerTypeName;
    }

    public TriggerSampleDto transportName(String transportName) {
        this.transportName = transportName;
        return this;
    }

    @Schema(name="transportName", required=false)
    public String getTransportName() {
        return this.transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }

    public TriggerSampleDto serverName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    @Schema(name="serverName", required=false)
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public TriggerSampleDto triggerState(TriggerStateEnum triggerState) {
        this.triggerState = triggerState;
        return this;
    }

    @Schema(name="triggerState", required=false)
    public TriggerStateEnum getTriggerState() {
        return this.triggerState;
    }

    public void setTriggerState(TriggerStateEnum triggerState) {
        this.triggerState = triggerState;
    }

    public TriggerSampleDto transportType(TransportTypeEnum transportType) {
        this.transportType = transportType;
        return this;
    }

    @Schema(name="transportType", required=false)
    public TransportTypeEnum getTransportType() {
        return this.transportType;
    }

    public void setTransportType(TransportTypeEnum transportType) {
        this.transportType = transportType;
    }

    public TriggerSampleDto triggerProperties(Map<String, Object> triggerProperties) {
        this.triggerProperties = triggerProperties;
        return this;
    }

    public TriggerSampleDto putTriggerPropertiesItem(String key, Object triggerPropertiesItem) {
        if (this.triggerProperties == null) {
            this.triggerProperties = new HashMap<String, Object>();
        }
        this.triggerProperties.put(key, triggerPropertiesItem);
        return this;
    }

    @Schema(name="triggerProperties", required=false)
    public Map<String, Object> getTriggerProperties() {
        return this.triggerProperties;
    }

    public void setTriggerProperties(Map<String, Object> triggerProperties) {
        this.triggerProperties = triggerProperties;
    }

    public TriggerSampleDto projectUuid(UUID projectUuid) {
        this.projectUuid = projectUuid;
        return this;
    }

    @Valid
    @Schema(name="projectUuid", required=false)
    public UUID getProjectUuid() {
        return this.projectUuid;
    }

    public void setProjectUuid(UUID projectUuid) {
        this.projectUuid = projectUuid;
    }

    public TriggerSampleDto projectId(BigInteger projectId) {
        this.projectId = projectId;
        return this;
    }

    @Valid
    @Schema(name="projectId", required=false)
    public BigInteger getProjectId() {
        return this.projectId;
    }

    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerSampleDto triggerSample = (TriggerSampleDto)o;
        return Objects.equals(this.triggerId, triggerSample.triggerId) && Objects.equals(this.triggerName, triggerSample.triggerName) && Objects.equals(this.triggerTypeName, triggerSample.triggerTypeName) && Objects.equals(this.transportName, triggerSample.transportName) && Objects.equals(this.serverName, triggerSample.serverName) && Objects.equals((Object)this.triggerState, (Object)triggerSample.triggerState) && Objects.equals((Object)this.transportType, (Object)triggerSample.transportType) && Objects.equals(this.triggerProperties, triggerSample.triggerProperties) && Objects.equals(this.projectUuid, triggerSample.projectUuid) && Objects.equals(this.projectId, triggerSample.projectId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.triggerId, this.triggerName, this.triggerTypeName, this.transportName, this.serverName, this.triggerState, this.transportType, this.triggerProperties, this.projectUuid, this.projectId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TriggerSampleDto {\n");
        sb.append("    triggerId: ").append(this.toIndentedString(this.triggerId)).append("\n");
        sb.append("    triggerName: ").append(this.toIndentedString(this.triggerName)).append("\n");
        sb.append("    triggerTypeName: ").append(this.toIndentedString(this.triggerTypeName)).append("\n");
        sb.append("    transportName: ").append(this.toIndentedString(this.transportName)).append("\n");
        sb.append("    serverName: ").append(this.toIndentedString(this.serverName)).append("\n");
        sb.append("    triggerState: ").append(this.toIndentedString((Object)this.triggerState)).append("\n");
        sb.append("    transportType: ").append(this.toIndentedString((Object)this.transportType)).append("\n");
        sb.append("    triggerProperties: ").append(this.toIndentedString(this.triggerProperties)).append("\n");
        sb.append("    projectUuid: ").append(this.toIndentedString(this.projectUuid)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TransportTypeEnum {
        CLI_INBOUND("CLI_INBOUND"),
        FILE_INBOUND("FILE_INBOUND"),
        HTTP_INBOUND("HTTP_INBOUND"),
        HTTP2_INBOUND("HTTP2_INBOUND"),
        JMS_INBOUND("JMS_INBOUND"),
        KAFKA_INBOUND("KAFKA_INBOUND"),
        REST_INBOUND("REST_INBOUND"),
        SNMP_INBOUND("SNMP_INBOUND"),
        SOAP_OVER_HTTP_INBOUND("SOAP_OVER_HTTP_INBOUND"),
        SMPP_INBOUND("SMPP_INBOUND");

        private String value;

        private TransportTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TransportTypeEnum fromValue(String value) {
            for (TransportTypeEnum b : TransportTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TriggerStateEnum {
        ACTIVE("Active"),
        INACTIVE("Inactive"),
        ERROR("Error"),
        STARTING("Starting"),
        SHUTTING_DOWN("Shutting down"),
        ACTIVE_NOT_ALL_("Active (Not all)"),
        ACTIVE_ERRORS_("Active (Errors)"),
        EMPTY("Empty");

        private String value;

        private TriggerStateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TriggerStateEnum fromValue(String value) {
            for (TriggerStateEnum b : TriggerStateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

