package org.qubership.atp.environments.openapi.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.openapi.dto.ParametersGettingVersionDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * SystemDtoDto
 */

@JsonTypeName("SystemDto")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-24T13:04:25.940Z[Etc/UTC]")
public class SystemDtoDto {

  @JsonProperty("connections")
  @Valid
  private List<Object> connections = null;

  @JsonProperty("created")
  private Long created;

  @JsonProperty("createdBy")
  private UUID createdBy;

  @JsonProperty("dateOfCheckVersion")
  private Long dateOfCheckVersion;

  @JsonProperty("dateOfLastCheck")
  private Long dateOfLastCheck;

  @JsonProperty("description")
  private String description;

  @JsonProperty("environmentIds")
  @Valid
  private List<UUID> environmentIds = null;

  @JsonProperty("externalId")
  private UUID externalId;

  @JsonProperty("externalName")
  private String externalName;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("linkToSystemId")
  private UUID linkToSystemId;

  @JsonProperty("mergeByName")
  private Boolean mergeByName;

  @JsonProperty("modified")
  private Long modified;

  @JsonProperty("modifiedBy")
  private UUID modifiedBy;

  @JsonProperty("name")
  private String name;

  @JsonProperty("parametersGettingVersion")
  private ParametersGettingVersionDto parametersGettingVersion;

  @JsonProperty("parentSystemId")
  private UUID parentSystemId;

  @JsonProperty("serverITF")
  private Object serverITF;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    FAIL("FAIL"),
    
    NOTHING("NOTHING"),
    
    PASS("PASS"),
    
    WARN("WARN");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  @JsonProperty("systemCategoryId")
  private UUID systemCategoryId;

  @JsonProperty("version")
  private String version;

  public SystemDtoDto connections(List<Object> connections) {
    this.connections = connections;
    return this;
  }

  public SystemDtoDto addConnectionsItem(Object connectionsItem) {
    if (this.connections == null) {
      this.connections = new ArrayList<>();
    }
    this.connections.add(connectionsItem);
    return this;
  }

  /**
   * Get connections
   * @return connections
  */
  
  @Schema(name = "connections", required = false)
  public List<Object> getConnections() {
    return connections;
  }

  public void setConnections(List<Object> connections) {
    this.connections = connections;
  }

  public SystemDtoDto created(Long created) {
    this.created = created;
    return this;
  }

  /**
   * Get created
   * @return created
  */
  
  @Schema(name = "created", required = false)
  public Long getCreated() {
    return created;
  }

  public void setCreated(Long created) {
    this.created = created;
  }

  public SystemDtoDto createdBy(UUID createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UUID getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UUID createdBy) {
    this.createdBy = createdBy;
  }

  public SystemDtoDto dateOfCheckVersion(Long dateOfCheckVersion) {
    this.dateOfCheckVersion = dateOfCheckVersion;
    return this;
  }

  /**
   * Get dateOfCheckVersion
   * @return dateOfCheckVersion
  */
  
  @Schema(name = "dateOfCheckVersion", required = false)
  public Long getDateOfCheckVersion() {
    return dateOfCheckVersion;
  }

  public void setDateOfCheckVersion(Long dateOfCheckVersion) {
    this.dateOfCheckVersion = dateOfCheckVersion;
  }

  public SystemDtoDto dateOfLastCheck(Long dateOfLastCheck) {
    this.dateOfLastCheck = dateOfLastCheck;
    return this;
  }

  /**
   * Get dateOfLastCheck
   * @return dateOfLastCheck
  */
  
  @Schema(name = "dateOfLastCheck", required = false)
  public Long getDateOfLastCheck() {
    return dateOfLastCheck;
  }

  public void setDateOfLastCheck(Long dateOfLastCheck) {
    this.dateOfLastCheck = dateOfLastCheck;
  }

  public SystemDtoDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public SystemDtoDto environmentIds(List<UUID> environmentIds) {
    this.environmentIds = environmentIds;
    return this;
  }

  public SystemDtoDto addEnvironmentIdsItem(UUID environmentIdsItem) {
    if (this.environmentIds == null) {
      this.environmentIds = new ArrayList<>();
    }
    this.environmentIds.add(environmentIdsItem);
    return this;
  }

  /**
   * Get environmentIds
   * @return environmentIds
  */
  @Valid 
  @Schema(name = "environmentIds", required = false)
  public List<UUID> getEnvironmentIds() {
    return environmentIds;
  }

  public void setEnvironmentIds(List<UUID> environmentIds) {
    this.environmentIds = environmentIds;
  }

  public SystemDtoDto externalId(UUID externalId) {
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
  */
  @Valid 
  @Schema(name = "externalId", required = false)
  public UUID getExternalId() {
    return externalId;
  }

  public void setExternalId(UUID externalId) {
    this.externalId = externalId;
  }

  public SystemDtoDto externalName(String externalName) {
    this.externalName = externalName;
    return this;
  }

  /**
   * Get externalName
   * @return externalName
  */
  
  @Schema(name = "externalName", required = false)
  public String getExternalName() {
    return externalName;
  }

  public void setExternalName(String externalName) {
    this.externalName = externalName;
  }

  public SystemDtoDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public SystemDtoDto linkToSystemId(UUID linkToSystemId) {
    this.linkToSystemId = linkToSystemId;
    return this;
  }

  /**
   * Get linkToSystemId
   * @return linkToSystemId
  */
  @Valid 
  @Schema(name = "linkToSystemId", required = false)
  public UUID getLinkToSystemId() {
    return linkToSystemId;
  }

  public void setLinkToSystemId(UUID linkToSystemId) {
    this.linkToSystemId = linkToSystemId;
  }

  public SystemDtoDto mergeByName(Boolean mergeByName) {
    this.mergeByName = mergeByName;
    return this;
  }

  /**
   * Get mergeByName
   * @return mergeByName
  */
  
  @Schema(name = "mergeByName", required = false)
  public Boolean getMergeByName() {
    return mergeByName;
  }

  public void setMergeByName(Boolean mergeByName) {
    this.mergeByName = mergeByName;
  }

  public SystemDtoDto modified(Long modified) {
    this.modified = modified;
    return this;
  }

  /**
   * Get modified
   * @return modified
  */
  
  @Schema(name = "modified", required = false)
  public Long getModified() {
    return modified;
  }

  public void setModified(Long modified) {
    this.modified = modified;
  }

  public SystemDtoDto modifiedBy(UUID modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  @Valid 
  @Schema(name = "modifiedBy", required = false)
  public UUID getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(UUID modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public SystemDtoDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public SystemDtoDto parametersGettingVersion(ParametersGettingVersionDto parametersGettingVersion) {
    this.parametersGettingVersion = parametersGettingVersion;
    return this;
  }

  /**
   * Get parametersGettingVersion
   * @return parametersGettingVersion
  */
  @Valid 
  @Schema(name = "parametersGettingVersion", required = false)
  public ParametersGettingVersionDto getParametersGettingVersion() {
    return parametersGettingVersion;
  }

  public void setParametersGettingVersion(ParametersGettingVersionDto parametersGettingVersion) {
    this.parametersGettingVersion = parametersGettingVersion;
  }

  public SystemDtoDto parentSystemId(UUID parentSystemId) {
    this.parentSystemId = parentSystemId;
    return this;
  }

  /**
   * Get parentSystemId
   * @return parentSystemId
  */
  @Valid 
  @Schema(name = "parentSystemId", required = false)
  public UUID getParentSystemId() {
    return parentSystemId;
  }

  public void setParentSystemId(UUID parentSystemId) {
    this.parentSystemId = parentSystemId;
  }

  public SystemDtoDto serverITF(Object serverITF) {
    this.serverITF = serverITF;
    return this;
  }

  /**
   * Get serverITF
   * @return serverITF
  */
  
  @Schema(name = "serverITF", required = false)
  public Object getServerITF() {
    return serverITF;
  }

  public void setServerITF(Object serverITF) {
    this.serverITF = serverITF;
  }

  public SystemDtoDto status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  
  @Schema(name = "status", required = false)
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public SystemDtoDto systemCategoryId(UUID systemCategoryId) {
    this.systemCategoryId = systemCategoryId;
    return this;
  }

  /**
   * Get systemCategoryId
   * @return systemCategoryId
  */
  @Valid 
  @Schema(name = "systemCategoryId", required = false)
  public UUID getSystemCategoryId() {
    return systemCategoryId;
  }

  public void setSystemCategoryId(UUID systemCategoryId) {
    this.systemCategoryId = systemCategoryId;
  }

  public SystemDtoDto version(String version) {
    this.version = version;
    return this;
  }

  /**
   * Get version
   * @return version
  */
  
  @Schema(name = "version", required = false)
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SystemDtoDto systemDto = (SystemDtoDto) o;
    return Objects.equals(this.connections, systemDto.connections) &&
        Objects.equals(this.created, systemDto.created) &&
        Objects.equals(this.createdBy, systemDto.createdBy) &&
        Objects.equals(this.dateOfCheckVersion, systemDto.dateOfCheckVersion) &&
        Objects.equals(this.dateOfLastCheck, systemDto.dateOfLastCheck) &&
        Objects.equals(this.description, systemDto.description) &&
        Objects.equals(this.environmentIds, systemDto.environmentIds) &&
        Objects.equals(this.externalId, systemDto.externalId) &&
        Objects.equals(this.externalName, systemDto.externalName) &&
        Objects.equals(this.id, systemDto.id) &&
        Objects.equals(this.linkToSystemId, systemDto.linkToSystemId) &&
        Objects.equals(this.mergeByName, systemDto.mergeByName) &&
        Objects.equals(this.modified, systemDto.modified) &&
        Objects.equals(this.modifiedBy, systemDto.modifiedBy) &&
        Objects.equals(this.name, systemDto.name) &&
        Objects.equals(this.parametersGettingVersion, systemDto.parametersGettingVersion) &&
        Objects.equals(this.parentSystemId, systemDto.parentSystemId) &&
        Objects.equals(this.serverITF, systemDto.serverITF) &&
        Objects.equals(this.status, systemDto.status) &&
        Objects.equals(this.systemCategoryId, systemDto.systemCategoryId) &&
        Objects.equals(this.version, systemDto.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(connections, created, createdBy, dateOfCheckVersion, dateOfLastCheck, description, environmentIds, externalId, externalName, id, linkToSystemId, mergeByName, modified, modifiedBy, name, parametersGettingVersion, parentSystemId, serverITF, status, systemCategoryId, version);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SystemDtoDto {\n");
    sb.append("    connections: ").append(toIndentedString(connections)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    dateOfCheckVersion: ").append(toIndentedString(dateOfCheckVersion)).append("\n");
    sb.append("    dateOfLastCheck: ").append(toIndentedString(dateOfLastCheck)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    environmentIds: ").append(toIndentedString(environmentIds)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    externalName: ").append(toIndentedString(externalName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    linkToSystemId: ").append(toIndentedString(linkToSystemId)).append("\n");
    sb.append("    mergeByName: ").append(toIndentedString(mergeByName)).append("\n");
    sb.append("    modified: ").append(toIndentedString(modified)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parametersGettingVersion: ").append(toIndentedString(parametersGettingVersion)).append("\n");
    sb.append("    parentSystemId: ").append(toIndentedString(parentSystemId)).append("\n");
    sb.append("    serverITF: ").append(toIndentedString(serverITF)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    systemCategoryId: ").append(toIndentedString(systemCategoryId)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

