/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.users.clients.api;

import org.qubership.atp.users.clients.dto.EntityDto;
import org.qubership.atp.users.clients.dto.GroupDto;
import java.util.Map;
import org.qubership.atp.users.clients.dto.OperationsDto;
import org.qubership.atp.users.clients.dto.ProjectDto;
import java.util.UUID;
import org.qubership.atp.users.clients.dto.UserInfoDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-24T13:04:25.267Z[Etc/UTC]")
@Validated
@Tag(name = "Projects", description = "the Projects API")
public interface ProjectsApi {

    /**
     * DELETE /api/v1/users/projects/{projectId}/users/{userId} : Delete user from project
     *
     * @param projectId Project ID (required)
     * @param userId User ID (required)
     * @return OK (status code 200)
     *         or  (status code 400)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     */
    @Operation(
        operationId = "deleteUserFromProject",
        summary = "Delete user from project",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "400", description = ""),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/api/v1/users/projects/{projectId}/users/{userId}",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectDto> deleteUserFromProject(
        @Parameter(name = "projectId", description = "Project ID", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "userId", description = "User ID", required = true) @PathVariable("userId") String userId
    );


    /**
     * GET /api/v1/users/projects/{projectId}/entities : Return all entities
     *
     * @param projectId Project ID for check access (required)
     * @return List of service entity (status code 200)
     *         or  (status code 400)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     */
    @Operation(
        operationId = "getAllEntities",
        summary = "Return all entities",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = "List of service entity", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EntityDto.class))
            }),
            @ApiResponse(responseCode = "400", description = ""),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/users/projects/{projectId}/entities",
        produces = { "application/json" }
    )
    ResponseEntity<List<EntityDto>> getAllEntities(
        @Parameter(name = "projectId", description = "Project ID for check access", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/v1/users/projects/{projectId}/users/groups : Get all groups
     *
     * @param projectId Project ID to check access (required)
     * @return Default user groups and permissions (status code 200)
     *         or  (status code 400)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     */
    @Operation(
        operationId = "getAllGroups",
        summary = "Get all groups",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Default user groups and permissions", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GroupDto.class))
            }),
            @ApiResponse(responseCode = "400", description = ""),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/users/projects/{projectId}/users/groups",
        produces = { "application/json" }
    )
    ResponseEntity<List<GroupDto>> getAllGroups(
        @Parameter(name = "projectId", description = "Project ID to check access", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/v1/users/projects : Get all projects in collection
     *
     * @return OK (status code 200)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     */
    @Operation(
        operationId = "getAllProjects",
        summary = "Get all projects in collection",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/users/projects",
        produces = { "application/json" }
    )
    ResponseEntity<List<ProjectDto>> getAllProjects(
        
    );


    /**
     * GET /api/v1/users/projects/{projectId}/group/{groupAlias}/permissions : Get custom permissions in specified project for specified group
     *
     * @param projectId Project ID (required)
     * @param groupAlias Group alias (required)
     * @return Permissions for specified group in project (status code 200)
     *         or  (status code 400)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     */
    @Operation(
        operationId = "getCustomPermissions",
        summary = "Get custom permissions in specified project for specified group",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Permissions for specified group in project", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = OperationsDto.class))
            }),
            @ApiResponse(responseCode = "400", description = ""),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/users/projects/{projectId}/group/{groupAlias}/permissions",
        produces = { "application/json" }
    )
    ResponseEntity<Map<String, OperationsDto>> getCustomPermissions(
        @Parameter(name = "projectId", description = "Project ID", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "groupAlias", description = "Group alias", required = true) @PathVariable("groupAlias") String groupAlias
    );


    /**
     * GET /api/v1/users/projects/{projectId}/user/permissions : Return permissions for current user on project
     *
     * @param projectId Project ID (required)
     * @return  (status code 200)
     *         or  (status code 400)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     */
    @Operation(
        operationId = "getPermissionsForCurrentUser",
        summary = "Return permissions for current user on project",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = ""),
            @ApiResponse(responseCode = "400", description = ""),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/users/projects/{projectId}/user/permissions"
    )
    ResponseEntity<Void> getPermissionsForCurrentUser(
        @Parameter(name = "projectId", description = "Project ID", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/v1/users/projects/{projectId} : Get project by id
     *
     * @param projectId Project ID (required)
     * @return OK (status code 200)
     *         or  (status code 400)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     */
    @Operation(
        operationId = "getProjectById",
        summary = "Get project by id",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "400", description = ""),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/users/projects/{projectId}",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectDto> getProjectById(
        @Parameter(name = "projectId", description = "Project ID", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/v1/users/projects/{projectId}/users : Get users on the project by id
     *
     * @param projectId Project ID (required)
     * @return OK (status code 200)
     *         or  (status code 400)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     * @deprecated
     */
    @Deprecated
    @Operation(
        operationId = "getProjectUsersByProjectId",
        summary = "Get users on the project by id",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "400", description = ""),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/users/projects/{projectId}/users",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectDto> getProjectUsersByProjectId(
        @Parameter(name = "projectId", description = "Project ID", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/v1/users/projects/{projectId}/group/{groupAlias}/users : Get users on the project by id
     *
     * @param projectId Project ID (required)
     * @param groupAlias Group Alias (required)
     * @return OK (status code 200)
     *         or  (status code 400)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     */
    @Operation(
        operationId = "getProjectUsersByProjectIdAndGroupAlias",
        summary = "Get users on the project by id",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "400", description = ""),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/users/projects/{projectId}/group/{groupAlias}/users",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectDto> getProjectUsersByProjectIdAndGroupAlias(
        @Parameter(name = "projectId", description = "Project ID", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "groupAlias", description = "Group Alias", required = true) @PathVariable("groupAlias") String groupAlias
    );


    /**
     * GET /api/v1/users/projects/{projectId}/users/enriched : Get unique users of the project by project ID
     *
     * @param projectId Project ID (required)
     * @return Information about unique users of the project (status code 200)
     *         or  (status code 400)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     * @deprecated
     */
    @Deprecated
    @Operation(
        operationId = "getProjectsUsersEnrichedByUuid",
        summary = "Get unique users of the project by project ID",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Information about unique users of the project", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UserInfoDto.class))
            }),
            @ApiResponse(responseCode = "400", description = ""),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/users/projects/{projectId}/users/enriched",
        produces = { "application/json" }
    )
    ResponseEntity<List<UserInfoDto>> getProjectsUsersEnrichedByUuid(
        @Parameter(name = "projectId", description = "Project ID", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/v1/users/projects/{projectId}/groups/{groupAlias}/users/enriched : Get unique users of the project by project ID and group alias
     *
     * @param projectId Project ID (required)
     * @param groupAlias Group alias (required)
     * @return Information about unique users of the project (status code 200)
     *         or  (status code 400)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     */
    @Operation(
        operationId = "getProjectsUsersEnrichedByUuidAndGroupAlias",
        summary = "Get unique users of the project by project ID and group alias",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Information about unique users of the project", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UserInfoDto.class))
            }),
            @ApiResponse(responseCode = "400", description = ""),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/users/projects/{projectId}/groups/{groupAlias}/users/enriched",
        produces = { "application/json" }
    )
    ResponseEntity<List<UserInfoDto>> getProjectsUsersEnrichedByUuidAndGroupAlias(
        @Parameter(name = "projectId", description = "Project ID", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "groupAlias", description = "Group alias", required = true) @PathVariable("groupAlias") String groupAlias
    );


    /**
     * PATCH /api/v1/users/projects/{projectId}/group/{groupAlias}/permissions : Update permissions in specified project for specified group
     *
     * @param projectId Project ID (required)
     * @param groupAlias Group alias (required)
     * @param requestBody Entities with custom permissions (required)
     * @return  (status code 200)
     *         or  (status code 400)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     */
    @Operation(
        operationId = "updatePermissionsByProjectIdAndGroupAlias",
        summary = "Update permissions in specified project for specified group",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = ""),
            @ApiResponse(responseCode = "400", description = ""),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.PATCH,
        value = "/api/v1/users/projects/{projectId}/group/{groupAlias}/permissions",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> updatePermissionsByProjectIdAndGroupAlias(
        @Parameter(name = "projectId", description = "Project ID", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "groupAlias", description = "Group alias", required = true) @PathVariable("groupAlias") String groupAlias,
        @Parameter(name = "request_body", description = "Entities with custom permissions", required = true) @Valid @RequestBody Map<String, OperationsDto> requestBody
    );


    /**
     * PUT /api/v1/users/projects/update/users : Update projects user
     *
     * @param type type of user (required)
     * @param projectDto project entity (required)
     * @return OK (status code 200)
     *         or  (status code 400)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     * @deprecated
     */
    @Deprecated
    @Operation(
        operationId = "updateProjectUsers",
        summary = "Update projects user",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "400", description = ""),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/v1/users/projects/update/users",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<ProjectDto> updateProjectUsers(
        @NotNull @Parameter(name = "type", description = "type of user", required = true) @Valid @RequestParam(value = "type", required = true) String type,
        @Parameter(name = "ProjectDto", description = "project entity", required = true) @Valid @RequestBody ProjectDto projectDto
    );


    /**
     * PUT /api/v1/users/projects/{projectId}/groups/{groupAlias}/users : Update projects user
     *
     * @param projectId Project Id to check access (required)
     * @param groupAlias Users group (required)
     * @param projectDto Project entity (required)
     * @return OK (status code 200)
     *         or  (status code 400)
     *         or  (status code 401)
     *         or  (status code 403)
     *         or  (status code 500)
     */
    @Operation(
        operationId = "updateProjectUsersInGroup",
        summary = "Update projects user",
        tags = { "Projects" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "400", description = ""),
            @ApiResponse(responseCode = "401", description = ""),
            @ApiResponse(responseCode = "403", description = ""),
            @ApiResponse(responseCode = "500", description = "")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/v1/users/projects/{projectId}/groups/{groupAlias}/users",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<ProjectDto> updateProjectUsersInGroup(
        @Parameter(name = "projectId", description = "Project Id to check access", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "groupAlias", description = "Users group", required = true) @PathVariable("groupAlias") String groupAlias,
        @Parameter(name = "ProjectDto", description = "Project entity", required = true) @Valid @RequestBody ProjectDto projectDto
    );

}
