package org.qubership.atp.users.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.users.clients.dto.OperationsDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * GroupDto
 */

@JsonTypeName("Group")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-24T13:04:25.267Z[Etc/UTC]")
public class GroupDto {

  @JsonProperty("alias")
  private String alias;

  @JsonProperty("name")
  private String name;

  @JsonProperty("permissions")
  @Valid
  private Map<String, OperationsDto> permissions = null;

  @JsonProperty("uuid")
  private UUID uuid;

  public GroupDto alias(String alias) {
    this.alias = alias;
    return this;
  }

  /**
   * Get alias
   * @return alias
  */
  
  @Schema(name = "alias", required = false)
  public String getAlias() {
    return alias;
  }

  public void setAlias(String alias) {
    this.alias = alias;
  }

  public GroupDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public GroupDto permissions(Map<String, OperationsDto> permissions) {
    this.permissions = permissions;
    return this;
  }

  public GroupDto putPermissionsItem(String key, OperationsDto permissionsItem) {
    if (this.permissions == null) {
      this.permissions = new HashMap<>();
    }
    this.permissions.put(key, permissionsItem);
    return this;
  }

  /**
   * Get permissions
   * @return permissions
  */
  @Valid 
  @Schema(name = "permissions", required = false)
  public Map<String, OperationsDto> getPermissions() {
    return permissions;
  }

  public void setPermissions(Map<String, OperationsDto> permissions) {
    this.permissions = permissions;
  }

  public GroupDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GroupDto group = (GroupDto) o;
    return Objects.equals(this.alias, group.alias) &&
        Objects.equals(this.name, group.name) &&
        Objects.equals(this.permissions, group.permissions) &&
        Objects.equals(this.uuid, group.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(alias, name, permissions, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GroupDto {\n");
    sb.append("    alias: ").append(toIndentedString(alias)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

