/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.communication.EventTriggerBriefInfo;
import org.qubership.automation.itf.core.model.communication.StubUser;
import org.qubership.automation.itf.core.model.communication.message.EventTriggerBulkActivationRequest;
import org.qubership.automation.itf.core.model.communication.message.EventTriggerSingleActivationRequest;
import org.qubership.automation.itf.core.model.communication.message.EventTriggerStateResponse;
import org.qubership.automation.itf.core.model.communication.message.EventTriggerSyncActivationRequest;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.OperationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.exception.TriggerException;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.event.trigger.EventTriggerSwitcherFactory;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.qubership.automation.itf.ui.util.EventTriggerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class EventTriggerActivationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventTriggerActivationService.class);
    private final ExecutorToMessageBrokerSender executorToMessageBrokerSender;

    @Autowired
    public EventTriggerActivationService(ExecutorToMessageBrokerSender executorToMessageBrokerSender) {
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
    }

    public void switchTriggerState(EventTriggerSingleActivationRequest eventTriggerSingleActivationRequest, String tenantId, Boolean turnOn, boolean forceActivate) {
        this.executorToMessageBrokerSender.sendMessageExecutorConfiguratorEventTriggersTopic(this.doAction(eventTriggerSingleActivationRequest.getUser(), Collections.singletonList(eventTriggerSingleActivationRequest.getTrigger()), eventTriggerSingleActivationRequest.getSessionId(), false, turnOn, false, forceActivate), tenantId);
    }

    public EventTriggerStateResponse switchTriggerState(List<BigInteger> triggerIds, String triggerType, String sessionId) {
        EventTriggerStateResponse response = new EventTriggerStateResponse(new HashMap(), "", new StubUser(), sessionId);
        StringBuilder sb = new StringBuilder();
        for (BigInteger triggerId : triggerIds) {
            MutablePair<TriggerState, String> result = this.switchTrigger(triggerId, triggerType, false, null, false, false);
            response.getStates().put(triggerId, result.getKey());
            if (((String)result.getValue()).isEmpty()) continue;
            sb.append("For trigger id = ").append(triggerId).append(" error message: ").append((String)result.getValue()).append('\n');
        }
        response.setErrorMessage(sb.toString());
        return response;
    }

    public void switchTriggersState(EventTriggerBulkActivationRequest eventTriggerBulkActivationRequest, String tenantId) {
        this.executorToMessageBrokerSender.sendMessageExecutorConfiguratorEventTriggersTopic(this.doAction(eventTriggerBulkActivationRequest.getUser(), eventTriggerBulkActivationRequest.getEventTriggers(), eventTriggerBulkActivationRequest.getSessionId(), false, eventTriggerBulkActivationRequest.isTurnOn(), false, false), tenantId);
    }

    public void syncTriggersState(EventTriggerSyncActivationRequest eventTriggerSyncActivationRequest, String tenantId, boolean deleteAfterDeactivation, boolean forceDeactivate) {
        EventTriggerStateResponse deactivationResult = this.doAction(eventTriggerSyncActivationRequest.getUser(), eventTriggerSyncActivationRequest.getTriggersToDeactivate(), eventTriggerSyncActivationRequest.getSessionId(), false, null, deleteAfterDeactivation, forceDeactivate);
        EventTriggerStateResponse reactivationResult = this.doAction(eventTriggerSyncActivationRequest.getUser(), eventTriggerSyncActivationRequest.getTriggersToReactivate(), eventTriggerSyncActivationRequest.getSessionId(), true, null, deleteAfterDeactivation, false);
        deactivationResult.getStates().putAll(reactivationResult.getStates());
        deactivationResult.setErrorMessage(deactivationResult.getErrorMessage() + reactivationResult.getErrorMessage());
        this.executorToMessageBrokerSender.sendMessageExecutorConfiguratorEventTriggersTopic(deactivationResult, tenantId);
    }

    private EventTriggerStateResponse doAction(StubUser user, List<EventTriggerBriefInfo> triggers, String sessionID, boolean reset, Boolean turnOn, boolean deleteAfterDeactivation, boolean force) {
        EventTriggerStateResponse response = new EventTriggerStateResponse(new HashMap(), "", user, sessionID);
        StringBuilder sb = new StringBuilder();
        for (EventTriggerBriefInfo item : triggers) {
            MutablePair<TriggerState, String> result = this.switchTrigger(item.getId(), item.getType(), reset, turnOn, deleteAfterDeactivation, force);
            response.getStates().put(item.getId(), result.getKey());
            if (((String)result.getValue()).isEmpty()) continue;
            sb.append("For trigger id = ").append(item.getId()).append(" error message: ").append((String)result.getValue()).append('\n');
        }
        response.setErrorMessage(sb.toString());
        return response;
    }

    private MutablePair<TriggerState, String> switchTrigger(BigInteger triggerId, String triggerType, boolean reset, Boolean turnOn, boolean deleteAfterDeactivation, boolean force) {
        TriggerState state;
        String message = "";
        EventTrigger trigger = EventTriggerHelper.getByIdAndType(triggerId, triggerType);
        TriggerException exception = null;
        boolean changed = false;
        if (trigger != null) {
            String triggerIdentity;
            String string = triggerIdentity = StringUtils.isBlank((CharSequence)trigger.getName()) ? "[id=" + triggerId + "]" : trigger.getName();
            if (reset) {
                LOGGER.info("Reactivating trigger {}...", (Object)triggerIdentity);
                try {
                    EventTriggerSwitcherFactory.getSwitcherByEventTriggerType((String)trigger.getType()).apply(trigger);
                    changed = true;
                }
                catch (TriggerException e) {
                    LOGGER.warn("Error while reactivating trigger {}", (Object)triggerIdentity, (Object)e);
                    exception = e;
                }
                if (changed) {
                    LOGGER.info("Trigger {} reactivated", (Object)triggerIdentity);
                }
            } else {
                boolean deactivationRequired;
                boolean bl = deactivationRequired = !(!trigger.getState().isOn() && !force || turnOn != null && turnOn != false);
                if (deactivationRequired || deleteAfterDeactivation) {
                    if (deactivationRequired) {
                        LOGGER.info("Deactivating trigger {}...", (Object)triggerIdentity);
                        try {
                            EventTriggerSwitcherFactory.getSwitcherByEventTriggerType((String)trigger.getType()).deactivate(trigger);
                            changed = true;
                        }
                        catch (TriggerException e) {
                            LOGGER.warn("Error while deactivating trigger {}", (Object)triggerIdentity, (Object)e);
                            exception = e;
                        }
                        if (changed) {
                            LOGGER.info("Trigger {} deactivated", (Object)triggerIdentity);
                        }
                    }
                    if (deleteAfterDeactivation && (changed || !deactivationRequired)) {
                        trigger.remove();
                    }
                } else if (!(trigger.getState().isOn() && !force || turnOn != null && !turnOn.booleanValue())) {
                    Storable alreadyActiveSituation;
                    Situation situation;
                    if (trigger.getParent() instanceof Situation && trigger instanceof OperationEventTrigger && this.conditionsParametersAreEmpty((EventTrigger)(situation = (Situation)trigger.getParent()).getOperationEventTriggers().iterator().next()) && (alreadyActiveSituation = this.findAnotherActiveSituation(situation)) != null) {
                        message = String.format("Situation [%s] can't be activated because there is another active [%s] situation without conditions.", situation.getName(), alreadyActiveSituation.getName());
                        LOGGER.warn(message);
                        if (force && trigger.getState().isOn()) {
                            trigger.setState(TriggerState.ERROR);
                            trigger.setException((Throwable)new TriggerException(message));
                            CoreObjectManager.getInstance().getManager(OperationEventTrigger.class).store((Storable)trigger);
                        }
                        return new MutablePair((Object)trigger.getState(), (Object)message);
                    }
                    LOGGER.info("Activating trigger {}...", (Object)triggerIdentity);
                    try {
                        EventTriggerSwitcherFactory.getSwitcherByEventTriggerType((String)trigger.getType()).activate(trigger);
                        changed = true;
                    }
                    catch (TriggerException e) {
                        LOGGER.warn("Error while activating trigger {}", (Object)triggerIdentity, (Object)e);
                        exception = e;
                    }
                    if (changed) {
                        LOGGER.info("Trigger {} activated", (Object)triggerIdentity);
                    }
                }
            }
            if (trigger instanceof SituationEventTrigger) {
                if (!deleteAfterDeactivation) {
                    CoreObjectManager.getInstance().getManager(SituationEventTrigger.class).store((Storable)trigger);
                }
            } else {
                CoreObjectManager.getInstance().getManager(OperationEventTrigger.class).store((Storable)trigger);
            }
            state = trigger.getState();
            if (!changed && exception != null) {
                message = exception.getCause() != null ? exception.getCause().getLocalizedMessage() : ExceptionUtils.getStackTrace((Throwable)exception);
            }
        } else {
            message = "Event trigger does not exist.";
            state = TriggerState.EMPTY;
            LOGGER.warn(message);
        }
        return new MutablePair((Object)state, (Object)message);
    }

    private boolean conditionsParametersAreEmpty(EventTrigger trigger) {
        return trigger.getConditionParameters() == null || trigger.getConditionParameters().isEmpty();
    }

    private Storable findAnotherActiveSituation(Situation activatedSituation) {
        Operation operation = (Operation)CoreObjectManager.getInstance().getManager(Operation.class).getById(activatedSituation.getParent().getID());
        if (operation != null) {
            for (Situation situation : operation.getSituations()) {
                if (situation.getID().equals(activatedSituation.getID()) || !this.activeTriggerWithoutConditions(situation)) continue;
                return situation;
            }
            return null;
        }
        return null;
    }

    private boolean activeTriggerWithoutConditions(Situation situation) {
        EventTrigger trigger = (EventTrigger)situation.getOperationEventTriggers().iterator().next();
        return TriggerState.ACTIVE.equals((Object)trigger.getState()) && this.conditionsParametersAreEmpty(trigger);
    }
}

