/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.core.execution.ExecutorServiceProviderFactory;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvironmentManager;
import org.qubership.automation.itf.core.instance.chain.IncomingHelper;
import org.qubership.automation.itf.core.message.parser.Parser;
import org.qubership.automation.itf.core.model.communication.message.CommonTriggerExecutionMessage;
import org.qubership.automation.itf.core.model.communication.message.DiameterTriggerExecutionMessage;
import org.qubership.automation.itf.core.model.communication.message.TriggerExecutionMessage;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.interceptor.TransportInterceptor;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.TriggerConfiguration;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.server.ServerHB;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.IDiameterEventProducer;
import org.qubership.automation.itf.core.util.constants.StartedFrom;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.converter.PropertiesConverter;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.core.util.exception.DetectEnvironmentException;
import org.qubership.automation.itf.core.util.exception.IncomingValidationException;
import org.qubership.automation.itf.core.util.exception.SituationDefinitionException;
import org.qubership.automation.itf.core.util.helper.Comparators;
import org.qubership.automation.itf.core.util.loader.InterceptorClassLoader;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.manager.MonitorManager;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.core.util.transport.service.report.Report;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.config.jms.ExecutorIntegrationConfig;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.qubership.automation.itf.executor.service.TCContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;

@Service
public class TriggerExecutor
implements IDiameterEventProducer {
    private static final Logger log = LoggerFactory.getLogger(TriggerExecutor.class);
    private static final String TECH_SITUATION_STEP_FORMAT = "Step was passed with Technical Situation because the suitable situation for incoming message was NOT found on system: '%s', operation: '%s'";
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss").withZone(ZoneId.systemDefault());
    private ExecutorToMessageBrokerSender executorToMessageBrokerSender;
    private IncomingHelper incomingHelper;

    @Autowired
    public void setExecutorStubsMessageSender(ExecutorToMessageBrokerSender executorToMessageBrokerSender, IncomingHelper incomingHelper) {
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
        this.incomingHelper = incomingHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceEvent(CommonTriggerExecutionMessage triggerExecutionMessage, OffsetDateTime started) {
        if (StringUtils.isEmpty((CharSequence)triggerExecutionMessage.getBrokerMessageSelectorValue())) {
            log.error("SessionId: {}, Message is rejected, due to Broker Message Selector Value is EMPTY!", (Object)triggerExecutionMessage.getSessionId());
            return;
        }
        String oldThreadName = Thread.currentThread().getName();
        try {
            String threadName = oldThreadName + '/' + triggerExecutionMessage.getSessionId();
            Thread.currentThread().setName(threadName);
            TxExecutor.executeUnchecked(() -> {
                ObjectManager manager = CoreObjectManager.managerFor(TriggerConfiguration.class);
                TriggerConfiguration triggerConfiguration = (TriggerConfiguration)manager.getById(triggerExecutionMessage.getTriggerConfigurationDescriptor().getId());
                TransportConfiguration transport = triggerConfiguration.getParent().getReferencedConfiguration();
                this.produceEvent(triggerConfiguration, transport, triggerExecutionMessage.getTriggerConfigurationDescriptor(), triggerExecutionMessage.getMessage(), triggerExecutionMessage.getSessionId(), threadName, triggerExecutionMessage.getBrokerMessageSelectorValue(), started);
                return null;
            }, (TransactionDefinition)ExecutorIntegrationConfig.STUB_TRANSACTION_DEFINITION);
        }
        catch (Throwable t) {
            log.error("SessionId {}: Error while processing incoming message", (Object)triggerExecutionMessage.getSessionId(), (Object)t);
            String projectUuid = triggerExecutionMessage.getTriggerConfigurationDescriptor().getProjectUuid().toString();
            this.executorToMessageBrokerSender.sendMessageToExecutorStubsOutgoingResponseQueue(new TriggerExecutionMessage(new Message(String.format("SessionId %s: Error while processing incoming message: %s", triggerExecutionMessage.getSessionId(), t)), triggerExecutionMessage.getSessionId(), triggerExecutionMessage.getBrokerMessageSelectorValue()), projectUuid);
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produceEvent(TriggerConfiguration triggerConfiguration, TransportConfiguration transport, StorableDescriptor triggerDescriptor, Message message, String sessionId, String threadName, String brokerMessageSelectorValue, OffsetDateTime started) {
        UUID projectUuid = triggerDescriptor.getProjectUuid();
        BigInteger projectId = triggerDescriptor.getProjectId();
        InstanceContext instanceContext = this.initInstanceContext(transport, message, triggerDescriptor.getName(), projectId, projectUuid);
        try {
            boolean isConfiguredSituation = this.doCallChain(instanceContext, message, triggerConfiguration, transport, sessionId, brokerMessageSelectorValue, projectId, projectUuid, started);
            if (!isConfiguredSituation) {
                throw new SituationDefinitionException("No suitable configured situation is found! Please check configuration and/or incoming message.");
            }
        }
        catch (Exception ex) {
            String triggerTypeName = triggerConfiguration.getTypeName();
            String errorMessage = this.createErrorMessage(ex, triggerDescriptor, message, sessionId, triggerTypeName);
            this.sendFailedMessageToBroker(sessionId, brokerMessageSelectorValue, errorMessage, projectUuid);
            Exception exception = this.prepareException(errorMessage, ex);
            this.doCallChainCrash(exception, instanceContext, this.calculateContextName(message, triggerTypeName), !(ex instanceof IncomingValidationException) && !(ex instanceof SituationDefinitionException), projectId, projectUuid);
        }
        finally {
            Thread.currentThread().setName(threadName);
        }
    }

    private void sendFailedMessageToBroker(String sessionId, String brokerMessageSelectorValue, String description, UUID projectUuid) {
        Message response = new Message();
        response.setFailedMessage(description);
        this.executorToMessageBrokerSender.sendMessageToExecutorStubsOutgoingResponseQueue(new TriggerExecutionMessage(response, sessionId, brokerMessageSelectorValue), projectUuid.toString());
    }

    public void produceEventDiameter(DiameterTriggerExecutionMessage executionMessage) {
        ExecutorServiceProviderFactory.get().requestForInboundProcessing().execute(() -> {
            String threadName = Thread.currentThread().getName();
            Object tcContextId = executionMessage.getTcContextId();
            Object transportId = executionMessage.getTransportId();
            Message message = executionMessage.getMessage();
            String sessionId = executionMessage.getSessionId();
            TcContext tcContext = CacheServices.getTcContextCacheService().getById(tcContextId);
            if (tcContext == null) {
                log.error("TcContext isn't found by id {}. Diameter message processing is impossible (TransportId: {})  SessionId: {}", new Object[]{tcContextId, transportId, sessionId});
                return;
            }
            BigInteger projectId = tcContext.getProjectId();
            UUID projectUuid = tcContext.getProjectUuid();
            TxExecutor.executeUnchecked(() -> {
                TransportConfiguration transport = (TransportConfiguration)CoreObjectManager.managerFor(TransportConfiguration.class).getById(transportId);
                if (transport == null) {
                    throw new RuntimeException("Transport isn't found by id " + transportId + "Diameter message processing is impossible. tcContextId: " + tcContextId + " sessionId: " + sessionId);
                }
                InstanceContext instanceContext = this.initInstanceContext(transport, message, transport.getName(), projectId, projectUuid);
                try {
                    boolean isConfiguredSituation = this.doCallChain(tcContext, instanceContext, message, sessionId, transport);
                    if (!isConfiguredSituation) {
                        throw new SituationDefinitionException("No suitable configured situation is found! Please check configuration and/or incoming message.");
                    }
                    CacheServices.getPendingDataContextsCacheService().addContext(tcContext, sessionId);
                }
                catch (IncomingValidationException | SituationDefinitionException e) {
                    this.doCallChainCrash((Exception)e, instanceContext, "", false, projectId, projectUuid);
                }
                catch (Exception e) {
                    this.doCallChainCrash(e, instanceContext, "", true, projectId, projectUuid);
                }
                finally {
                    Thread.currentThread().setName(threadName);
                }
                return null;
            }, (TransactionDefinition)TxExecutor.readOnlyTransaction());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCallChain(TcContext tcContext, InstanceContext instanceContext, Message message, String sessionId, TransportConfiguration transport) throws Exception {
        Object locObject;
        instanceContext.setTransport(transport);
        System system = transport.getParent();
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (String)tcContext.getProjectUuid().toString());
        MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)tcContext.getID().toString());
        log.info("Parsing message, system is {}...", (Object)system.getName());
        Operation operation = this.incomingHelper.processIncomingMessage(message, instanceContext, transport, tcContext.getProjectId(), tcContext.getProjectUuid());
        transport = operation.getTransport();
        instanceContext.setTransport(transport);
        Thread.currentThread().setName(Thread.currentThread().getName() + "/" + tcContext.getID());
        Object object = locObject = MonitorManager.getInstance().get("$tcid=" + tcContext.getID());
        synchronized (object) {
            return this.prepareAndExecuteSituation(instanceContext, tcContext, instanceContext.getSP(), message, operation, system, sessionId, null, transport.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCallChain(InstanceContext instanceContext, Message message, TriggerConfiguration triggerConfiguration, TransportConfiguration transport, String sessionId, String brokerMessageSelectorValue, BigInteger projectId, UUID projectUuid, OffsetDateTime started) throws Exception {
        Object locObject;
        if (transport == null) {
            throw new IllegalStateException(String.format("No matching transport found for %s", triggerConfiguration.getName()));
        }
        instanceContext.setTransport(transport);
        ServerHB server = triggerConfiguration.getParent().getParent();
        System system = transport.getParent();
        instanceContext.setConnectionProperties(PropertiesConverter.convert((String)triggerConfiguration.getParent().getTypeName(), (Map[])new Map[]{triggerConfiguration.getParent().getReferencedConfiguration(), triggerConfiguration.getParent(), triggerConfiguration}));
        log.info("Parsing message, system is {}...", (Object)system.getName());
        Operation operation = this.incomingHelper.processIncomingMessage(message, instanceContext, transport, projectId, projectUuid);
        log.info("Detecting context, operation is {}...", (Object)operation.getName());
        String contextKey = this.incomingHelper.getContextKey(instanceContext, system, operation, false);
        TcContext tcContext = this.incomingHelper.findOrCreateTcContextByKeys(contextKey, transport.get((Object)"isStub"), projectId, projectUuid);
        this.fillTcContextParams(instanceContext, message, triggerConfiguration, started, tcContext);
        MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)tcContext.getID().toString());
        Thread.currentThread().setName(Thread.currentThread().getName() + "/" + tcContext.getID());
        Object object = locObject = MonitorManager.getInstance().get("$tcid=" + tcContext.getID());
        synchronized (object) {
            this.prepareEnv(tcContext, system, (Server)server);
            return this.prepareAndExecuteSituation(instanceContext, tcContext, instanceContext.getSP(), message, operation, system, sessionId, brokerMessageSelectorValue, server.getName());
        }
    }

    private String computeEndpointTagValue(Object uriParams, String typeName, Object triggerId) {
        return uriParams == null ? typeName + " / trigger " + triggerId : uriParams.toString();
    }

    private Exception prepareException(String errorDescription, Exception e) {
        log.error(errorDescription);
        return this.processException(e, errorDescription);
    }

    private Exception processException(Exception exception, String description) {
        Class<IncomingValidationException> exceptionClass = exception.getClass();
        return exceptionClass.isAssignableFrom(IncomingValidationException.class) ? exception : new Exception(description);
    }

    private String calculateContextName(Message message, String typename) {
        if (typename.endsWith(".RESTInboundTransport") || typename.endsWith(".SOAPOverHTTPInboundTransport")) {
            Object obj = message.getHeaders().get("x-forwarded-for");
            String from = null;
            String to = null;
            if (obj != null) {
                from = obj.toString();
            }
            if (StringUtils.isBlank(from) && (obj = message.getHeaders().get("remoteAddr")) != null) {
                from = obj.toString();
            }
            if ((obj = message.getHeaders().get("CamelHttpUri")) != null) {
                to = obj.toString();
            }
            return "From: " + from + " To: " + to;
        }
        return null;
    }

    private String createErrorMessage(Exception ex, StorableDescriptor triggerConfigurationDescriptor, Message message, String sessionId, String typename) {
        boolean isRest = typename.endsWith(".RESTInboundTransport");
        boolean isSoap = !isRest && typename.endsWith(".SOAPOverHTTPInboundTransport");
        StringBuilder builder = new StringBuilder(isSoap ? "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n<soap:Body>\n<soap:Fault>\n<faultcode>soap:Server</faultcode>\n<faultstring>" : "");
        builder.append("Exception while processing incoming message received by the trigger: ");
        builder.append(triggerConfigurationDescriptor.getName()).append("\nSession id: ").append(sessionId);
        if (isRest || isSoap) {
            builder.append("\nSome important message headers: ");
            this.appendHeader(builder, message, "CamelHttpUrl");
            this.appendHeader(builder, message, "CamelHttpQuery");
            this.appendHeader(builder, message, "remoteHost");
            this.appendHeader(builder, message, "remotePort");
            this.appendHeader(builder, message, "remoteAddr");
            this.appendHeader(builder, message, "x-forwarded-for");
            this.appendHeader(builder, message, "user-agent");
        }
        builder.append("\nException: ").append(ex.getMessage());
        if (ex.getCause() != null) {
            builder.append("\nCaused by: ").append(isSoap ? StringEscapeUtils.escapeXml10((String)ex.getCause().toString()) : ex.getCause());
        }
        if (isSoap) {
            builder.append("\n</faultstring>\n</soap:Fault>\n</soap:Body>\n</soap:Envelope>");
        }
        return builder.toString();
    }

    private void appendHeader(StringBuilder builder, Message message, String headerName) {
        Object headerValue = message.getHeaders().get(headerName);
        if (headerValue != null) {
            builder.append("\n").append(headerName).append(": ").append(headerValue);
        }
    }

    private InstanceContext initInstanceContext(TransportConfiguration transport, Message message, String triggerName, BigInteger projectId, UUID projectUuid) {
        log.info("Event received for trigger {}", (Object)triggerName);
        InstanceContext context = new InstanceContext();
        SpContext spContext = new SpContext();
        context.setSP(spContext);
        try {
            this.doIntercept(transport, message);
            context.setProjectId(projectId);
            context.setProjectUuid(projectUuid);
            this.prepareMessage(message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        spContext.setIncomingMessage(message);
        spContext.put((Object)"incomingHeaders", (Object)message.getHeaders());
        spContext.put((Object)"incomingConnectionProperties", (Object)message.getConnectionProperties());
        return context;
    }

    private Map<String, Object> getEnvironmentInfo(System system, Server server) throws Exception {
        List environmentInfo = ((EnvironmentManager)CoreObjectManager.getInstance().getSpecialManager(Environment.class, EnvironmentManager.class)).getByServerAndSystemIdPair((BigInteger)system.getID(), (BigInteger)server.getID());
        if (environmentInfo.isEmpty()) {
            throw new DetectEnvironmentException(String.format("No environment with inbound system %s and server %s found", system, server));
        }
        if (environmentInfo.size() > 1) {
            log.warn("More than one environment with inbound system {} and server {} found", (Object)system, (Object)server);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ((Object[])environmentInfo.get(0))[0]);
        map.put("name", ((Object[])environmentInfo.get(0))[1]);
        return map;
    }

    private void prepareEnv(TcContext tcContext, System system, Server server) throws Exception {
        if (tcContext.getEnvironmentId() == null) {
            Map<String, Object> environmentInfo = this.getEnvironmentInfo(system, server);
            tcContext.setEnvironmentId((BigInteger)environmentInfo.get("id"));
            tcContext.setEnvironmentName(String.valueOf(environmentInfo.get("name")));
        }
    }

    private void doCallChainCrash(Exception e, InstanceContext instanceContext, String contextName, boolean executeUnexpectedSituation, BigInteger projectId, UUID projectUuid) {
        log.error("Error while processing incoming message", (Throwable)e);
        if (instanceContext.tc() == null) {
            instanceContext.setTC(CacheServices.getTcBindingCacheService().findByKey(String.format("Unexpected instanceContext at %s", LocalDateTime.now().format(dateTimeFormatter)), projectId, projectUuid));
        }
        TcContext tcContext = instanceContext.tc();
        if (!StringUtils.isBlank((CharSequence)contextName)) {
            tcContext.setName(contextName);
        }
        tcContext.setPartNum(TCContextService.getCurrentPartitionNumberByProject((UUID)tcContext.getProjectUuid()));
        if (executeUnexpectedSituation) {
            if (!tcContext.getStatus().equals((Object)Status.FAILED)) {
                this.incomingHelper.executeUnexpectedSituation(instanceContext, e);
            }
        } else {
            ExecutionServices.getTCContextService().fail(tcContext);
        }
    }

    private void prepareMessage(Message message) throws IOException {
        if (message.getFile() != null) {
            message.setText(FileUtils.readFileToString((File)message.getFile()));
        }
    }

    private boolean prepareAndExecuteSituation(InstanceContext context, TcContext tcContext, SpContext spContext, Message message, Operation operation, System system, String sessionId, String brokerMessageSelectorValue, String serverName) throws Exception {
        ExecutionServices.getTCContextService().setMessageParameters(tcContext, (Collection)spContext.getMessageParameters());
        context.setTC(tcContext);
        context.setSessionId((Object)sessionId);
        if (brokerMessageSelectorValue != null) {
            context.setMessageBrokerSelectorValue((Object)brokerMessageSelectorValue);
        }
        log.info("Detecting situation, operation is {}...", (Object)operation.getName());
        this.incomingHelper.tryToGetRequestMethod(message, context);
        this.addParamsToSpContext(context, tcContext, message, serverName);
        Situation situation = this.incomingHelper.detectSituationFromOperation(operation, (JsonContext)context);
        boolean isDefaultInboundSituation = situation == operation.getDefaultInboundSituation();
        context.nilsp();
        if (!situation.getParsingRules().isEmpty()) {
            Parser parser = new Parser();
            log.debug("situationMessageParameters parsing - is started");
            Map situationMessageParameters = parser.parse(tcContext.getProjectId(), message, context, (Collection)situation.getParsingRules());
            log.debug("situationMessageParameters parsing - is finished");
            spContext.putMessageParameters(situationMessageParameters.values());
            ExecutionServices.getTCContextService().setMessageParameters(context.tc(), situationMessageParameters);
        }
        SituationInstance instance = ExecutionServices.getSituationExecutorService().prepare(situation, context);
        if (isDefaultInboundSituation) {
            instance.setSituationId((BigInteger)situation.getID());
            instance.setOperationName(operation.getName());
            instance.setOperationId((BigInteger)operation.getID());
            instance.setSystemName(system.getName());
            instance.setSystemId((BigInteger)system.getID());
            String msg = String.format(TECH_SITUATION_STEP_FORMAT, system.getName(), operation.getName());
            instance.setErrorName("No suitable configured situation is found");
            instance.setErrorMessage("No suitable configured situation is found! Please check configuration and/or incoming message.\nOperation: " + operation.getName() + "\nSystem: " + system.getName() + " [" + system.getID() + "]");
            log.warn(msg);
            Report.warn((AbstractInstance)instance, (String)"Misconfigured situation is found", (String)msg);
            ExecutionServices.getSituationExecutorService().executeInstance(instance, null, spContext, null, situation, operation);
        } else {
            if (message.getFailedMessage() != null) {
                instance.setErrorMessage(message.getFailedMessage());
            }
            ExecutionServices.getSituationExecutorService().executeInstance(instance, null, spContext, null, situation);
        }
        return !isDefaultInboundSituation;
    }

    private void addParamsToSpContext(InstanceContext context, TcContext tcContext, Message message, String server) {
        context.put((Object)"sp.providerUrl", message.getConnectionProperties().get("providerUrl"));
        context.put((Object)"sp.environment", (Object)tcContext.getEnvironmentName());
        context.put((Object)"sp.server", (Object)(server != null ? server : ""));
    }

    private void doIntercept(TransportConfiguration transport, Message message) throws Exception {
        if (transport.getInterceptors() == null || transport.getInterceptors().isEmpty()) {
            return;
        }
        ArrayList interceptors = new ArrayList(transport.getInterceptors());
        interceptors.sort(Comparators.INTERCEPTOR_COMPARATOR);
        for (Interceptor interceptor : interceptors) {
            this.applyIfActive(interceptor, message);
        }
    }

    private void applyIfActive(Interceptor interceptor, Message message) throws Exception {
        if (interceptor.isActive()) {
            TransportInterceptor transportInterceptor = InterceptorClassLoader.getInstance().getInstanceClass(interceptor.getTypeName(), new Object[]{interceptor});
            transportInterceptor.apply(message);
            log.info("{} interceptor is applied", (Object)interceptor.getName());
        }
    }

    private void fillTcContextParams(InstanceContext context, Message message, TriggerConfiguration triggerConfiguration, OffsetDateTime started, TcContext tcContext) {
        tcContext.setPartNum(TCContextService.getCurrentPartitionNumberByProject((UUID)context.getProjectUuid()));
        if (tcContext.getInitiator() == null) {
            tcContext.setStartValidation(true);
            tcContext.setStartedFrom(StartedFrom.ITF_STUB);
        }
        if (tcContext.getTimeToLive() < 1L) {
            tcContext.setTimeToLive();
        }
        tcContext.setAndCalculateNeedToReportToItf();
        tcContext.put((Object)"executor_start_time", (Object)started.toString());
        tcContext.put((Object)"executor_endpoint", (Object)this.computeEndpointTagValue(message.getConnectionProperties().get("uriParams"), triggerConfiguration.getParent().getTypeName(), triggerConfiguration.getID()));
    }
}

