/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.config;

import org.aspectj.lang.annotation.Pointcut;
import org.qubership.automation.itf.core.execution.DefaultExecutorServiceProvider;
import org.qubership.automation.itf.core.execution.ExecutorServiceProvider;
import org.qubership.automation.itf.core.execution.ExecutorServiceProviderFactory;
import org.qubership.automation.itf.core.template.velocity.VelocityTemplateEngine;
import org.qubership.automation.itf.core.util.engine.TemplateEngine;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.generator.id.CounterIdGenerator;
import org.qubership.automation.itf.core.util.generator.id.IdGenerator;
import org.qubership.automation.itf.core.util.generator.id.IdGeneratorInterface;
import org.qubership.automation.itf.core.util.generator.prefix.IPrefixFactory;
import org.qubership.automation.itf.core.util.generator.prefix.PrefixGenerator;
import org.qubership.automation.itf.core.util.generator.prefix.StringPrefixFactory;
import org.qubership.automation.itf.ui.aspects.ErrorHandler;
import org.qubership.automation.itf.ui.aspects.TransactionAspect;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

@Configuration
public class RootConfiguration {
    @Value(value="${executor.thread.pool.size}")
    private int executorThreadPoolSize;
    @Value(value="${background.executor.thread.pool.size}")
    private int backgroundExecutorThreadPoolSize;
    @Value(value="${executor.thread.pool.core.size}")
    private int executorThreadPoolCoreSize;

    @Bean
    public CounterIdGenerator idGenerator() {
        return new CounterIdGenerator();
    }

    @Bean(name={"IdGenerator"})
    public IdGeneratorInterface getIDGenerator() {
        IdGenerator.init((IdGeneratorInterface)this.idGenerator());
        return IdGenerator.get();
    }

    @Bean
    public StringPrefixFactory prefixFactory() {
        return new StringPrefixFactory();
    }

    @Bean(name={"PrefixGenerator"})
    public IPrefixFactory getPrefixGenerator() {
        PrefixGenerator.init((IPrefixFactory)this.prefixFactory());
        return PrefixGenerator.get();
    }

    @Bean
    public VelocityTemplateEngine templateEngine() {
        return new VelocityTemplateEngine();
    }

    @Bean(name={"TemplateEngineFactory"})
    public TemplateEngine getTemplateEngineFactory() {
        TemplateEngineFactory.init((TemplateEngine)this.templateEngine());
        return TemplateEngineFactory.get();
    }

    @Bean
    public DefaultExecutorServiceProvider executionProvider(@Value(value="${executor.thread.pool.core.size}") int executorThreadPoolCoreSize, @Value(value="${executor.thread.pool.size}") int executorThreadPoolSize, @Value(value="${background.executor.thread.pool.size}") int backgroundExecutorThreadPoolSize) {
        return new DefaultExecutorServiceProvider(executorThreadPoolCoreSize, executorThreadPoolSize, backgroundExecutorThreadPoolSize);
    }

    @Bean(name={"ExecutorServiceProviderFactory"})
    public ExecutorServiceProvider getExecutorServiceProviderFactory() {
        ExecutorServiceProviderFactory.init((ExecutorServiceProvider)this.executionProvider(this.executorThreadPoolCoreSize, this.executorThreadPoolSize, this.backgroundExecutorThreadPoolSize));
        return ExecutorServiceProviderFactory.get();
    }

    @Bean
    public TransactionAspect transactionAspect() {
        return new TransactionAspect();
    }

    @Bean
    @Pointcut(value="within(org.qubership.automation.itf.ui..*)")
    public ErrorHandler errorHandler() {
        return new ErrorHandler();
    }

    @Bean
    public InternalResourceViewResolver viewResolver() {
        InternalResourceViewResolver viewResolver = new InternalResourceViewResolver();
        viewResolver.setPrefix("/");
        viewResolver.setSuffix(".html");
        return viewResolver;
    }
}

