/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.config;

import com.hazelcast.core.HazelcastInstance;
import java.beans.ConstructorProperties;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.qubership.atp.catalogue.openapi.dto.ProjectDto;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.diameter.connection.ConnectionFactory;
import org.qubership.automation.diameter.connection.DiameterConnection;
import org.qubership.automation.itf.core.execution.DaemonThreadPoolFactory;
import org.qubership.automation.itf.core.execution.ExecutorServiceProviderFactory;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvironmentManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.UpgradeHistoryObjectManager;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.versions.UpgradeHistory;
import org.qubership.automation.itf.core.report.impl.TemplateBasedLinkCollector;
import org.qubership.automation.itf.core.util.DiameterConnectionInfoProvider;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.eds.ExternalDataManagementService;
import org.qubership.automation.itf.core.util.holder.ActiveInterceptorHolder;
import org.qubership.automation.itf.core.util.holder.InterceptorHolder;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.report.ReportLinkCollector;
import org.qubership.automation.itf.core.util.transport.service.report.ReportAdapterStorage;
import org.qubership.automation.itf.executor.cache.CacheCleanerService;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.executor.service.TCContextService;
import org.qubership.automation.itf.integration.catalogue.CatalogueProjectFeignClient;
import org.qubership.automation.itf.ui.config.ContextTransport;
import org.qubership.automation.itf.ui.controls.util.MultiTenantProjectCollector;
import org.qubership.automation.itf.ui.util.EventTriggerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.listener.AbstractJmsListeningContainer;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UiContextListener {
    private static final Logger log = LoggerFactory.getLogger(UiContextListener.class);
    private final ApplicationContext myContext;
    private final ReportLinkCollector reportLinkCollector;
    private final ExternalDataManagementService externalDataManagementService;
    private final CacheCleanerService cacheCleanerService;
    private final ContextTransport contextTransport = new ContextTransport();
    private final CatalogueProjectFeignClient catalogueProjectFeignClient;
    private final LockManager lockManager;
    private final MultiTenantProjectCollector multiTenantProjectCollector;
    private final ProjectSettingsService projectSettingsService;
    private HazelcastInstance hazelcastInstance;
    @Value(value="${atp.multi-tenancy.enabled}")
    private Boolean multiTenancyEnabled;

    @Autowired(required=false)
    public void setHazelcastInstance(@Qualifier(value="hazelcastCacheInstance") HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    private void registerReportAdapters() {
        ReportAdapterStorage.getInstance().init();
    }

    @Transactional
    public void contextInitialized() {
        try {
            this.registerLinkCollectors();
            this.lockManager.executeWithLock("Init: upgradeHistory", this::upgradeHistory);
            Map<String, Collection<StubProject>> projects = this.multiTenantProjectCollector.collectProjects();
            this.refreshProjectSettingsAndInitCache(projects);
            this.activateEventTriggers(projects);
            this.lockManager.executeWithLock("Init: updateInitialEnvState", this::updateInitialEnvState);
            this.contextTransport.init();
            this.cacheCleanerService.startWorker();
            this.loadDataFromExternalStorage(projects);
        }
        catch (Exception e) {
            log.error("Error initialing object manager or modules", (Throwable)e);
        }
        try {
            this.registerInterceptors();
        }
        catch (Exception e) {
            log.error("Failed registering Interceptors", (Throwable)e);
        }
        try {
            this.registerReportAdapters();
        }
        catch (Exception e) {
            log.error("Failed registering Report Adapters", (Throwable)e);
        }
        try {
            this.startingJmsListenerContainer();
        }
        catch (Exception e) {
            log.error("Failed starting of Jms Listeners", (Throwable)e);
        }
        log.info("ITF-Executor service initialization completed");
    }

    public void closingAllDiameterConnections() {
        for (Map.Entry connectionEntry : ConnectionFactory.getAll().asMap().entrySet()) {
            DiameterConnection connection = (DiameterConnection)connectionEntry.getValue();
            try {
                if (connection.isOpen()) {
                    connection.close();
                }
                String connectionId = (String)connectionEntry.getKey();
                DiameterConnectionInfoProvider.getDiameterConnectionInfoCacheService().remove(connectionId);
            }
            catch (Exception e) {
                log.warn("Error closing diameter connection {}", (Object)connection.getChannel(), (Object)e);
            }
        }
    }

    @Transactional
    public void contextDestroyed() {
        log.info("ITF graceful shutdown is started...");
        ExecutorServiceProviderFactory.get().shutdown();
        ReportAdapterStorage.getInstance().terminateAll();
        DaemonThreadPoolFactory.getInstance().shutdown();
        if (this.hazelcastInstance != null) {
            this.hazelcastInstance.shutdown();
        }
        this.closingAllDiameterConnections();
        this.contextTransport.destroyed();
    }

    @EventListener
    public void init(ContextRefreshedEvent event) {
        if (event.getSource().equals(this.myContext)) {
            this.contextInitialized();
        }
    }

    @EventListener
    public void beforeCloseContext(ContextClosedEvent event) {
        if (event.getSource().equals(this.myContext)) {
            this.stopContexts();
            this.contextDestroyed();
        }
    }

    private void stopContexts() {
        TCContextService tcContextService = ExecutionServices.getTCContextService();
        List tcContexts = tcContextService.getTcContextCacheService().getAllTcContexts(Config.getConfig().getRunningHostname());
        for (TcContext context : tcContexts) {
            tcContextService.stop(context);
        }
    }

    private void startingJmsListenerContainer() {
        log.info("Getting JmsListenerContainerFactories...");
        DefaultJmsListenerContainerFactory factory = (DefaultJmsListenerContainerFactory)this.myContext.getBean("stubDefaultJmsListenerQueueContainerFactory");
        factory.setAutoStartup(true);
        factory = (DefaultJmsListenerContainerFactory)this.myContext.getBean("defaultJmsListenerTopicContainerFactory");
        factory.setAutoStartup(true);
        log.info("JmsListenerContainerFactories: setAutoStartup is set to true.");
        log.info("Getting JmsListenerEndpointRegistry...");
        JmsListenerEndpointRegistry jmsListenerEndpointRegistry = (JmsListenerEndpointRegistry)this.myContext.getBean(JmsListenerEndpointRegistry.class);
        log.info("Setting 'autoStartup' to true for all JMS Listeners...");
        jmsListenerEndpointRegistry.getListenerContainers().stream().forEach(messageListenerContainer -> ((AbstractJmsListeningContainer)messageListenerContainer).setAutoStartup(true));
        log.info("All JMS Listeners are ready. Starting jmsListenerEndpointRegistry...");
        jmsListenerEndpointRegistry.start();
        log.info("JmsListenerEndpointRegistry is started.");
    }

    private void registerLinkCollectors() {
        this.reportLinkCollector.registerCollectors(Collections.singletonList(TemplateBasedLinkCollector.class.getCanonicalName()));
    }

    private void upgradeHistory() {
        if (this.multiTenancyEnabled.booleanValue()) {
            Collection clusters = TenantContext.getTenantIds((boolean)true);
            for (String cluster : clusters) {
                TenantContext.setTenantInfo((String)cluster);
                this.doUpgradeHistory();
            }
            TenantContext.setDefaultTenantInfo();
        }
        this.doUpgradeHistory();
    }

    private void doUpgradeHistory() {
        UpgradeHistory upgradeHistories = ((UpgradeHistoryObjectManager)CoreObjectManager.getInstance().getSpecialManager(UpgradeHistory.class, UpgradeHistoryObjectManager.class)).findLastVersion();
        String currentBuildVersion = this.getCurrentBuildVersion().replaceFirst("application.version=", "");
        if (upgradeHistories == null || !currentBuildVersion.contains(upgradeHistories.getName())) {
            UpgradeHistory lastVersion = (UpgradeHistory)CoreObjectManager.getInstance().getManager(UpgradeHistory.class).create();
            lastVersion.setUpgradeDatetime(Timestamp.valueOf(LocalDateTime.now()));
            lastVersion.setName(currentBuildVersion);
            lastVersion.store();
        }
    }

    protected String getCurrentBuildVersion() {
        try {
            FileInputStream inFile = new FileInputStream("./buildVersion.properties");
            byte[] str = new byte[inFile.available()];
            inFile.read(str);
            return new String(str);
        }
        catch (Exception e) {
            log.error("Error while getting current build version", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateEventTriggers(Map<String, Collection<StubProject>> allProjects) {
        log.info("Activate event triggers...");
        ExecutorService threadPool = DaemonThreadPoolFactory.cachedThreadPool((int)10, (String)"EventTriggersActivationThread - ");
        ConcurrentLinkedQueue<Future<Boolean>> queue = new ConcurrentLinkedQueue<Future<Boolean>>();
        if (this.multiTenancyEnabled.booleanValue()) {
            this.activateEventTriggers(allProjects.get("additional"), false, threadPool, queue);
            TenantContext.setDefaultTenantInfo();
        }
        this.activateEventTriggers(allProjects.get("default"), true, threadPool, queue);
        log.info("All event triggers are sent to activation, waiting to finish...");
        while (!queue.isEmpty()) {
            Future future = (Future)queue.peek();
            if (future != null && (future.isCancelled() || future.isDone())) {
                queue.remove(future);
                continue;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(400L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            threadPool.shutdown();
            threadPool.awaitTermination(4000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException pending) {
        }
        finally {
            List<Runnable> pending = threadPool.shutdownNow();
            log.info("Activation of event triggers is completed. Pending (aborted) tasks: {}", (Object)pending.size());
        }
    }

    private void activateEventTriggers(Collection<? extends StubProject> projects, boolean isDefaultCluster, ExecutorService threadPool, Queue<Future<Boolean>> queue) {
        for (StubProject stubProject : projects) {
            Future<Boolean> future = threadPool.submit(() -> {
                try {
                    if (isDefaultCluster) {
                        TenantContext.setDefaultTenantInfo();
                    } else {
                        TenantContext.setTenantInfo((String)project.getUuid().toString());
                    }
                    log.info("Project {} / {}, '{}' is processed...", new Object[]{project.getID(), project.getUuid(), project.getName()});
                    EventTriggerHelper.activateEventTriggers((BigInteger)project.getID());
                    return true;
                }
                catch (Exception ex) {
                    log.warn("Exception while activation of event triggers, project {} / {}: {}", new Object[]{project.getID(), project.getUuid(), ex.getMessage()});
                    return false;
                }
            });
            queue.add(future);
        }
    }

    private void refreshProjectSettingsAndInitCache(Map<String, Collection<StubProject>> projects) {
        long processingTime;
        Map<UUID, ProjectDto> projectsFromCatalogue = this.getProjectsFromCatalogue();
        boolean invalidDataFromCatalogue = Objects.isNull(projectsFromCatalogue);
        if (this.multiTenancyEnabled.booleanValue()) {
            log.info("Filling project setting cache & refreshing from ATP Catalogue for ADDITIONAL clusters is started...");
            ArrayList<StubProject> additionalClustersProjects = new ArrayList<StubProject>(projects.get("additional"));
            additionalClustersProjects.sort(Comparator.comparing(proj -> proj.getID().toString()));
            processingTime = this.refreshProjectSettingsAndInitCache(additionalClustersProjects, projectsFromCatalogue, invalidDataFromCatalogue);
            log.info("Filling project setting cache & refreshing from ATP Catalogue for ADDITIONAL clusters is finished. It takes {}", (Object)String.format("%.3f", (double)processingTime / 1.0E9));
            TenantContext.setDefaultTenantInfo();
        }
        ArrayList<StubProject> defaultClustersProjects = new ArrayList<StubProject>(projects.get("default"));
        defaultClustersProjects.sort(Comparator.comparing(proj -> proj.getID().toString()));
        log.info("Filling project setting cache & refreshing from ATP Catalogue for DEFAULT cluster is started...");
        processingTime = this.refreshProjectSettingsAndInitCache(defaultClustersProjects, projectsFromCatalogue, invalidDataFromCatalogue);
        log.info("Filling project setting cache & refreshing from ATP Catalogue for DEFAULT cluster is finished. It takes {}", (Object)String.format("%.3f", (double)processingTime / 1.0E9));
    }

    private long refreshProjectSettingsAndInitCache(List<StubProject> itfProjects, Map<UUID, ProjectDto> projectsFromCatalogue, boolean invalidDataFromCatalogue) {
        long processTime = 0L;
        for (StubProject itfProject : itfProjects) {
            TenantContext.setTenantInfo((String)itfProject.getUuid().toString());
            long startTime = System.nanoTime();
            this.projectSettingsService.initCache(itfProject);
            this.refreshProjectSettings(itfProject, projectsFromCatalogue, invalidDataFromCatalogue);
            processTime += System.nanoTime() - startTime;
        }
        return processTime;
    }

    private void refreshProjectSettings(StubProject itfProject, Map<UUID, ProjectDto> projectsFromCatalogue, boolean invalidDataFromCatalogue) {
        if (invalidDataFromCatalogue) {
            return;
        }
        try {
            log.info("Project {} / {}, '{}' is processed...", new Object[]{itfProject.getID(), itfProject.getUuid(), itfProject.getName()});
            this.refreshProjectSettingsFromCatalogue(itfProject, projectsFromCatalogue);
        }
        catch (Exception ex) {
            log.warn("Exception while refreshing project settings from atp-catalogue, project {} / {}: {}", new Object[]{itfProject.getID(), itfProject.getUuid(), ex.getMessage()});
        }
    }

    protected void refreshProjectSettingsFromCatalogue(StubProject project, Map<UUID, ProjectDto> projects) {
        if (Objects.isNull(project.getUuid())) {
            log.warn("Project {}, '{}': UUID is not set, refreshing from catalogue can't be performed.", project.getID(), (Object)project.getName());
            return;
        }
        if (!projects.containsKey(project.getUuid())) {
            log.warn("Project {} / {}, '{}': There is no such project UUID in the atp-catalogue!", new Object[]{project.getID(), project.getUuid(), project.getName()});
            return;
        }
        ProjectDto projectDto = projects.get(project.getUuid());
        String newDatasetFormat = projectDto.getDatasetFormat().toString();
        if (StringUtils.isBlank((CharSequence)newDatasetFormat)) {
            log.error("'datasetFormat' property is missed or invalid. Response: {}", (Object)projectDto);
            return;
        }
        BigInteger projectId = (BigInteger)project.getID();
        String currentDatasetFormat = this.projectSettingsService.get((Object)projectId, "dataset.service.datasetFormat");
        if (newDatasetFormat.equals(currentDatasetFormat)) {
            log.info("Old and New DatasetFormat settings are the same: {}", (Object)newDatasetFormat);
            return;
        }
        this.projectSettingsService.update((Object)projectId, "dataset.service.datasetFormat", newDatasetFormat, true);
        log.info("DatasetFormat setting is changed to {}", (Object)newDatasetFormat);
    }

    private void loadDataFromExternalStorage(Map<String, Collection<StubProject>> projects) throws IOException {
        log.info("Loading files from external storage...");
        List projectsList = projects.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        for (StubProject proj : projectsList) {
            try {
                log.info("Project {} / {}, '{}' is processed...", new Object[]{proj.getID(), proj.getUuid(), proj.getName()});
                Set files = this.externalDataManagementService.getExternalStorageService().getFilesInfoByProject(proj.getUuid());
                this.externalDataManagementService.getFileManagementService().save((Collection)files);
                log.info("Project {} / {}, '{}' - {} files are loaded.", new Object[]{proj.getID(), proj.getUuid(), proj.getName(), files.size()});
            }
            catch (Exception ex) {
                log.warn("Exception while loading files for project {} / {}: {}", new Object[]{proj.getID(), proj.getUuid(), ex.getMessage()});
            }
        }
        this.externalDataManagementService.getFileManagementService().save((Collection)this.externalDataManagementService.getExternalStorageService().getKeyStoreFileInfo());
        log.info("Loading files from external storage is completed.");
    }

    private void updateInitialEnvState() {
        if (this.multiTenancyEnabled.booleanValue()) {
            Collection tenantIdsPerCluster = TenantContext.getTenantIds((boolean)true);
            for (String tenantId : tenantIdsPerCluster) {
                TenantContext.setTenantInfo((String)tenantId);
                this.doUpdateInitialEnvState();
            }
            TenantContext.setDefaultTenantInfo();
        }
        this.doUpdateInitialEnvState();
    }

    private void doUpdateInitialEnvState() {
        ((EnvironmentManager)CoreObjectManager.getInstance().getSpecialManager(Environment.class, EnvironmentManager.class)).updateInitialEnvState();
    }

    private void registerInterceptors() {
        log.info("Registration of interceptors' modules is started...");
        InterceptorHolder.getInstance();
        log.info("Registration of interceptors' modules is completed.");
        if (this.multiTenancyEnabled.booleanValue()) {
            Collection tenantIdsPerCluster = TenantContext.getTenantIds((boolean)true);
            for (String tenantId : tenantIdsPerCluster) {
                TenantContext.setTenantInfo((String)tenantId);
                this.doRegisterActiveInterceptors(tenantId);
            }
            TenantContext.setDefaultTenantInfo();
        }
        this.doRegisterActiveInterceptors("default");
    }

    private void doRegisterActiveInterceptors(String tenantId) {
        log.info("Registration of active interceptors is started for '{}' tenant...", (Object)tenantId);
        ActiveInterceptorHolder.getInstance().fillActiveInterceptorHolder();
        log.info("Registration of active interceptors is completed for '{}' tenant.", (Object)tenantId);
    }

    @Nullable
    private Map<UUID, ProjectDto> getProjectsFromCatalogue() {
        try {
            Set projectsFromCatalogue = (Set)this.catalogueProjectFeignClient.getAll().getBody();
            return Objects.nonNull(projectsFromCatalogue) ? projectsFromCatalogue.stream().collect(Collectors.toMap(ProjectDto::getUuid, Function.identity())) : null;
        }
        catch (Exception ex) {
            log.error("Exception while getting projects list from atp-catalogue or collect its to map. Refresh projects settings will be skipped.", (Throwable)ex);
            return null;
        }
    }

    @ConstructorProperties(value={"myContext", "reportLinkCollector", "externalDataManagementService", "cacheCleanerService", "catalogueProjectFeignClient", "lockManager", "multiTenantProjectCollector", "projectSettingsService"})
    public UiContextListener(ApplicationContext myContext, ReportLinkCollector reportLinkCollector, ExternalDataManagementService externalDataManagementService, CacheCleanerService cacheCleanerService, CatalogueProjectFeignClient catalogueProjectFeignClient, LockManager lockManager, MultiTenantProjectCollector multiTenantProjectCollector, ProjectSettingsService projectSettingsService) {
        this.myContext = myContext;
        this.reportLinkCollector = reportLinkCollector;
        this.externalDataManagementService = externalDataManagementService;
        this.cacheCleanerService = cacheCleanerService;
        this.catalogueProjectFeignClient = catalogueProjectFeignClient;
        this.lockManager = lockManager;
        this.multiTenantProjectCollector = multiTenantProjectCollector;
        this.projectSettingsService = projectSettingsService;
    }
}

