/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.generator.id.UniqueIdGenerator;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.service.export.ItfReplicationService;
import org.qubership.automation.itf.ui.services.javers.history.HistoryRestoreService;
import org.qubership.automation.itf.ui.services.javers.history.HistoryRetrieveService;
import org.qubership.automation.itf.ui.services.javers.history.model.HistoryCompareEntity;
import org.qubership.automation.itf.ui.services.javers.history.model.HistoryEntityConstant;
import org.qubership.automation.itf.ui.services.javers.history.model.HistoryItemResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JaversController {
    private final HistoryRestoreService historyRestoreService;
    private final HistoryRetrieveService historyRetrieveService;
    private final ItfReplicationService itfReplicationService;

    @Autowired
    public JaversController(HistoryRestoreService historyRestoreService, HistoryRetrieveService historyRetrieveService, ItfReplicationService itfReplicationService) {
        this.historyRestoreService = historyRestoreService;
        this.historyRetrieveService = historyRetrieveService;
        this.itfReplicationService = itfReplicationService;
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/api/v1/history/{projectUuid}/{type}/{id}"})
    public ResponseEntity<HistoryItemResponse> getAllHistory(@PathVariable(value="projectUuid") UUID projectUuid, @PathVariable(value="type") HistoryEntityConstant type, @PathVariable(value="id") BigInteger objectId, @RequestParam(value="offset", defaultValue="0", required=false) Integer offset, @RequestParam(value="limit", defaultValue="10", required=false) Integer limit) {
        HistoryItemResponse response = this.historyRetrieveService.getAllHistory(objectId, type.getEntityClass(), offset, limit);
        return ResponseEntity.ok((Object)response);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/api/v1/entityversioning/{projectUuid}/{type}/{id}"})
    public ResponseEntity<List<HistoryCompareEntity>> getEntitiesByVersion(@PathVariable(value="projectUuid") UUID projectUuid, @PathVariable(value="type") HistoryEntityConstant type, @PathVariable(value="id") BigInteger objectId, @RequestParam(value="versions") List<Long> versions) {
        return ResponseEntity.ok(this.historyRetrieveService.getEntitiesByVersions(objectId, type.getEntityClass(), versions));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @PostMapping(value={"/api/v1/history/restore/{projectUuid}/{type}/{id}/revision/{revision}"})
    public ResponseEntity<Void> restoreToRevision(@PathVariable(value="projectUuid") UUID projectUuid, @PathVariable(value="type") HistoryEntityConstant type, @PathVariable(value="id") BigInteger objectId, @PathVariable(value="revision") Long revision) {
        LinkedList<Runnable> executeAfter = this.historyRestoreService.restoreToRevision(objectId, type.getEntityClass(), revision, projectUuid);
        executeAfter.forEach(Runnable::run);
        return ResponseEntity.ok().build();
    }

    @Transactional
    @PostMapping(value={"/history/testReplicate"})
    public void testHistoryForReplicate(@RequestParam(value="systemId") BigInteger systemId, BigInteger projectId) {
        System system = (System)CoreObjectManager.getInstance().getManager(System.class).getById((Object)systemId);
        SystemTemplate template = new SystemTemplate();
        template.setID((Object)UniqueIdGenerator.generate());
        template.setParent(system);
        template.setName("Test History For Replication");
        template.setText("TEST");
        template.setVersion((Object)1);
        template.setProjectId(projectId);
        this.itfReplicationService.replicateStorableWithHistory((Storable)template);
    }
}

