/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.common;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;

public abstract class AbstractStorableController<T extends Storable> {
    protected boolean haveUsages(T object, Map<String, Map<String, String>> result, Boolean ignoreUsages) {
        Collection uInfo;
        HashMap successMap = result.get("success");
        HashMap failureMap = result.get("failure");
        if (successMap == null) {
            successMap = Maps.newHashMap();
            result.put("success", successMap);
        }
        if (failureMap == null) {
            failureMap = Maps.newHashMap();
            result.put("failure", failureMap);
        }
        if (!ignoreUsages.booleanValue() && (uInfo = ControllerHelper.getManager(object.getClass()).findUsages(object)) != null && !uInfo.isEmpty()) {
            StringBuilder str = new StringBuilder();
            for (UsageInfo item : uInfo) {
                str.append("as [").append(item.getProperty()).append("] in the object: ").append(item.getReferer().toString()).append("\n");
            }
            failureMap.put(object.getID().toString(), "Object " + object.getName() + " [" + object.getID() + "] can't be deleted because it is used:\n" + str.toString() + ". TRYING TO DELETE MULTIPLE CROSS-REFERENCED OBJECTS AT ONCE MAY PRODUCE TABLE LOCKS.");
            if (successMap.isEmpty()) {
                result.remove("success");
            }
            return true;
        }
        successMap.put(object.getID().toString(), "Object " + object.getName() + " [" + object.getID() + "] can be deleted " + (ignoreUsages != false ? "(usages are not checked)" : "(no usages)"));
        if (failureMap.isEmpty()) {
            result.remove("failure");
        }
        return false;
    }
}

