/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.eci;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.openapi.dto.ConnectionDto;
import org.qubership.atp.environments.openapi.dto.ConnectionFullVer1ViewDto;
import org.qubership.atp.environments.openapi.dto.EnvironmentFullVer1ViewDto;
import org.qubership.atp.environments.openapi.dto.EnvironmentNameViewDto;
import org.qubership.atp.environments.openapi.dto.EnvironmentResDto;
import org.qubership.atp.environments.openapi.dto.ProjectFullVer1ViewDto;
import org.qubership.atp.environments.openapi.dto.ProjectNameViewDto;
import org.qubership.atp.environments.openapi.dto.SystemFullVer1ViewDto;
import org.qubership.atp.environments.openapi.dto.SystemNameViewDto;
import org.qubership.automation.itf.integration.environments.AtpEnvironmentsConnectionFeignClient;
import org.qubership.automation.itf.integration.environments.AtpEnvironmentsEnvironmentFeignClient;
import org.qubership.automation.itf.integration.environments.AtpEnvironmentsProjectFeignClient;
import org.qubership.automation.itf.integration.environments.AtpEnvironmentsSystemFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/eci/api"})
public class ECIAPIController {
    @Autowired
    private AtpEnvironmentsEnvironmentFeignClient atpEnvironmentsEnvironmentFeignClient;
    @Autowired
    private AtpEnvironmentsSystemFeignClient atpEnvironmentsSystemFeignClient;
    @Autowired
    private AtpEnvironmentsProjectFeignClient atpEnvironmentsProjectFeignClient;
    @Autowired
    private AtpEnvironmentsConnectionFeignClient atpEnvironmentsConnectionFeignClient;

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/projects"})
    public List<ProjectNameViewDto> getProjectsShort(@RequestParam(value="projectUuid") UUID projectUuid) {
        List projectNameViewDtoList = (List)this.atpEnvironmentsProjectFeignClient.getAllShort(Boolean.valueOf(false)).getBody();
        return projectNameViewDtoList;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/project"})
    public ProjectFullVer1ViewDto getProject(@RequestParam(value="ecProjectId") UUID ecProjectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        ProjectFullVer1ViewDto projectFullVer1ViewDto = (ProjectFullVer1ViewDto)this.atpEnvironmentsProjectFeignClient.getProject(ecProjectId, Boolean.valueOf(false)).getBody();
        return projectFullVer1ViewDto;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/environments"})
    public List<EnvironmentNameViewDto> getEnvironmentsShort(@RequestParam(value="ecProjectId") UUID ecProjectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        List environmentNameViewDtoList = (List)this.atpEnvironmentsProjectFeignClient.getEnvironmentsShort(ecProjectId).getBody();
        return environmentNameViewDtoList;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/environments/full"})
    public List<EnvironmentResDto> getEnvironmentsFull(@RequestParam(value="ecProjectId") UUID ecProjectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        List environmentResDtoList = (List)this.atpEnvironmentsProjectFeignClient.getEnvironments(ecProjectId, Boolean.valueOf(true)).getBody();
        return environmentResDtoList;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/environment"})
    public EnvironmentFullVer1ViewDto getEnvironment(@RequestParam(value="ecEnvId") UUID ecEnvId, @RequestParam(value="projectUuid") UUID projectUuid) {
        EnvironmentFullVer1ViewDto environmentFullVer1ViewDto = (EnvironmentFullVer1ViewDto)this.atpEnvironmentsEnvironmentFeignClient.getEnvironment(ecEnvId, Boolean.valueOf(false)).getBody();
        return environmentFullVer1ViewDto;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/environment/full"})
    public EnvironmentFullVer1ViewDto getEnvironmentFull(@RequestParam(value="ecEnvId") UUID ecEnvId, @RequestParam(value="projectUuid") UUID projectUuid) {
        EnvironmentFullVer1ViewDto environmentFullVer1ViewDto = (EnvironmentFullVer1ViewDto)this.atpEnvironmentsEnvironmentFeignClient.getEnvironment(ecEnvId, Boolean.valueOf(true)).getBody();
        return environmentFullVer1ViewDto;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/systems"})
    public List<SystemNameViewDto> getSystemsShort(@RequestParam(value="ecEnvId") UUID ecEnvId, @RequestParam(value="projectUuid") UUID projectUuid) {
        List systemNameViewDtoList = (List)this.atpEnvironmentsEnvironmentFeignClient.getSystemsShort(ecEnvId).getBody();
        return systemNameViewDtoList;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/system"})
    public SystemFullVer1ViewDto getSystem(@RequestParam(value="ecSystemId") UUID ecSystemId, @RequestParam(value="projectUuid") UUID projectUuid) {
        SystemFullVer1ViewDto systemFullVer1ViewDto = (SystemFullVer1ViewDto)this.atpEnvironmentsSystemFeignClient.getSystem(ecSystemId, Boolean.valueOf(false)).getBody();
        return systemFullVer1ViewDto;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/system/full"})
    public SystemFullVer1ViewDto getSystemFull(@RequestParam(value="ecSystemId") UUID ecSystemId, @RequestParam(value="projectUuid") UUID projectUuid) {
        SystemFullVer1ViewDto systemFullVer1ViewDto = (SystemFullVer1ViewDto)this.atpEnvironmentsSystemFeignClient.getSystem(ecSystemId, Boolean.valueOf(true)).getBody();
        return systemFullVer1ViewDto;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/connections"})
    public List<ConnectionFullVer1ViewDto> getConnections(@RequestParam(value="ecSystemId") UUID ecSystemId, @RequestParam(value="projectUuid") UUID projectUuid) throws IOException {
        List connectionFullVer1ViewDtoList = (List)this.atpEnvironmentsSystemFeignClient.getSystemConnections(ecSystemId, Boolean.valueOf(false)).getBody();
        return connectionFullVer1ViewDtoList;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/connection"})
    public ConnectionDto getConnection(@RequestParam(value="ecConnectionId") UUID ecConnectionId, @RequestParam(value="projectUuid") UUID projectUuid) {
        ConnectionDto connectionDto = (ConnectionDto)this.atpEnvironmentsConnectionFeignClient.getConnection(ecConnectionId, Boolean.valueOf(false)).getBody();
        return connectionDto;
    }
}

