/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities;

import com.google.common.collect.Collections2;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.communication.EventTriggerBriefInfo;
import org.qubership.automation.itf.core.model.communication.StubUser;
import org.qubership.automation.itf.core.model.communication.message.EventTriggerSyncActivationRequest;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.OperationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.util.helper.ClassResolver;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.TriggerProvider;
import org.qubership.automation.itf.ui.controls.common.AbstractController;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.UIIds;
import org.qubership.automation.itf.ui.messages.UITypeList;
import org.qubership.automation.itf.ui.messages.objects.eventtrigger.UIEventTrigger;
import org.qubership.automation.itf.ui.messages.objects.parents.UIIdentifiedObject;
import org.qubership.automation.itf.ui.util.EventTriggerHelper;
import org.qubership.automation.itf.ui.util.UIHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tags(value={@Tag(name="Trigger queries API.", description="Trigger API to query trigger. Called through REST."), @Tag(name="Trigger commands API.", description="Trigger API to control trigger. Called through REST.")})
public class EventTriggerController
extends AbstractController<UIEventTrigger, EventTrigger> {
    private static final Logger log = LoggerFactory.getLogger(EventTriggerController.class);

    public static EventTriggerSyncActivationRequest synchronizeTriggers(Collection<UIEventTrigger> uiEventTriggers, TriggerProvider parent) {
        ArrayList triggersToDeactivate = new ArrayList();
        ArrayList<EventTriggerBriefInfo> triggersToReactivate = new ArrayList<EventTriggerBriefInfo>();
        if (uiEventTriggers != null) {
            List uiEventTriggersIds = uiEventTriggers.stream().map(UIIdentifiedObject::getId).collect(Collectors.toList());
            Collection triggersToDelete = parent.getAllEventTriggers().stream().filter(eventTrigger -> !uiEventTriggersIds.contains(String.valueOf(eventTrigger.getID()))).map(eventTrigger -> new EventTriggerBriefInfo((BigInteger)eventTrigger.getID(), eventTrigger.getType())).collect(Collectors.toList());
            triggersToDeactivate.addAll(triggersToDelete);
            Collection triggersToAdd = Collections2.filter(uiEventTriggers, input -> StringUtils.isBlank((CharSequence)input.getId()));
            for (UIEventTrigger uiEventTrigger : triggersToAdd) {
                EventTrigger trigger = EventTriggerHelper.create((Storable)parent, uiEventTrigger.getType());
                uiEventTrigger.fillTrigger(trigger);
                if (trigger instanceof OperationEventTrigger) {
                    parent.getOperationEventTriggers().add((OperationEventTrigger)trigger);
                    continue;
                }
                parent.getSituationEventTriggers().add((SituationEventTrigger)trigger);
            }
            Collection triggersToModify = Collections2.filter(uiEventTriggers, input -> StringUtils.isNotBlank((CharSequence)input.getId()));
            for (UIEventTrigger uiEventTrigger : triggersToModify) {
                String eventTriggerId = uiEventTrigger.getId();
                EventTrigger trigger = EventTriggerHelper.getByIdAndType(eventTriggerId, uiEventTrigger.getType());
                if (trigger != null) {
                    uiEventTrigger.fillTrigger(trigger);
                    triggersToReactivate.add(new EventTriggerBriefInfo(new BigInteger(eventTriggerId), uiEventTrigger.getType()));
                    continue;
                }
                log.warn("Event trigger not found by id {}; skipped", (Object)eventTriggerId);
            }
        }
        return new EventTriggerSyncActivationRequest(triggersToDeactivate, triggersToReactivate, new StubUser(""), "");
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRIGGER.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/trigger"}, method={RequestMethod.GET})
    @Operation(summary="GetTrigger", description="Retrieve trigger by id", tags={"Trigger queries API."})
    @AuditAction(auditAction="Get Event Trigger by id {{#id}} in the project {{#projectUuid}}")
    public UIEventTrigger get(@RequestParam(value="id") String id, @RequestParam(value="type") String type, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        EventTrigger eventTrigger = StringUtils.isEmpty((CharSequence)type) ? EventTriggerHelper.getById(id) : EventTriggerHelper.getByIdAndType(id, type);
        ControllerHelper.throwExceptionIfNull((Storable)eventTrigger, "", id, EventTrigger.class, "get Event Trigger by id");
        return new UIEventTrigger(eventTrigger);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRIGGER.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/trigger/state"}, method={RequestMethod.GET})
    @Operation(summary="GetTriggerState", description="Retrieve trigger status by id", tags={"Trigger queries API."})
    @AuditAction(auditAction="Get Event Trigger state by id {{#id}} in the project {{#projectUuid}}")
    public String getState(@RequestParam(value="id") String id, @RequestParam(value="type") String type, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        EventTrigger eventTrigger = StringUtils.isEmpty((CharSequence)type) ? EventTriggerHelper.getById(id) : EventTriggerHelper.getByIdAndType(id, type);
        ControllerHelper.throwExceptionIfNull((Storable)eventTrigger, "", id, EventTrigger.class, "get Event Trigger by id");
        return "state: " + eventTrigger.getState();
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRIGGER.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/trigger/types"}, method={RequestMethod.GET})
    @Operation(summary="GetTriggerTypes", description="Retrieve trigger types", tags={"Trigger queries API."})
    @AuditAction(auditAction="Get Event Trigger types supported, project {{#projectUuid}}")
    public UITypeList getTypes(@RequestParam(value="projectUuid") UUID projectUuid) {
        Map objectTriggersTypes = ClassResolver.getInstance().resolveByInterface(EventTrigger.class);
        return UIHelper.convertMapOfTypeToUITypeList(objectTriggersTypes);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRIGGER.getName(),#projectUuid, 'CREATE')")
    @RequestMapping(value={"/trigger"}, method={RequestMethod.POST})
    @Operation(summary="CreateTrigger", description="Create trigger by specified situation ID", tags={"Trigger commands API."})
    @AuditAction(auditAction="Create Event Trigger under Situation id {{#parentId}} in the project {{#projectUuid}}")
    public UIEventTrigger create(@RequestParam(value="parentId") String parentId, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        Situation situation = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).getById((Object)parentId);
        ControllerHelper.throwExceptionIfNull((Storable)situation, "", parentId, Situation.class, "get Situation by id");
        SituationEventTrigger eventTrigger = (SituationEventTrigger)CoreObjectManager.getInstance().getManager(SituationEventTrigger.class).create((Storable)situation, "Situation Event Trigger");
        situation.getSituationEventTriggers().add(eventTrigger);
        return new UIEventTrigger((EventTrigger)eventTrigger);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRIGGER.getName(),#projectUuid, 'UPDATE')")
    @RequestMapping(value={"/trigger"}, method={RequestMethod.PUT})
    @Operation(summary="UpdateTrigger", description="Update trigger by EditRequest", tags={"Trigger commands API."})
    @AuditAction(auditAction="Update Event Trigger by id {{#id}} in the project {{#projectUuid}}")
    public void put(@RequestParam(value="id") String id, @RequestBody UIEventTrigger editRequest, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        EventTrigger eventTrigger = EventTriggerHelper.getByIdAndType(id, editRequest.getType());
        ControllerHelper.throwExceptionIfNull((Storable)eventTrigger, "", id, EventTrigger.class, "get Event Trigger by id");
        editRequest.fillTrigger(eventTrigger);
        eventTrigger.store();
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRIGGER.getName(),#projectUuid, 'DELETE')")
    @RequestMapping(value={"/trigger"}, method={RequestMethod.DELETE})
    @Operation(summary="DeleteTriggers", description="Delete triggers by id. Currently disabled.", tags={"Trigger queries API."})
    @AuditAction(auditAction="Delete Event Triggers in the project {{#projectUuid}}")
    @Deprecated
    public void delete(@RequestParam(value="system", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid, @RequestBody UIIds deleteRequest) throws IOException {
    }

    @Override
    protected Class<EventTrigger> _getGenericUClass() {
        return EventTrigger.class;
    }

    @Override
    protected UIEventTrigger _newInstanceTClass(EventTrigger object) {
        return new UIEventTrigger(object);
    }

    @Override
    protected Storable _getParent(String parentId) {
        return CoreObjectManager.getInstance().getManager(Situation.class).getById((Object)parentId);
    }
}

